/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.app.r.base;

import com.ef_prime.rflow.core.util.ScriptBuilder;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class RUtility {
    public static final String NEWLINE = "\n";
    public static final char NEWLINE_C = '\n';
    public static String EMPTY_STRING = "\"\"";
    public static final String NULL = "NULL";
    public static final String TRUE = "TRUE";
    public static final String FALSE = "FALSE";
    public static final String NA = "NA";
    public static final String BROWSE_NEXT = "n";
    public static final String BROWSE_CONTINUE = "c";
    public static final String BROWSE_CONTINUE_ = "cont";
    public static final String BROWSE_QUIT = "Q";
    public static final String BROWSE_STEP = "s";
    public static final String BROWSE_FINISH = "f";
    public static final String BROWSE_WHERE = "where";
    public static final String BROWSE_HELP = "help";
    public static final String RDATA_EXTENSION = "RData";
    private static final Set<String> OPERATORS = new HashSet<String>();
    private static final Set<String> BROWSER_COMMANDS = new HashSet<String>();
    private static final Set<String> KEYWORDS = new HashSet<String>();
    private static Map<String, String> javaToREncoding;
    private static Map<String, String> rToJavaEncoding;
    public static final String[] JAVA_COMPATIBLE_ENCODINGS;

    public static String globalEnv() {
        return "globalenv()";
    }

    public static String appendNewLine(String object) {
        if (!((String)object).endsWith(NEWLINE)) {
            object = (String)object + NEWLINE;
        }
        return object;
    }

    public static String trimNewLine(String string) {
        if (string.endsWith(NEWLINE)) {
            string = string.substring(0, string.length() - NEWLINE.length());
        }
        return string;
    }

    public static String toComment(String string, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(" ");
        }
        StringBuilder stringBuilder2 = new StringBuilder();
        stringBuilder2.append("#").append((CharSequence)stringBuilder);
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            stringBuilder2.append(c);
            if (c != '\n' || i == string.length() - 1) continue;
            stringBuilder2.append("#").append((CharSequence)stringBuilder);
        }
        return RUtility.appendNewLine(stringBuilder2.toString());
    }

    public static String assign(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (!StringUtils.isEmpty((CharSequence)string)) {
            stringBuilder.append(string).append(" <- ");
        }
        stringBuilder.append(string2);
        return stringBuilder.toString();
    }

    public static String combineCharacters(Collection<String> collection) {
        return RUtility.combineCharacters(collection.toArray(new String[collection.size()]));
    }

    public static String combineCharacters(String ... stringArray) {
        if (stringArray.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("c(");
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuilder.append(RUtility.quote(stringArray[i]));
            if (i == stringArray.length - 1) continue;
            stringBuilder.append(", ");
            if (i % 5 != 4) continue;
            stringBuilder.append(NEWLINE);
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public static String combineCharactersBase(String ... stringArray) {
        String string = RUtility.combineCharacters(stringArray);
        return string.isEmpty() ? string : "base::" + string;
    }

    public static String combine(String ... stringArray) {
        if (stringArray.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("c(");
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuilder.append(stringArray[i]);
            if (i == stringArray.length - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public static String combine(Collection<String> collection) {
        if (collection.isEmpty()) {
            return "";
        }
        if (collection.size() == 1) {
            return collection.iterator().next();
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("c(");
        Iterator<String> iterator = collection.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public static String args(Collection<String> collection) {
        return RUtility.args(collection.toArray(new String[collection.size()]));
    }

    public static String args(String ... stringArray) {
        if (stringArray.length % 2 != 0) {
            throw new IllegalArgumentException("paramAndValues must be even length: paramAndValues.length % 2 != 0");
        }
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<Integer> hashSet2 = new HashSet<Integer>();
        for (int i = stringArray.length - 1; i >= 0; i -= 2) {
            String string = stringArray[i - 1];
            if (string.isEmpty()) continue;
            if (hashSet.contains(string)) {
                hashSet2.add(i - 1);
                continue;
            }
            hashSet.add(string);
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length; i += 2) {
            if (hashSet2.contains(i)) continue;
            String string = stringArray[i];
            String string2 = stringArray[i + 1];
            if (string2 == null || string2.isEmpty()) continue;
            stringBuilder.append((String)(string.isEmpty() ? string2 : string + " = " + string2));
            stringBuilder.append(", ");
        }
        if (stringBuilder.length() > 0) {
            return stringBuilder.substring(0, stringBuilder.length() - 2);
        }
        return stringBuilder.toString();
    }

    public static String assignFunction(String string, String string2, Collection<String> collection) {
        return RUtility.assignFunction(string, string2, collection.toArray(new String[collection.size()]));
    }

    public static String assignFunction(String string, String string2, String ... stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        if (!StringUtils.isEmpty((CharSequence)string)) {
            stringBuilder.append(string).append(" <- ");
        }
        stringBuilder.append(RUtility.function(string2, stringArray));
        return stringBuilder.toString();
    }

    public static String assignFunction(String string, String string2, List<String> list, String ... stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Collections.addAll(arrayList, stringArray);
        arrayList.addAll(list);
        return RUtility.assignFunction(string, string2, arrayList);
    }

    public static String func(String string, String string2) {
        return new StringBuilder(string.length() + string2.length() + 2).append(string).append("(").append(string2).append(")").toString();
    }

    public static String function(String string, Collection<String> collection) {
        return string + "(" + RUtility.args(collection) + ")";
    }

    public static String function(String string, String ... stringArray) {
        return string + "(" + RUtility.args(stringArray) + ")";
    }

    public static String function(String string, List<String> list, String ... stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Collections.addAll(arrayList, stringArray);
        arrayList.addAll(list);
        return string + "(" + RUtility.args(arrayList) + ")";
    }

    public static String removeBackticks(String string) {
        if (string.startsWith("`") && string.endsWith("`") && string.length() > 1) {
            if (string.length() == 2) {
                return "";
            }
            string = string.substring(1, string.length() - 1);
            string = string.replaceAll("\\\\`", "`");
            return string.replaceAll("\\\\\\\\", "\\\\");
        }
        return string;
    }

    public static String quote(String string) {
        string = string.replaceAll("\\\\", "\\\\\\\\");
        string = string.replaceAll("\"", "\\\\\"");
        return "\"" + string + "\"";
    }

    public static String unquote(String string) {
        if (string.startsWith("\"") && string.endsWith("\"") && string.length() > 1) {
            if (string.length() == 2) {
                return "";
            }
            string = string.substring(1, string.length() - 1);
            string = string.replaceAll("\\\\\"", "\"");
            return string.replaceAll("\\\\\\\\", "\\\\");
        }
        return string;
    }

    public static String quoteWithBackticks(String string) {
        string = string.replaceAll("\\\\", "\\\\\\\\");
        string = string.replaceAll("`", "\\\\`");
        return "`" + string + "`";
    }

    public static String unbacktick(String string) {
        if (string.startsWith("`") && string.endsWith("`") && string.length() > 1) {
            if (string.length() == 2) {
                return "";
            }
            string = string.substring(1, string.length() - 1);
            string = string.replaceAll("\\\\`", "`");
            return string.replaceAll("\\\\\\\\", "\\\\");
        }
        return string;
    }

    public static String path(String string) {
        return string.replace(File.separatorChar, '/');
    }

    public static String quotedPath(String string) {
        return RUtility.quote(RUtility.path(string));
    }

    public static boolean toBoolean(String string) {
        if (string.equals(TRUE) || string.equals("T")) {
            return true;
        }
        if (string.equals(FALSE) || string.equals("F")) {
            return false;
        }
        throw new IllegalArgumentException("can not parse to boolean");
    }

    public static String toRBoolean(boolean bl) {
        return bl ? TRUE : FALSE;
    }

    public static String replaceFileSeparatorRtoSystem(String string) {
        return string.replace('/', File.separatorChar);
    }

    public static boolean isEmptyString(String string) {
        if (string == null || string.isEmpty()) {
            return true;
        }
        return string.equals(EMPTY_STRING) || string.equals("''");
    }

    public static String toREncoding(Charset charset, String string) {
        if (charset == null) {
            return string;
        }
        if (javaToREncoding == null) {
            javaToREncoding = RUtility.createJavatoREncodings();
        }
        String string2 = charset.name();
        string2 = javaToREncoding.getOrDefault(string2, string2);
        return string2;
    }

    public static Charset toJavaEncoding(String string) {
        string = RUtility.unquote(string);
        if (rToJavaEncoding == null) {
            rToJavaEncoding = RUtility.createRtoJavaEncodings();
        }
        string = rToJavaEncoding.getOrDefault(string, string);
        try {
            return Charset.forName(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String override(String string, String string2, String string3, String string4) {
        string = RUtility.quote(string);
        String string5 = "as.environment(" + RUtility.quote("package:" + string3) + ")";
        string4 = RUtility.quote(string4);
        ScriptBuilder scriptBuilder = new ScriptBuilder(NEWLINE);
        scriptBuilder.appendLn(RUtility.function("unlockBinding", "sym", string, "env", string5));
        scriptBuilder.appendLn(RUtility.function("assignInNamespace", "x", string, "value", string2, "ns", string4));
        scriptBuilder.appendLn(RUtility.function("assign", "x", string, "value", string2, "envir", string5));
        scriptBuilder.appendLn(RUtility.function("lockBinding", "sym", string, "env", string5));
        return scriptBuilder.toString();
    }

    public static boolean isOperator(String string) {
        return OPERATORS.contains(string);
    }

    public static String titleForScript(String string) {
        int n;
        int n2 = 100;
        String string2 = string.substring(0, Math.min(n2, string.length()));
        String string3 = string2.replaceFirst("\\s*#?\\s*", "");
        boolean bl = string2.length() != string3.length();
        string2 = string3;
        if (bl && (n = string2.indexOf(10)) >= 0) {
            string2 = string2.substring(0, n);
        }
        string2 = string2.trim();
        string2 = string2.replaceAll(NEWLINE, " ");
        return string2;
    }

    public static String suppressOutput(String string) {
        return "local({capture.output(ret <- " + string + "); ret})";
    }

    public static boolean isBrowserCommand(String string) {
        return BROWSER_COMMANDS.contains(string);
    }

    public static String extractName(String string) {
        int n = string.lastIndexOf(36) + 1;
        if (n > 0 && n < string.length()) {
            string = string.substring(n);
            string = RUtility.unbacktick(string);
        }
        if (string.endsWith("]]") && (n = string.lastIndexOf("[[") + 2) > 0 && n < string.length() - 2) {
            string = string.substring(n, string.length() - 2);
            string = RUtility.unquote(string);
        }
        return string;
    }

    public static String evalq(String string) {
        return "evalq(" + string + ", envir = parent.frame())";
    }

    public static String evalq(String string, String string2) {
        return "evalq(" + string + ", envir = parent.frame(n = " + string2 + "))";
    }

    public static String makeName(String string) {
        if (string.isEmpty()) {
            return "X";
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        if (string.charAt(0) == '.') {
            if (string.length() > 1 && RUtility.isDigit(string.charAt(1))) {
                bl = true;
            }
        } else if (!RUtility.isAlphaNum(string.charAt(0)) || RUtility.isDigit(string.charAt(0))) {
            bl = true;
        }
        if (bl) {
            stringBuilder.append('X');
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c != '.' && c != '_' && !RUtility.isAlphaNum(c)) {
                stringBuilder.append('.');
                continue;
            }
            stringBuilder.append(c);
        }
        if (KEYWORDS.contains(stringBuilder.toString())) {
            stringBuilder.append('.');
        }
        return stringBuilder.toString();
    }

    private static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private static boolean isAlphaNum(char c) {
        return Character.isAlphabetic(c) || Character.isDigit(c);
    }

    private static Map<String, String> createJavatoREncodings() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("windows-31j", "CP932");
        hashMap.put("x-IBM1025", "cp1025");
        hashMap.put("x-IBM737", "cp737");
        hashMap.put("x-IBM874", "cp874");
        hashMap.put("x-IBM875", "cp875");
        hashMap.put("x-IBM949", "cp949");
        hashMap.put("x-IBM950", "cp950");
        hashMap.put("x-Johab", "johab");
        hashMap.put("x-MacArabic", "MacArabic");
        hashMap.put("x-MacCentralEurope", "MacCentralEurope");
        hashMap.put("x-MacCroatian", "MacCroatian");
        hashMap.put("x-MacCyrillic", "MacCyrillic");
        hashMap.put("x-MacGreek", "MacGreek");
        hashMap.put("x-MacHebrew", "MacHebrew");
        hashMap.put("x-MacIceland", "MacIceland");
        hashMap.put("x-MacRoman", "MacRoman");
        hashMap.put("x-MacRomania", "MacRomania");
        hashMap.put("x-MacThai", "MacThai");
        hashMap.put("x-MacTurkish", "MacTurkish");
        hashMap.put("x-MacUkraine", "MacUkraine");
        hashMap.put("x-mswin-936", "ms936");
        hashMap.put("x-windows-50221", "cp50221");
        hashMap.put("x-windows-874", "windows-874");
        hashMap.put("CESU-8", "");
        hashMap.put("IBM1047", "");
        hashMap.put("IBM868", "");
        hashMap.put("IBM918", "");
        hashMap.put("ISO-2022-CN", "");
        hashMap.put("ISO-2022-JP-2", "");
        hashMap.put("JIS_X0201", "");
        hashMap.put("JIS_X0212-1990", "");
        hashMap.put("TIS-620", "");
        hashMap.put("x-Big5-HKSCS-2001", "");
        hashMap.put("x-Big5-Solaris", "");
        hashMap.put("x-euc-jp-linux", "");
        hashMap.put("x-EUC-TW", "");
        hashMap.put("x-eucJP-Open", "");
        hashMap.put("x-IBM1006", "");
        hashMap.put("x-IBM1046", "");
        hashMap.put("x-IBM1097", "");
        hashMap.put("x-IBM1098", "");
        hashMap.put("x-IBM1112", "");
        hashMap.put("x-IBM1122", "");
        hashMap.put("x-IBM1123", "");
        hashMap.put("x-IBM1124", "");
        hashMap.put("x-IBM1166", "");
        hashMap.put("x-IBM1364", "");
        hashMap.put("x-IBM1381", "");
        hashMap.put("x-IBM1383", "");
        hashMap.put("x-IBM300", "");
        hashMap.put("x-IBM33722", "");
        hashMap.put("x-IBM833", "");
        hashMap.put("x-IBM834", "");
        hashMap.put("x-IBM856", "");
        hashMap.put("x-IBM921", "");
        hashMap.put("x-IBM922", "");
        hashMap.put("x-IBM930", "");
        hashMap.put("x-IBM933", "");
        hashMap.put("x-IBM935", "");
        hashMap.put("x-IBM937", "");
        hashMap.put("x-IBM939", "");
        hashMap.put("x-IBM942", "");
        hashMap.put("x-IBM942C", "");
        hashMap.put("x-IBM943", "");
        hashMap.put("x-IBM943C", "");
        hashMap.put("x-IBM948", "");
        hashMap.put("x-IBM949C", "");
        hashMap.put("x-IBM964", "");
        hashMap.put("x-IBM970", "");
        hashMap.put("x-ISCII91", "");
        hashMap.put("x-ISO-2022-CN-CNS", "");
        hashMap.put("x-ISO-2022-CN-GB", "");
        hashMap.put("x-iso-8859-11", "");
        hashMap.put("x-JIS0208", "");
        hashMap.put("x-JISAutoDetect", "");
        hashMap.put("x-MacDingbat", "");
        hashMap.put("x-MacSymbol", "");
        hashMap.put("x-MS932_0213", "");
        hashMap.put("x-MS950-HKSCS", "");
        hashMap.put("x-MS950-HKSCS-XP", "");
        hashMap.put("x-PCK", "");
        hashMap.put("x-SJIS_0213", "");
        hashMap.put("x-UTF-16LE-BOM", "");
        hashMap.put("X-UTF-32BE-BOM", "");
        hashMap.put("X-UTF-32LE-BOM", "");
        hashMap.put("x-windows-50220", "");
        hashMap.put("x-windows-949", "");
        hashMap.put("x-windows-950", "");
        hashMap.put("x-windows-iso2022jp", "");
        return hashMap;
    }

    private static Map<String, String> createRtoJavaEncodings() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("BIG-5", "Big5");
        hashMap.put("BIG-FIVE", "Big5");
        hashMap.put("CP932", "windows-31j");
        hashMap.put("iso_8859_13", "ISO-8859-13");
        hashMap.put("iso_8859_15", "ISO-8859-15");
        hashMap.put("iso_8859_2", "ISO-8859-2");
        hashMap.put("iso_8859_3", "ISO-8859-3");
        hashMap.put("iso_8859_4", "ISO-8859-4");
        hashMap.put("iso_8859_5", "ISO-8859-5");
        hashMap.put("iso_8859_6", "ISO-8859-6");
        hashMap.put("iso_8859_7", "ISO-8859-7");
        hashMap.put("iso_8859_8", "ISO-8859-8");
        hashMap.put("iso_8859_9", "ISO-8859-9");
        hashMap.put("ISO2022-JP", "ISO-2022-JP");
        hashMap.put("iso2022-kr", "ISO-2022-KR");
        hashMap.put("latin-9", "ISO-8859-15");
        hashMap.put("UTF16BE", "UTF-16BE");
        hashMap.put("UTF16LE", "UTF-16LE");
        hashMap.put("UTF32BE", "UTF-32BE");
        hashMap.put("UTF32LE", "UTF-32LE");
        return hashMap;
    }

    static {
        JAVA_COMPATIBLE_ENCODINGS = new String[]{"ASCII", "", "Big5", "", "Big5-HKSCS", "", "CP932", "Windows Shift_JIS", "EUC-JP", "", "EUC-KR", "", "GB18030", "", "GB2312", "", "GBK", "", "IBM-Thai", "", "IBM00858", "", "IBM01140", "", "IBM01141", "", "IBM01142", "", "IBM01143", "", "IBM01144", "", "IBM01145", "", "IBM01146", "", "IBM01147", "", "IBM01148", "", "IBM01149", "", "IBM037", "", "IBM1026", "", "IBM273", "", "IBM277", "", "IBM278", "", "IBM280", "", "IBM284", "", "IBM285", "", "IBM290", "", "IBM297", "", "IBM420", "", "IBM424", "", "IBM437", "", "IBM500", "", "IBM775", "", "IBM850", "", "IBM852", "", "IBM855", "", "IBM857", "", "IBM860", "", "IBM861", "", "IBM862", "", "IBM863", "", "IBM864", "", "IBM865", "", "IBM866", "", "IBM869", "", "IBM870", "", "IBM871", "", "ISO-2022-JP", "", "ISO-2022-KR", "", "ISO-8859-1", "Latin 1", "ISO-8859-13", "", "ISO-8859-15", "", "ISO-8859-2", "", "ISO-8859-3", "", "ISO-8859-4", "", "ISO-8859-5", "", "ISO-8859-6", "", "ISO-8859-7", "", "ISO-8859-8", "", "ISO-8859-9", "", "KOI8-R", "", "KOI8-U", "", "MacArabic", "", "MacCentralEurope", "", "MacCroatian", "", "MacCyrillic", "", "MacGreek", "", "MacHebrew", "", "MacIceland", "", "MacRoman", "", "MacRomania", "", "MacThai", "", "MacTurkish", "", "MacUkraine", "", "Shift_JIS", "", "US-ASCII", "", "UTF-16", "", "UTF-16BE", "", "UTF-16LE", "", "UTF-32", "", "UTF-32BE", "", "UTF-32LE", "", "UTF-8", "", "cp1025", "", "cp50221", "", "cp737", "", "cp874", "", "cp875", "", "cp949", "", "cp950", "", "johab", "", "ms936", "", "windows-1250", "", "windows-1251", "", "windows-1252", "", "windows-1253", "", "windows-1254", "", "windows-1255", "", "windows-1256", "", "windows-1257", "", "windows-1258", "", "windows-31j", "", "windows-874", ""};
        Collections.addAll(OPERATORS, "+", "-", "*", "/", "%", "^", ">", ">=", "<", "<=", "==", "!=", "!", "&", "|", "~", "->", "<-", "$", ":", "%%", "%*%", "%/%", "%in%", "%o%", "%x%", "(", "{", "[", "[[");
        Collections.addAll(BROWSER_COMMANDS, BROWSE_NEXT, BROWSE_CONTINUE, BROWSE_CONTINUE_, BROWSE_QUIT, BROWSE_STEP, BROWSE_FINISH, BROWSE_WHERE, BROWSE_HELP);
        Collections.addAll(KEYWORDS, NULL, NA, TRUE, FALSE, "Inf", "NaN", "NA_integer_", "NA_real_", "NA_character_", "NA_complex_", "function", "while", "repeat", "for", "if", "in", "else", "next", "break", "...");
    }
}

