/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.app.r.base;

import com.ef_prime.rflow.core.app.r.base.AppRpc;
import com.ef_prime.rflow.core.app.r.base.AppRpcInterface;
import com.ef_prime.rflow.core.app.r.base.R;
import com.ef_prime.rflow.core.app.r.base.RClient;
import com.ef_prime.rflow.core.app.r.base.RServerRpcClient;
import com.ef_prime.rflow.core.app.r.base.RServerRpcInterface;
import java.net.ServerSocket;
import java.nio.ByteBuffer;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.TServer;
import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.transport.TFramedTransport;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.apache.thrift.transport.TTransportFactory;
import org.rosuda.JRI.RMainLoopCallbacks;
import org.rosuda.REngine.REXP;
import org.rosuda.REngine.REXPMismatchException;
import org.rosuda.REngine.REXPNull;
import org.rosuda.REngine.Rserve.protocol.REXPFactory;

public class RpcRClient
extends RClient {
    private static REXP REXP_NULL = new REXPNull();
    private RServerRpcClient client;

    public RpcRClient(ServerSocket serverSocket, String string, int n, RMainLoopCallbacks rMainLoopCallbacks, boolean bl, long l, String[] stringArray) throws Exception {
        AppRpc appRpc = new AppRpc(rMainLoopCallbacks);
        AppRpcInterface.Processor<AppRpc> processor = new AppRpcInterface.Processor<AppRpc>(appRpc);
        TServerSocket tServerSocket = new TServerSocket(serverSocket);
        TThreadPoolServer.Args args = new TThreadPoolServer.Args((TServerTransport)tServerSocket);
        args.processor(processor);
        args.transportFactory((TTransportFactory)new TFramedTransport.Factory());
        args.protocolFactory((TProtocolFactory)new TBinaryProtocol.Factory(true, true));
        TThreadPoolServer tThreadPoolServer = new TThreadPoolServer(args);
        new Thread(new Runnable(){
            final /* synthetic */ TServer val$server;
            {
                this.val$server = tServer;
            }

            @Override
            public void run() {
                this.val$server.serve();
            }
        }, "App RPC Server").start();
        TSocket tSocket = new TSocket(string, n);
        tSocket = new TFramedTransport((TTransport)tSocket);
        TBinaryProtocol tBinaryProtocol = new TBinaryProtocol((TTransport)tSocket, true, true);
        this.client = new RServerRpcClient(new RServerRpcInterface.Client((TProtocol)tBinaryProtocol));
        appRpc.setServerRpcClient(this.client);
        if (bl) {
            R.sessionManager().start(this, this.getEnv(), string, serverSocket.getLocalPort(), n, l, stringArray);
        }
    }

    public void connect() throws TTransportException {
        this.initialized = false;
        this.client.reconnect();
    }

    @Override
    public boolean isEmbedded() {
        return false;
    }

    @Override
    public boolean isConnected() {
        return this.client.isConnected();
    }

    private static REXP byteBufferToREXP(ByteBuffer byteBuffer, boolean bl) throws REXPMismatchException {
        if (!byteBuffer.hasRemaining()) {
            return null;
        }
        if (bl) {
            REXPFactory rEXPFactory = new REXPFactory();
            rEXPFactory.parseREXP(byteBuffer.array(), byteBuffer.position());
            return rEXPFactory.getREXP();
        }
        return REXP_NULL;
    }

    @Override
    public REXP eval(String string, boolean bl) {
        if (string == null) {
            return null;
        }
        try {
            ByteBuffer byteBuffer = this.client.eval(string, bl);
            return RpcRClient.byteBufferToREXP(byteBuffer, bl);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public REXP idleEval(String string, boolean bl) {
        if (string == null) {
            return null;
        }
        try {
            ByteBuffer byteBuffer = this.client.idleEval(string, bl);
            return RpcRClient.byteBufferToREXP(byteBuffer, bl);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public REXP timeoutEval(String string, long l, boolean bl) {
        if (string == null) {
            return null;
        }
        try {
            ByteBuffer byteBuffer = this.client.timeoutEval(string, l, bl);
            return RpcRClient.byteBufferToREXP(byteBuffer, bl);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public void startMainLoop() throws Exception {
        this.client.startMainLoop();
    }

    @Override
    public void stop() throws Exception {
        this.client.stop();
    }

    @Override
    public void idle() {
    }

    @Override
    public void shutdown() throws Exception {
        this.client.shutdown();
    }

    @Override
    public boolean isBrowseEnabled() {
        return true;
    }

    @Override
    protected String getGDClass() {
        return "com/ef_prime/rflow/core/app/r/base/RServerGD";
    }
}

