/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.app.r.console;

import com.ef_prime.rflow.core.app.r.base.RUtility;
import com.ef_prime.rflow.core.app.r.console.Command;
import com.ef_prime.rflow.core.app.r.console.ConsoleEntry;
import java.util.ArrayList;
import java.util.List;

public class BasicCommand
extends Command {
    private String command;
    private boolean isComment;
    private String displayCommand;
    private Command[] commands;
    private boolean debugCommand;

    public BasicCommand(String string) {
        this(string, false, null);
    }

    public BasicCommand(String string, boolean bl, String string2) {
        this.isComment = bl;
        this.displayCommand = string2;
        this.command = string;
    }

    public BasicCommand(Command[] commandArray) {
        for (Command command : commandArray) {
            command.setParent(this);
        }
        this.commands = commandArray;
    }

    @Override
    public String getCommand() {
        if (this.getCommandFunction() == null) {
            return RUtility.appendNewLine(this.command);
        }
        return RUtility.appendNewLine(this.getCommandFunction().apply(this.command));
    }

    @Override
    public String getDisplayCommand() {
        if (this.displayCommand == null) {
            return this.getCommand();
        }
        return this.displayCommand;
    }

    @Override
    public boolean hasCommand() {
        return this.command != null;
    }

    @Override
    public boolean isComment() {
        return this.isComment;
    }

    @Override
    public Command[] getCommands() {
        return this.commands;
    }

    @Override
    public int getCommandCount() {
        if (this.commands == null) {
            return 0;
        }
        return this.commands.length;
    }

    @Override
    public List<ConsoleEntry> getConsoleEntries() {
        if (this.commands == null) {
            return super.getConsoleEntries();
        }
        ArrayList<ConsoleEntry> arrayList = new ArrayList<ConsoleEntry>();
        for (Command command : this.commands) {
            arrayList.addAll(command.getConsoleEntries());
        }
        return arrayList.isEmpty() ? null : arrayList;
    }

    @Override
    public boolean checkError() {
        if (this.debugCommand) {
            return false;
        }
        return super.checkError();
    }

    @Override
    public boolean addToHistory() {
        if (this.debugCommand) {
            return false;
        }
        return super.addToHistory();
    }

    public void setCommand(String string) {
        this.setCommand(string, false, null);
    }

    public void setCommand(String string, boolean bl, String string2) {
        this.isComment = bl;
        this.displayCommand = string2;
        this.command = string;
        this.commands = null;
    }

    public void setAsDebugCommand(boolean bl) {
        this.debugCommand = bl;
    }
}

