/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.app.r.console;

import com.ef_prime.rflow.core.app.r.console.CommandListener;
import com.ef_prime.rflow.core.app.r.console.ConsoleEntry;
import com.ef_prime.rflow.core.app.r.console.ElementType;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public abstract class Command {
    public static final int ADD_TO_HISTORY_DEFAULT = 0;
    public static final int ADD_TO_HISTORY_YES = 1;
    public static final int ADD_TO_HISTORY_NO = 2;
    private Command parent;
    private boolean checkError = false;
    private boolean ignoreError = false;
    private boolean isStarted = false;
    private boolean isFinished = false;
    private boolean isErrorOccurred = false;
    private boolean isDiscarded = false;
    private List<CommandListener> listeners;
    private Function<String, String> func;
    private boolean captureOutput;
    private String output;
    private int addToHistory = 0;
    private boolean noRecover = false;
    private List<ConsoleEntry> consoleEntries;

    public abstract String getCommand();

    public abstract Command[] getCommands();

    public abstract boolean hasCommand();

    public abstract int getCommandCount();

    public String getDisplayCommand() {
        return this.getCommand();
    }

    public Command getParent() {
        return this.parent;
    }

    public void setParent(Command command) {
        this.parent = command;
    }

    public void setCommandFunction(Function<String, String> function) {
        this.func = function;
    }

    public Function<String, String> getCommandFunction() {
        return this.func;
    }

    public void setCaptureOutput(boolean bl) {
        this.captureOutput = bl;
    }

    public boolean isCaptureOutput() {
        return this.captureOutput;
    }

    public String getOutput() {
        return this.output;
    }

    public void setOutput(String string) {
        this.output = string;
    }

    public void addConsoleEntry(ConsoleEntry consoleEntry) {
        if (this.consoleEntries == null) {
            this.consoleEntries = new ArrayList<ConsoleEntry>();
            this.consoleEntries.add(new ConsoleEntry("> ", ElementType.PROMPT));
        }
        this.consoleEntries.add(consoleEntry);
    }

    public List<ConsoleEntry> getConsoleEntries() {
        return this.consoleEntries;
    }

    public boolean isRoot() {
        return this.getParent() == null;
    }

    public boolean isComment() {
        return false;
    }

    public boolean checkError() {
        return this.checkError && !this.isComment();
    }

    public void setCheckError(boolean bl) {
        this.checkError = bl;
        if (this.getCommands() != null) {
            for (Command command : this.getCommands()) {
                command.setCheckError(bl);
            }
        }
    }

    public boolean ignoreError() {
        return this.ignoreError;
    }

    public void setIgnoreError(boolean bl) {
        this.ignoreError = bl;
    }

    public boolean noRecover() {
        return this.noRecover;
    }

    public void setNoRecover(boolean bl) {
        this.noRecover = bl;
    }

    public boolean addToHistory() {
        for (Command command = this; command != null; command = command.getParent()) {
            if (command.isCaptureOutput()) {
                return false;
            }
            if (command.getAddToHisotry() == 0) continue;
            return command.getAddToHisotry() == 1;
        }
        return true;
    }

    public int getAddToHisotry() {
        return this.addToHistory;
    }

    public void setAddToHistory(int n) {
        this.addToHistory = n;
    }

    public void start() {
        if (!this.isStarted) {
            this.isStarted = true;
            this.fireCommandStart();
        }
    }

    public final synchronized void finish() {
        if (!this.isDiscarded) {
            this.fireCommandFinished();
            this.isFinished = true;
            this.notifyAll();
        }
    }

    public void cancel() {
        if (!this.isFinished) {
            this.fireCommandCanceled();
        }
    }

    public void error() {
        this.isErrorOccurred = true;
        Command command = this;
        if (!command.isRoot()) {
            command.getParent().error();
        }
        this.fireErrorOccurred();
    }

    public synchronized void discard() {
        if (!this.isFinished) {
            this.fireCommandDiscarded();
            this.isDiscarded = true;
            this.notifyAll();
        }
    }

    public final synchronized void waitForCommand() {
        while (!this.isDone()) {
            try {
                this.wait(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public synchronized void waitForCommand(long l) throws InterruptedException {
        this.wait(l);
    }

    public synchronized boolean isDone() {
        return this.isFinished || this.isDiscarded;
    }

    public boolean isError() {
        return this.isErrorOccurred;
    }

    public final synchronized void addCommandListener(CommandListener commandListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<CommandListener>();
        }
        this.listeners.add(commandListener);
    }

    public final synchronized void removeCommandListener(CommandListener commandListener) {
        if (this.listeners != null) {
            this.listeners.remove(commandListener);
        }
    }

    public List<CommandListener> getCommandListeners() {
        if (this.listeners == null) {
            this.listeners = new ArrayList<CommandListener>();
        }
        return this.listeners;
    }

    protected final void fireCommandFinished() {
        if (this.listeners != null) {
            for (CommandListener commandListener : this.listeners) {
                commandListener.commandFinished(this);
            }
        }
    }

    protected final void fireCommandStart() {
        if (this.listeners != null) {
            for (CommandListener commandListener : this.listeners) {
                commandListener.commandStart(this);
            }
        }
    }

    protected final void fireCommandCanceled() {
        if (this.listeners != null) {
            for (CommandListener commandListener : this.listeners) {
                commandListener.commandCanceled(this);
            }
        }
    }

    protected final void fireErrorOccurred() {
        if (this.listeners != null) {
            for (CommandListener commandListener : this.listeners) {
                commandListener.errorOccurred(this);
            }
        }
    }

    protected final void fireCommandDiscarded() {
        if (this.listeners != null) {
            for (CommandListener commandListener : this.listeners) {
                commandListener.commandDiscarded(this);
            }
        }
    }
}

