/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.app.r.console;

import com.ef_prime.rflow.core.app.r.console.Command;
import com.ef_prime.rflow.core.app.r.console.CommandBuildFailedException;
import com.ef_prime.rflow.core.app.r.console.CommandListener;
import com.ef_prime.rflow.core.app.r.console.CommandPackListener;
import java.util.ArrayList;
import java.util.List;

public abstract class CommandPack {
    private boolean discardable = true;
    private List<CommandPackListener> listeners;
    private boolean isStarted = false;
    private boolean isFinished = false;
    private boolean isCanceled = false;
    private boolean isErrorOccurred = false;
    private boolean isDiscarded = false;

    public abstract boolean hasNext();

    public Command nextCommand() throws CommandBuildFailedException {
        Command command = this.createNextCommand();
        if (command != null) {
            command.addCommandListener(new CommandListener(){

                @Override
                public void errorOccurred(Command command) {
                    CommandPack.this.error();
                }

                @Override
                public void commandCanceled(Command command) {
                    CommandPack.this.cancel();
                }

                @Override
                public void commandStart(Command command) {
                    CommandPack.this.start();
                }

                @Override
                public void commandFinished(Command command) {
                }

                @Override
                public void commandDiscarded(Command command) {
                }
            });
        }
        return command;
    }

    protected abstract Command createNextCommand() throws CommandBuildFailedException;

    public abstract Command checkNextCommand() throws CommandBuildFailedException;

    public void setDiscardable(boolean bl) {
        this.discardable = bl;
    }

    public boolean isDiscardable() {
        return this.discardable;
    }

    public boolean isStarted() {
        return this.isStarted;
    }

    public void start() {
        if (!this.isStarted) {
            this.isStarted = true;
            this.fireCommandStart();
        }
    }

    public synchronized boolean isCanceled() {
        return this.isCanceled;
    }

    public synchronized void cancel() {
        if (!(this.isCanceled || this.isFinished || this.isDiscarded)) {
            this.isCanceled = true;
            this.fireCommandCanceled();
        }
    }

    public boolean isErrorOccurred() {
        return this.isErrorOccurred;
    }

    public void error() {
        this.isErrorOccurred = true;
        this.fireErrorOccurred();
    }

    public final synchronized boolean isFinished() {
        return this.isFinished;
    }

    public synchronized void finish() {
        if (!(this.isCanceled || this.isFinished || this.isDiscarded)) {
            this.isFinished = true;
            this.fireCommandFinished();
            this.notifyAll();
        }
    }

    public synchronized void discard() {
        if (!(this.isCanceled || this.isFinished || this.isDiscarded)) {
            this.isDiscarded = true;
            this.fireCommandDiscarded();
            this.notifyAll();
        }
    }

    public final synchronized void waitForCommand() {
        while (!(this.isCanceled || this.isFinished || this.isDiscarded)) {
            try {
                this.wait(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public final synchronized void addCommandListener(CommandPackListener commandPackListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<CommandPackListener>();
        }
        this.listeners.add(commandPackListener);
    }

    public final synchronized void removeCommandPackListener(CommandPackListener commandPackListener) {
        if (this.listeners != null) {
            this.listeners.remove(commandPackListener);
        }
    }

    public void fireCommandPending() {
        if (this.listeners != null) {
            for (CommandPackListener commandPackListener : this.listeners) {
                commandPackListener.commandPending(this);
            }
        }
    }

    protected final void fireCommandFinished() {
        if (this.listeners != null) {
            for (CommandPackListener commandPackListener : this.listeners) {
                commandPackListener.commandFinished(this);
            }
        }
    }

    protected final void fireCommandStart() {
        if (this.listeners != null) {
            for (CommandPackListener commandPackListener : this.listeners) {
                commandPackListener.commandStart(this);
            }
        }
    }

    protected final void fireCommandCanceled() {
        if (this.listeners != null) {
            for (CommandPackListener commandPackListener : this.listeners) {
                commandPackListener.commandCanceled(this);
            }
        }
    }

    protected final void fireErrorOccurred() {
        if (this.listeners != null) {
            for (CommandPackListener commandPackListener : this.listeners) {
                commandPackListener.errorOccurred(this);
            }
        }
    }

    protected final void fireCommandDiscarded() {
        if (this.listeners != null) {
            for (CommandPackListener commandPackListener : this.listeners) {
                commandPackListener.commandDiscarded(this);
            }
        }
    }
}

