/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.app.r.console;

import com.ef_prime.rflow.core.app.r.console.BasicCommand;
import com.ef_prime.rflow.core.app.r.console.BasicCommandPack;
import com.ef_prime.rflow.core.app.r.console.Command;
import com.ef_prime.rflow.core.app.r.console.CommandBuildFailedException;
import com.ef_prime.rflow.core.app.r.console.CommandPack;
import com.ef_prime.rflow.core.app.r.console.CommandPackListener;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;

public class CommandReceiver {
    private String name;
    private List<CommandPackListener> listeners = new ArrayList<CommandPackListener>();
    private Queue<Command> commands = new ArrayDeque<Command>();
    private Queue<CommandPack> commandPacks = new ArrayDeque<CommandPack>();
    private boolean commandArrived = false;
    private boolean active = true;

    public CommandReceiver(String string) {
        this.name = string;
    }

    public CommandReceiver createReceiver(String string) {
        CommandReceiver commandReceiver = new CommandReceiver(string);
        return commandReceiver;
    }

    public String getName() {
        return this.name;
    }

    public synchronized void checkFinished() {
        while (!this.commands.isEmpty() && !this.commands.peek().hasCommand()) {
            this.commands.poll().finish();
        }
        if (this.commands.isEmpty()) {
            while (!this.commandPacks.isEmpty() && !this.commandPacks.peek().hasNext()) {
                this.commandPacks.poll().finish();
            }
            if (this.commandPacks.isEmpty()) {
                this.commandArrived = false;
            }
        }
    }

    public synchronized BasicCommand waitForCommand() throws CommandBuildFailedException {
        if (!this.commandArrived) {
            return null;
        }
        if (!this.active) {
            return new BasicCommand("");
        }
        return this.getCommand();
    }

    public synchronized void waitFor() {
        try {
            this.wait(50L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public synchronized BasicCommand getCommand() throws CommandBuildFailedException {
        Command command = null;
        if (this.commands.isEmpty() && !this.commandPacks.isEmpty()) {
            while (!this.commandPacks.isEmpty() && (command = this.commandPacks.peek().nextCommand()) == null) {
                this.commandPacks.poll().finish();
            }
            if (command != null) {
                this.addCommand(this.commands, command);
                return this.getCommand();
            }
            this.commandArrived = false;
            return null;
        }
        if (!this.commands.isEmpty()) {
            command = this.commands.poll();
        }
        if (command == null) {
            return null;
        }
        if (this.commands.isEmpty() && this.commandPacks.isEmpty()) {
            this.commandArrived = false;
        }
        if (!command.hasCommand()) {
            command.finish();
            if (this.commandArrived) {
                return this.getCommand();
            }
            return null;
        }
        return (BasicCommand)command;
    }

    public synchronized boolean isCommand() {
        return this.commandArrived;
    }

    public synchronized Command checkNextCommand() throws CommandBuildFailedException {
        if (!this.commands.isEmpty()) {
            for (Command object2 : this.commands) {
                if (!object2.hasCommand()) continue;
                return object2;
            }
        }
        if (this.commandPacks.isEmpty()) {
            return null;
        }
        Object object3 = null;
        Iterator iterator = this.commandPacks.iterator();
        while (iterator.hasNext() && (object3 = ((CommandPack)iterator.next()).checkNextCommand()) == null) {
        }
        if (object3 == null) {
            return null;
        }
        ArrayDeque<Command> arrayDeque = new ArrayDeque<Command>();
        this.addCommand(arrayDeque, (Command)object3);
        for (Command command : arrayDeque) {
            if (!command.hasCommand()) continue;
            return command;
        }
        return null;
    }

    private synchronized void addCommand(Queue<Command> queue, Command command) {
        Command[] commandArray = command.getCommands();
        if (commandArray != null) {
            for (int i = 0; i < commandArray.length; ++i) {
                this.addCommand(queue, commandArray[i]);
            }
        }
        queue.offer(command);
    }

    public synchronized void passCommand(String string) {
        this.passCommand(new BasicCommand(string));
    }

    public synchronized void passCommand(Command command) {
        this.passCommand(new BasicCommandPack(command));
    }

    public synchronized void passCommand(CommandPack commandPack) {
        for (CommandPackListener commandPackListener : this.listeners) {
            commandPack.addCommandListener(commandPackListener);
        }
        this.commandArrived = true;
        commandPack.fireCommandPending();
        this.commandPacks.offer(commandPack);
        this.notifyAll();
    }

    public void dispose() {
        this.checkFinished();
        this.discardAllCommand();
        this.active = false;
    }

    public synchronized void discardAllCommand() {
        for (Command object : this.commands) {
            object.discard();
        }
        this.commands.clear();
        Iterator iterator = this.commandPacks.iterator();
        while (iterator.hasNext()) {
            CommandPack commandPack = (CommandPack)iterator.next();
            if (!commandPack.isDiscardable()) continue;
            commandPack.discard();
            iterator.remove();
        }
        this.commandArrived = !this.commandPacks.isEmpty();
    }

    public void addCommandPackListener(CommandPackListener commandPackListener) {
        this.listeners.add(commandPackListener);
    }

    public void removeCommandPackListener(CommandPackListener commandPackListener) {
        this.listeners.remove(commandPackListener);
    }

    public synchronized void notifyReceiver() {
        this.notifyAll();
    }
}

