/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.app.r.console;

import com.ef_prime.rflow.core.app.r.base.R;
import com.ef_prime.rflow.core.app.r.base.RClient;
import com.ef_prime.rflow.core.app.r.base.RUtility;
import com.ef_prime.rflow.core.app.r.base.SentenceInfo;
import com.ef_prime.rflow.core.app.r.console.BasicCommand;
import com.ef_prime.rflow.core.app.r.console.Command;
import com.ef_prime.rflow.core.app.r.console.CommandAdapter;
import com.ef_prime.rflow.core.app.r.console.CommandListener;
import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;

public class CommandUtility {
    public static Command getLineSeparatedCommand(RClient rClient, String string) {
        if (StringUtils.isBlank((CharSequence)string)) {
            return new BasicCommand("\n");
        }
        SentenceInfo[] sentenceInfoArray = rClient.parseToNodes(string, true);
        if (sentenceInfoArray == null || sentenceInfoArray.length == 0) {
            return new BasicCommand(string);
        }
        Command[] commandArray = new BasicCommand[sentenceInfoArray.length];
        for (int i = 0; i < commandArray.length; ++i) {
            SentenceInfo sentenceInfo = sentenceInfoArray[i];
            commandArray[i] = sentenceInfo.getSrcLine() == null ? new BasicCommand(sentenceInfo.getLine(), sentenceInfo.isComment(), null) : new BasicCommand(sentenceInfo.getSrcLine(), sentenceInfo.isComment(), sentenceInfo.getSrcLine());
        }
        return new BasicCommand(commandArray);
    }

    public static String getLastCommand(String string) {
        Command command = CommandUtility.getLineSeparatedCommand(R.client(), string);
        if (command.hasCommand()) {
            return command.getCommand();
        }
        if (command.getCommandCount() > 0) {
            return command.getCommands()[command.getCommandCount() - 1].getCommand();
        }
        return "";
    }

    public static String getString(Command command, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        CommandUtility.getString(stringBuilder, command, bl);
        return stringBuilder.toString();
    }

    private static void getString(StringBuilder stringBuilder, Command command, boolean bl) {
        Command[] commandArray = command.getCommands();
        if (commandArray != null) {
            for (Command command2 : commandArray) {
                CommandUtility.getString(stringBuilder, command2, bl);
            }
        }
        if (command.hasCommand()) {
            stringBuilder.append(RUtility.appendNewLine(bl ? command.getDisplayCommand() : command.getCommand()));
        }
    }

    public static CommandListener objectUpdateListener(final RClient rClient) {
        return new CommandAdapter(){

            @Override
            public void commandFinished(Command command) {
                rClient.fireItemStructureChanged();
            }
        };
    }

    public static void copyCommandListeners(Command command, Command command2) {
        Object object;
        Command[] commandArray = command.getCommands();
        if (commandArray != null) {
            object = commandArray;
            int n = ((Command[])object).length;
            for (int i = 0; i < n; ++i) {
                Object object2 = object[i];
                CommandUtility.copyCommandListeners((Command)object2, command2);
            }
        }
        if ((object = command.getCommandListeners()) != null) {
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                CommandListener commandListener = (CommandListener)iterator.next();
                command2.addCommandListener(commandListener);
            }
        }
    }
}

