/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.app.r.console;

import com.ef_prime.rflow.core.app.r.console.Command;
import com.ef_prime.rflow.core.app.r.console.CommandListener;
import java.util.ArrayList;
import java.util.List;

public class CompoundCommandListener
implements CommandListener {
    private List<CommandListener> listeners = new ArrayList<CommandListener>();

    public void addCommandListener(CommandListener commandListener) {
        this.listeners.add(commandListener);
    }

    public void removeCommandListener(CommandListener commandListener) {
        this.listeners.remove(commandListener);
    }

    @Override
    public void commandStart(Command command) {
        for (CommandListener commandListener : this.listeners) {
            commandListener.commandStart(command);
        }
    }

    @Override
    public void commandFinished(Command command) {
        for (CommandListener commandListener : this.listeners) {
            commandListener.commandFinished(command);
        }
    }

    @Override
    public void commandCanceled(Command command) {
        for (CommandListener commandListener : this.listeners) {
            commandListener.commandCanceled(command);
        }
    }

    @Override
    public void errorOccurred(Command command) {
        for (CommandListener commandListener : this.listeners) {
            commandListener.errorOccurred(command);
        }
    }

    @Override
    public void commandDiscarded(Command command) {
        for (CommandListener commandListener : this.listeners) {
            commandListener.commandDiscarded(command);
        }
    }
}

