/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.app.r.console;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.core.app.r.base.R;
import com.ef_prime.rflow.core.app.r.base.RUtility;
import com.ef_prime.rflow.core.app.r.console.BasicCommand;
import com.ef_prime.rflow.core.app.r.console.Command;
import com.ef_prime.rflow.core.app.r.console.CommandAdapter;
import com.ef_prime.rflow.core.app.r.console.CommandBuildFailedException;
import com.ef_prime.rflow.core.app.r.console.CommandPlan;
import com.ef_prime.rflow.core.app.r.console.CompoundCommand;
import com.ef_prime.rflow.core.app.r.console.TaskCommandPack;
import com.ef_prime.rflow.core.base.Settings;
import com.ef_prime.rflow.core.flow.FlowModel;
import com.ef_prime.rflow.core.flow.FlowNode;
import com.ef_prime.rflow.core.flow.FlowRunOption;
import com.ef_prime.rflow.core.flow.FlowUtil;
import com.ef_prime.rflow.core.flow.task.NodeTask;
import com.ef_prime.rflow.core.flow.task.NodeTaskEntry;
import com.ef_prime.rflow.core.flow.task.NodeTaskGroup;
import com.ef_prime.rflow.core.task.NodeModelTask;
import com.ef_prime.rflow.core.task.RCommandTask;
import com.ef_prime.rflow.core.task.Task;
import com.ef_prime.rflow.core.task.TaskEvent;
import com.ef_prime.rflow.core.task.TaskEventHandler;
import com.ef_prime.rflow.core.task.TaskGroup;
import com.ef_prime.rflow.node.NodeModel;
import com.ef_prime.rflow.node.base.SubflowNodeModel;
import com.ef_prime.rflow.node.base.TunnelNodeModel;
import com.ef_prime.rflow.resource.Messages;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class Executor {
    private static Executor scriptExecutor;
    private FlowModel flowModel;
    private Runnable debugOff = new Runnable(){

        @Override
        public void run() {
            R.client().setDebugConstant_Wait(false);
        }
    };

    private Executor() {
        this(null);
    }

    public Executor(FlowModel flowModel) {
        this.flowModel = flowModel;
    }

    protected FlowModel getFlowModel() {
        return this.flowModel;
    }

    public static Executor getScriptExecutor() {
        if (scriptExecutor == null) {
            scriptExecutor = new Executor();
        }
        return scriptExecutor;
    }

    private boolean isFlagNode(FlowNode flowNode) {
        if (this.flowModel == null) {
            return false;
        }
        return this.flowModel.getState().isFlagNode(flowNode);
    }

    public final Command buildCommand(NodeTask nodeTask, NodeTask nodeTask2, FlowRunOption flowRunOption) throws CommandBuildFailedException {
        CommandBuilder commandBuilder = new CommandBuilder(nodeTask, nodeTask2, flowRunOption);
        commandBuilder.build();
        return commandBuilder.getCommand();
    }

    public List<Task> buildTasks(NodeTask nodeTask, NodeTask nodeTask2, FlowRunOption flowRunOption) throws CommandBuildFailedException {
        RunnableTaskBuilder runnableTaskBuilder = new RunnableTaskBuilder(nodeTask, nodeTask2, flowRunOption);
        runnableTaskBuilder.build();
        return runnableTaskBuilder.getTasks();
    }

    public CommandPlan getCommandPlan(FlowNode flowNode, FlowNode flowNode2, FlowRunOption flowRunOption) {
        if (flowNode == null) {
            return CommandPlan.getEmptyPlan();
        }
        NodeTaskEntry nodeTaskEntry = new NodeTaskEntry(flowNode, flowNode2);
        return this.getCommandPlan(nodeTaskEntry, null, flowRunOption);
    }

    public CommandPlan getCommandPlan(NodeTask nodeTask, NodeTask nodeTask2, FlowRunOption flowRunOption) {
        CommandPlanChecker commandPlanChecker = new CommandPlanChecker(nodeTask, nodeTask2, flowRunOption);
        try {
            commandPlanChecker.build();
        }
        catch (CommandBuildFailedException commandBuildFailedException) {
            return CommandPlan.getEmptyPlan();
        }
        return commandPlanChecker.getCommandPlan();
    }

    public String getScript(FlowNode flowNode, FlowNode flowNode2, FlowRunOption flowRunOption) {
        if (flowNode == null) {
            return "";
        }
        NodeTaskEntry nodeTaskEntry = new NodeTaskEntry(flowNode, flowNode2);
        return this.getScript(nodeTaskEntry, null, flowRunOption);
    }

    public String getScript(NodeTask nodeTask, NodeTask nodeTask2, FlowRunOption flowRunOption) {
        try {
            Command command = this.buildCommand(nodeTask, nodeTask2, flowRunOption);
            ArrayList<Command> arrayList = new ArrayList<Command>();
            this.addCommand(arrayList, command);
            StringBuilder stringBuilder = new StringBuilder();
            for (Command command2 : arrayList) {
                if (!command2.hasCommand()) continue;
                stringBuilder.append(RUtility.appendNewLine(command2.getCommand()));
            }
            return stringBuilder.toString();
        }
        catch (CommandBuildFailedException commandBuildFailedException) {
            return "";
        }
    }

    private void addCommand(List<Command> list, Command command) {
        Command[] commandArray = command.getCommands();
        if (commandArray != null) {
            for (int i = 0; i < commandArray.length; ++i) {
                this.addCommand(list, commandArray[i]);
            }
        }
        list.add(command);
    }

    public int getStartIndex(List<FlowNode> list, FlowRunOption flowRunOption, FlowNode flowNode, FlowNode flowNode2) {
        int n;
        boolean bl = flowRunOption.isExecRest();
        boolean bl2 = flowRunOption.isUseCache();
        int n2 = 0;
        if (bl || bl2) {
            for (n = list.size() - 1; n >= 0; --n) {
                FlowNode flowNode3 = list.get(n);
                if (n < list.size() - 1 && bl && this.isFlagNode(flowNode3)) {
                    n2 = n + 1;
                    break;
                }
                if (!bl2 || !flowNode3.isCacheData() || !flowNode3.getCacheData().isValid()) continue;
                n2 = n + 1;
                break;
            }
        }
        if (flowNode != null) {
            if (flowNode.getModel().isOpenSubflow()) {
                flowNode = ((SubflowNodeModel)flowNode.getModel()).getIn();
            }
            if ((n = list.indexOf(flowNode)) > n2) {
                n2 = n;
            }
        }
        if (flowNode2 != null && (n = list.indexOf(flowNode2) + 1) > 0 && n >= n2) {
            n2 = n;
        }
        return n2;
    }

    protected void addCommandListener(Command command, NodeTaskEntry nodeTaskEntry, FlowRunOption flowRunOption) {
        if (flowRunOption.isDebug()) {
            command.addCommandListener(new CommandAdapter(){

                @Override
                public void commandStart(Command command) {
                    R.client().setDebugConstant_Wait(true);
                }

                @Override
                public void commandFinished(Command command) {
                    R.queryQueue().addQuery(Executor.this.debugOff);
                }

                @Override
                public void commandCanceled(Command command) {
                    R.queryQueue().addQuery(Executor.this.debugOff);
                }
            });
        }
    }

    protected void addCommandListener(Command command, FlowNode flowNode, FlowRunOption flowRunOption) {
    }

    protected void addTaskEventHandler(Task task, NodeTaskEntry nodeTaskEntry) {
        if (task.getOption().isDebug()) {
            task.addTaskEventHandler(new TaskEventHandler(){

                @Override
                public void taskStateChanged(TaskEvent taskEvent) {
                    if (taskEvent.isRunning()) {
                        R.client().setDebugConstant_Wait(true);
                    } else if (taskEvent.isDone()) {
                        R.queryQueue().addQuery(Executor.this.debugOff);
                    }
                }
            });
        }
    }

    protected void addNodeTaskEventHandler(Task task, FlowNode flowNode, FlowRunOption flowRunOption) {
    }

    public NodeTaskGroup createAllStepTask(FlowNode flowNode, FlowNode flowNode2, FlowNode flowNode3, FlowRunOption flowRunOption) {
        Object object;
        List<FlowNode> list = FlowUtil.getStream(flowNode, true, false, true);
        int n = this.getStartIndex(list, flowRunOption, flowNode2, flowNode3);
        if (n > 0) {
            object = list.get(n - 1);
            if ((!flowRunOption.isExecRest() || !this.isFlagNode((FlowNode)object)) && flowRunOption.isUseCache() && ((FlowNode)object).isCacheData() && ((FlowNode)object).getCacheData().isValid()) {
                --n;
            }
        }
        if (n >= list.size()) {
            return null;
        }
        Object object2 = object = new NodeTaskGroup();
        for (int i = n; i < list.size(); ++i) {
            FlowNode flowNode4 = list.get(i);
            if (flowNode4.getModel() == TunnelNodeModel.inModel) {
                if (flowNode4.getParentNode() == list.get(list.size() - 1).getParentNode()) continue;
                NodeTaskGroup nodeTaskGroup = new NodeTaskGroup();
                ((NodeTaskGroup)object2).insert(nodeTaskGroup, ((NodeTaskGroup)object2).getChildCount());
                object2 = nodeTaskGroup;
                continue;
            }
            if (flowNode4.getModel() == TunnelNodeModel.outModel) continue;
            if (object2 != object && flowNode4.getModel().isOpenSubflow()) {
                ((NodeTask)object2).getProperty().setTitle(flowNode4.getTitle());
                ((NodeTaskGroup)object2).setNode(flowNode4);
                object2 = (NodeTaskGroup)((NodeTask)object2).getParent();
                continue;
            }
            ((NodeTaskGroup)object2).insert(new NodeTaskEntry(flowNode4, flowNode2 == null ? null : flowNode4), ((NodeTaskGroup)object2).getChildCount());
        }
        return object;
    }

    @Deprecated
    public void processStep(TaskCommandPack taskCommandPack) {
        throw new RuntimeException();
    }

    private class CommandBuilder
    extends AbstractCommandBuilder {
        private List<CompoundCommand> commands;
        private CompoundCommand command;

        public CommandBuilder(NodeTask nodeTask, NodeTask nodeTask2, FlowRunOption flowRunOption) {
            super(nodeTask, nodeTask2, flowRunOption);
            this.commands = new ArrayList<CompoundCommand>();
            this.command = new CompoundCommand();
        }

        public Command getCommand() {
            if (this.commands.isEmpty()) {
                return new BasicCommand("");
            }
            if (this.commands.size() == 1) {
                return this.commands.get(0);
            }
            CompoundCommand compoundCommand = new CompoundCommand();
            for (int i = 0; i < this.commands.size(); ++i) {
                compoundCommand.add(this.commands.get(i));
            }
            return compoundCommand;
        }

        @Override
        void startTaskBuild(NodeTaskEntry nodeTaskEntry) throws CommandBuildFailedException {
            this.command = new CompoundCommand();
        }

        @Override
        void endTaskBuild(NodeTaskEntry nodeTaskEntry) throws CommandBuildFailedException {
            Executor.this.addCommandListener((Command)this.command, nodeTaskEntry, this.runOption);
            this.commands.add(this.command);
        }

        @Override
        void clearObjects() throws CommandBuildFailedException {
            BasicCommand basicCommand = new BasicCommand(R.client().getClearObjectsCommand());
            Executor.this.addCommandListener((Command)basicCommand, (FlowNode)null, this.runOption);
            this.command.add(basicCommand);
        }

        @Override
        void loadCache(FlowNode flowNode) throws CommandBuildFailedException {
            if (Executor.this.flowModel == null) {
                return;
            }
            try {
                Command command = Executor.this.flowModel.getCacheHandler().loadCache(flowNode);
                Executor.this.addCommandListener(command, (FlowNode)null, this.runOption);
                this.command.add(command);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new CommandBuildFailedException(Messages.getString("Message.node_name") + " : " + flowNode.getTitle() + "\n" + fileNotFoundException.getMessage() + "\n\n" + Messages.getString("Error.run_again"), fileNotFoundException);
            }
        }

        @Override
        void browse(FlowNode flowNode) throws CommandBuildFailedException {
            BasicCommand basicCommand = new BasicCommand(R.client().getDebugCommand());
            Executor.this.addCommandListener((Command)basicCommand, flowNode, this.runOption);
            this.command.add(basicCommand);
        }

        private String getTitle(FlowNode flowNode, int n) {
            String string = flowNode.getProperty().getTitle();
            if (StringUtils.isEmpty((CharSequence)string)) {
                if (!flowNode.getModel().exportDefaultTitle()) {
                    return null;
                }
                string = flowNode.getTitle();
            }
            StringBuilder stringBuilder = new StringBuilder(string.length() + n + 4);
            int n2 = 2 + n;
            for (int i = 0; i < n2; ++i) {
                stringBuilder.append('#');
            }
            stringBuilder.append(' ');
            stringBuilder.append(string);
            stringBuilder.append("\n");
            return stringBuilder.toString();
        }

        private void addComments(FlowNode flowNode, int n) {
            String string;
            if (this.runOption.isIncludeTitle() && (string = this.getTitle(flowNode, n)) != null) {
                this.command.add(new BasicCommand(string));
            }
            if (this.runOption.isIncludeComment() && !StringUtils.isEmpty((CharSequence)(string = flowNode.getComment().getText()))) {
                int n2 = this.runOption.isIncludeTitle() ? 2 + n : 1;
                this.command.add(new BasicCommand(RUtility.toComment(string, n2)));
            }
        }

        @Override
        void box(FlowNode flowNode, int n) throws CommandBuildFailedException {
            this.addComments(flowNode, n);
        }

        @Override
        void command(FlowNode flowNode, int n) throws CommandBuildFailedException {
            this.addComments(flowNode, n);
            Command command = flowNode.getModel().getCommandObject(this.runOption, false);
            Executor.this.addCommandListener(command, flowNode, this.runOption);
            if (this.runOption.isCheckError()) {
                command.setCheckError(true);
            }
            this.command.add(command);
            if (this.runOption.isInsertNewLine() && this.currentStream.get(this.currentStream.size() - 1) != flowNode) {
                this.command.add(new BasicCommand("\n"));
            }
        }

        @Override
        void noCommand(FlowNode flowNode, int n) throws CommandBuildFailedException {
            this.addComments(flowNode, n);
        }

        @Override
        void saveCache(FlowNode flowNode) throws CommandBuildFailedException {
            if (Executor.this.flowModel != null) {
                try {
                    Command command = Executor.this.flowModel.getCacheHandler().cacheNode(flowNode);
                    Executor.this.addCommandListener(command, (FlowNode)null, this.runOption);
                    this.command.add(command);
                }
                catch (IOException iOException) {
                    throw new CommandBuildFailedException(Messages.getString("Error.file.create_folder") + " : " + String.valueOf(Executor.this.flowModel.getCacheHandler().getCacheDir(true)), iOException);
                }
            }
        }

        @Override
        void doNotSaveCache(FlowNode flowNode) throws CommandBuildFailedException {
        }
    }

    private class RunnableTaskBuilder
    extends AbstractCommandBuilder {
        private List<Task> tasks;
        private TaskGroup group;

        public RunnableTaskBuilder(NodeTask nodeTask, NodeTask nodeTask2, FlowRunOption flowRunOption) {
            super(nodeTask, nodeTask2, flowRunOption);
            this.tasks = new ArrayList<Task>();
        }

        public List<Task> getTasks() {
            return this.tasks;
        }

        private void addRCommandTask(Command command, FlowNode flowNode) {
            RCommandTask rCommandTask = new RCommandTask(this.runOption, command);
            Executor.this.addNodeTaskEventHandler(rCommandTask, flowNode, this.runOption);
            this.group.add(rCommandTask);
        }

        @Override
        void startTaskBuild(NodeTaskEntry nodeTaskEntry) throws CommandBuildFailedException {
            this.group = TaskGroup.createRunTaskGroup(this.runOption);
        }

        @Override
        void endTaskBuild(NodeTaskEntry nodeTaskEntry) throws CommandBuildFailedException {
            Task task = this.group;
            if (this.group.getChildCount() == 1) {
                task = (Task)this.group.getChildAt(0);
            }
            Executor.this.addTaskEventHandler(task, nodeTaskEntry);
            this.tasks.add(task);
        }

        @Override
        void clearObjects() throws CommandBuildFailedException {
            BasicCommand basicCommand = new BasicCommand(R.client().getClearObjectsCommand());
            this.addRCommandTask(basicCommand, null);
        }

        @Override
        void loadCache(FlowNode flowNode) throws CommandBuildFailedException {
            if (Executor.this.flowModel != null) {
                try {
                    Command command = Executor.this.flowModel.getCacheHandler().loadCache(flowNode);
                    this.addRCommandTask(command, null);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    throw new CommandBuildFailedException(Messages.getString("Message.node_name") + " : " + flowNode.getTitle() + "\n" + fileNotFoundException.getMessage() + "\n\n" + Messages.getString("Error.run_again"), fileNotFoundException);
                }
            }
        }

        @Override
        void browse(FlowNode flowNode) throws CommandBuildFailedException {
            BasicCommand basicCommand = new BasicCommand(R.client().getDebugCommand());
            this.addRCommandTask(basicCommand, flowNode);
        }

        @Override
        void command(FlowNode flowNode, int n) throws CommandBuildFailedException {
            NodeModelTask nodeModelTask = new NodeModelTask(this.runOption, flowNode.getModel());
            Executor.this.addNodeTaskEventHandler(nodeModelTask, flowNode, this.runOption);
            this.group.add(nodeModelTask);
        }

        @Override
        void saveCache(FlowNode flowNode) throws CommandBuildFailedException {
            if (Executor.this.flowModel != null) {
                try {
                    Command command = Executor.this.flowModel.getCacheHandler().cacheNode(flowNode);
                    this.addRCommandTask(command, null);
                }
                catch (IOException iOException) {
                    throw new CommandBuildFailedException(Messages.getString("Error.file.create_folder") + " : " + String.valueOf(Executor.this.flowModel.getCacheHandler().getCacheDir(true)), iOException);
                }
            }
        }

        @Override
        void doNotSaveCache(FlowNode flowNode) throws CommandBuildFailedException {
        }
    }

    private class CommandPlanChecker
    extends AbstractCommandBuilder {
        private boolean loadCache;
        private boolean browse;
        private boolean doNotSaveCache;

        public CommandPlanChecker(NodeTask nodeTask, NodeTask nodeTask2, FlowRunOption flowRunOption) {
            super(nodeTask, nodeTask2, flowRunOption);
        }

        CommandPlan getCommandPlan() {
            return new CommandPlan(this.loadCache, this.browse, this.doNotSaveCache);
        }

        @Override
        void startTaskBuild(NodeTaskEntry nodeTaskEntry) throws CommandBuildFailedException {
        }

        @Override
        void endTaskBuild(NodeTaskEntry nodeTaskEntry) throws CommandBuildFailedException {
        }

        @Override
        void clearObjects() throws CommandBuildFailedException {
        }

        @Override
        void loadCache(FlowNode flowNode) throws CommandBuildFailedException {
            this.loadCache = true;
        }

        @Override
        void browse(FlowNode flowNode) throws CommandBuildFailedException {
            if (this.runOption.isDebug()) {
                this.browse = true;
            }
        }

        @Override
        void command(FlowNode flowNode, int n) throws CommandBuildFailedException {
            if (this.runOption.isDebug() && !this.browse && flowNode.getModel().isAnyEnabledBreakpoint()) {
                this.browse = true;
            }
        }

        @Override
        void saveCache(FlowNode flowNode) throws CommandBuildFailedException {
        }

        @Override
        void doNotSaveCache(FlowNode flowNode) throws CommandBuildFailedException {
            this.doNotSaveCache = true;
        }
    }

    private abstract class AbstractCommandBuilder {
        protected NodeTask task;
        protected NodeTask previous;
        protected FlowRunOption runOption;
        protected List<FlowNode> currentStream;

        public AbstractCommandBuilder(NodeTask nodeTask, NodeTask nodeTask2, FlowRunOption flowRunOption) {
            this.task = nodeTask;
            this.previous = nodeTask2;
            this.runOption = flowRunOption;
            boolean bl = Rflow.settings().getValue(Settings.CHECK_ERROR);
            this.runOption.setCheckError(bl);
        }

        void build() throws CommandBuildFailedException {
            NodeTaskEntry[] nodeTaskEntryArray = this.task.getChildEntrys();
            FlowNode flowNode = null;
            if (this.previous != null) {
                flowNode = this.previous.getLastNode();
            }
            for (int i = 0; i < nodeTaskEntryArray.length; ++i) {
                if (i > 0) {
                    flowNode = nodeTaskEntryArray[i - 1].getStartNode() == null ? nodeTaskEntryArray[i - 1].getNode() : null;
                }
                NodeTaskEntry nodeTaskEntry = nodeTaskEntryArray[i];
                this.startTaskBuild(nodeTaskEntry);
                this.taskBuild(nodeTaskEntry.getNode(), nodeTaskEntry.getStartNode(), flowNode);
                this.endTaskBuild(nodeTaskEntry);
                if (this.runOption.isClearOnce()) {
                    this.runOption = this.runOption.copy().setClearObjects(false);
                }
                this.runOption = this.runOption.copy().setExecRest(false);
            }
        }

        void taskBuild(FlowNode flowNode, FlowNode flowNode2, FlowNode flowNode3) throws CommandBuildFailedException {
            FlowNode flowNode4;
            if (flowNode.getGraph() == null) {
                throw new CommandBuildFailedException(Messages.getString("Error.run_node_not_found"));
            }
            if (flowNode2 != null && flowNode2.getGraph() == null) {
                throw new CommandBuildFailedException(Messages.getString("Error.run_node_not_found"));
            }
            if (flowNode3 != null && flowNode3.getGraph() == null) {
                flowNode3 = null;
            }
            if (flowNode.getModel() == TunnelNodeModel.outModel) {
                flowNode = flowNode.getParentNode();
            }
            if (flowNode3 != null && flowNode3.getModel() == TunnelNodeModel.outModel) {
                flowNode3 = flowNode3.getParentNode();
            }
            boolean bl = this.runOption.isExecRest();
            boolean bl2 = this.runOption.isClearObjects();
            boolean bl3 = this.runOption.isUseCache();
            List<FlowNode> list = FlowUtil.getStream(flowNode, true, false, true);
            this.currentStream = list;
            int n = Executor.this.getStartIndex(list, this.runOption, flowNode2, flowNode3);
            boolean bl4 = false;
            boolean bl5 = false;
            if (n > 0) {
                flowNode4 = list.get(n - 1);
                if (flowNode4 == flowNode3) {
                    bl4 = true;
                } else if ((!bl || !Executor.this.isFlagNode(flowNode4)) && bl3 && !flowNode4.getModel().isDisabled() && flowNode4.isCacheData() && flowNode4.getCacheData().isValid()) {
                    bl5 = true;
                }
            }
            if (!bl && bl2 && !bl4) {
                this.clearObjects();
            }
            if (bl3 && bl5) {
                flowNode4 = list.get(n - 1);
                this.loadCache(flowNode4);
            }
            boolean bl6 = false;
            int n2 = 0;
            for (int i = n; i < list.size(); ++i) {
                FlowNode flowNode5 = list.get(i);
                NodeModel nodeModel = flowNode5.getModel();
                FlowNode flowNode6 = flowNode5.getParentNode();
                if (nodeModel.isDisabled()) continue;
                if (!this.runOption.isExcludeDebugScript()) {
                    boolean bl7 = false;
                    if (nodeModel == TunnelNodeModel.inModel && flowNode6 != null && flowNode6.getModel().isOpenSubflow()) {
                        bl7 = flowNode6.isFirstBreakpointEnabled();
                    }
                    if (bl7) {
                        this.browse(flowNode5);
                        if (this.runOption.isDebug()) {
                            bl6 = true;
                        }
                    }
                }
                if (nodeModel == TunnelNodeModel.inModel) {
                    if (flowNode6 != null && flowNode6.getModel().isOpenSubflow()) {
                        this.box(flowNode6, n2);
                    }
                    if (i != n) {
                        ++n2;
                    }
                }
                if (!nodeModel.isOpenSubflow()) {
                    if (nodeModel.hasCommand()) {
                        this.command(flowNode5, n2);
                        if (this.runOption.isDebug() && nodeModel.isAnyEnabledBreakpoint()) {
                            bl6 = true;
                        }
                    } else {
                        this.noCommand(flowNode5, n2);
                    }
                }
                if (bl3 && (bl2 || this.runOption.isObjectCleared()) && flowNode5.isCacheData() && !flowNode5.getCacheData().isValid()) {
                    if (!bl6) {
                        this.saveCache(flowNode5);
                    } else {
                        this.doNotSaveCache(flowNode5);
                    }
                }
                if (nodeModel != TunnelNodeModel.outModel) continue;
                --n2;
            }
        }

        abstract void startTaskBuild(NodeTaskEntry var1) throws CommandBuildFailedException;

        abstract void clearObjects() throws CommandBuildFailedException;

        abstract void loadCache(FlowNode var1) throws CommandBuildFailedException;

        abstract void browse(FlowNode var1) throws CommandBuildFailedException;

        void box(FlowNode flowNode, int n) throws CommandBuildFailedException {
        }

        abstract void command(FlowNode var1, int var2) throws CommandBuildFailedException;

        void noCommand(FlowNode flowNode, int n) throws CommandBuildFailedException {
        }

        abstract void saveCache(FlowNode var1) throws CommandBuildFailedException;

        abstract void doNotSaveCache(FlowNode var1) throws CommandBuildFailedException;

        abstract void endTaskBuild(NodeTaskEntry var1) throws CommandBuildFailedException;
    }
}

