/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.app.r.console;

import com.ef_prime.rflow.core.app.r.base.R;
import com.ef_prime.rflow.core.app.r.base.RSessionManager;
import com.ef_prime.rflow.core.app.r.base.RSupport;
import com.ef_prime.rflow.core.app.r.base.RUtility;
import com.ef_prime.rflow.core.app.r.console.BasicCommand;
import com.ef_prime.rflow.core.app.r.console.BrowseListener;
import com.ef_prime.rflow.core.app.r.console.BusyListener;
import com.ef_prime.rflow.core.app.r.console.Command;
import com.ef_prime.rflow.core.app.r.console.CommandAdapter;
import com.ef_prime.rflow.core.app.r.console.CommandBuildFailedException;
import com.ef_prime.rflow.core.app.r.console.CommandListener;
import com.ef_prime.rflow.core.app.r.console.CommandReceiver;
import com.ef_prime.rflow.core.app.r.console.ConsoleEntry;
import com.ef_prime.rflow.core.app.r.console.ConsoleListener;
import com.ef_prime.rflow.core.app.r.console.ElementType;
import com.ef_prime.rflow.core.app.r.console.RInteractiveAction;
import com.ef_prime.rflow.core.app.r.console.RInteractiveActionEvent;
import com.ef_prime.rflow.core.app.r.console.RQueryQueue;
import com.ef_prime.rflow.core.app.r.script.RTokenMaker;
import com.ef_prime.rflow.core.common.util.ThreadUtility;
import com.ef_prime.rflow.core.task.TaskQueue;
import com.ef_prime.rflow.ui.app.r.RJavaUI;
import com.ef_prime.rflow.ui.common.event.EventSupport;
import com.ef_prime.rflow.ui.common.event.SimpleEventHandler;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.text.Segment;
import org.fife.ui.rsyntaxtextarea.Token;
import org.rosuda.JRI.RMainLoopCallbacks;
import org.rosuda.JRI.Rengine;

public abstract class RConsole
implements RMainLoopCallbacks,
RSessionManager.RSessionEventHandler {
    private static final Logger LOGGER = Logger.getLogger(RConsole.class.getName());
    private static final String BROWSE = "BROWSE";
    private static final String BUSY = "BUSY";
    private CommandReceiver baseReceiver;
    private LinkedList<CommandReceiver> receiverStack = new LinkedList();
    private RQueryQueue rQueryQueue = new RQueryQueue();
    protected final List<String> commandHistory = new ArrayList<String>();
    protected int histPos = this.commandHistory.size();
    protected String historyScratch;
    private boolean busy;
    protected boolean useBuffer = true;
    private StringBuilder buffer = new StringBuilder(1024);
    private int currentOutputType = 0;
    private RInteractiveAction interactiveAction;
    private LinkedList<Command> lastCommandStack = new LinkedList();
    private boolean stopped = false;
    private boolean waitingForCommand = false;
    private boolean shuttingDown;
    private String[] calls = null;
    private RTokenMaker tokenMaker = new RTokenMaker();
    private boolean checkBrowser = false;
    private boolean isContinue = false;
    protected boolean browse = false;
    protected boolean recover = false;
    protected Command nextCommand = null;
    private Deque<String[]> multiLineCommandQueue = new ArrayDeque<String[]>();
    private int frame;
    private int lastToken = 0;
    private Queue<BusyListener> busyListeners = new ConcurrentLinkedQueue<BusyListener>();
    private Queue<ConsoleListener> consoleListeners = new ConcurrentLinkedQueue<ConsoleListener>();
    private Queue<BrowseListener> browseListeners = new ConcurrentLinkedQueue<BrowseListener>();
    private EventSupport<RInteractiveActionEvent, SimpleEventHandler> rInteractiveActionEventSupport = new EventSupport();
    private boolean interceptOutput;
    private OutputIntercepter intercepter;

    public RConsole() {
        this.lastCommandStack.add(new BasicCommand(""));
        this.baseReceiver = new CommandReceiver("");
        this.receiverStack.addFirst(this.baseReceiver);
        R.sessionManager().addEventHandler(this);
    }

    public void init(boolean bl) {
        if (bl) {
            this.commandHistory.clear();
            this.histPos = 0;
            this.historyScratch = null;
        }
    }

    public void initR(boolean bl) {
    }

    protected void clearPrompt() {
    }

    public boolean canBrowse() {
        return !this.browse && !this.stopped && R.client().isBrowseEnabled();
    }

    protected abstract void handleCommandBuildFailedException(CommandBuildFailedException var1);

    public CommandReceiver getReceiver() {
        return this.receiverStack.getLast();
    }

    public CommandReceiver getParentReceiver() {
        if (this.receiverStack.size() == 1) {
            return this.baseReceiver;
        }
        return this.receiverStack.get(this.receiverStack.size() - 2);
    }

    public void pushNewReceiver(String string) {
        this.receiverStack.add(this.baseReceiver.createReceiver(string));
    }

    public void removeReceiver() {
        if (this.receiverStack.size() > 1) {
            this.receiverStack.removeLast().dispose();
        }
    }

    public int getReceiverStackSize() {
        return this.receiverStack.size();
    }

    public RQueryQueue getRQueryQueue() {
        return this.rQueryQueue;
    }

    public boolean isWaitingForCommand() {
        return this.waitingForCommand;
    }

    protected abstract void processAppend(String var1, ElementType var2);

    protected Command getLastCommand() {
        return this.lastCommandStack.getLast();
    }

    protected void pushLastCommand() {
        this.lastCommandStack.addLast(new BasicCommand(""));
    }

    protected void removeLastCommand() {
        if (this.lastCommandStack.size() > 1) {
            this.lastCommandStack.removeLast();
        }
    }

    protected void setLastCommand(Command command) {
        this.lastCommandStack.removeLast();
        this.lastCommandStack.addLast(command);
    }

    protected Command getParentLastCommand() {
        if (this.lastCommandStack.size() == 1) {
            return this.lastCommandStack.getFirst();
        }
        return this.lastCommandStack.get(this.lastCommandStack.size() - 2);
    }

    public void info(String object) {
        if (!((String)object).endsWith("\n")) {
            object = (String)object + "\n";
        }
        this.append("[Info] " + (String)object, ElementType.INFO);
    }

    public void append(String string, ElementType elementType) {
        for (ConsoleListener consoleListener : this.consoleListeners) {
            consoleListener.append(string, elementType);
        }
        if (this.getLastCommand() != null) {
            this.getLastCommand().addConsoleEntry(new ConsoleEntry(string, elementType));
        }
        if (this.interceptOutput && this.intercepter != null) {
            if (elementType == ElementType.OUTPUT) {
                this.intercepter.append(string);
            }
            return;
        }
        this.processAppend(string, elementType);
    }

    protected void addToHistory(String string) {
        String string2 = string.trim();
        if (string2.length() > 0) {
            while (this.commandHistory.size() >= 512) {
                this.commandHistory.remove(0);
            }
            this.commandHistory.add(string2);
            this.histPos = this.commandHistory.size();
            this.historyScratch = null;
        }
    }

    public void flushBuffer() {
        if (this.buffer.length() > 0) {
            if (this.currentOutputType > 0) {
                this.append(this.buffer.toString(), ElementType.ERROR);
            } else {
                this.append(this.buffer.toString(), ElementType.OUTPUT);
            }
            this.buffer.delete(0, this.buffer.length());
        }
    }

    public void cancelCommands() {
        CommandReceiver commandReceiver = this.getReceiver();
        commandReceiver.discardAllCommand();
        Command command = this.getLastCommand();
        if (command != null) {
            command.cancel();
            Command command2 = command;
            while (!command2.isRoot()) {
                command2 = command2.getParent();
                command2.cancel();
            }
        }
        this.multiLineCommandQueue.clear();
    }

    public void stop(boolean bl) {
        if (this.stopped) {
            return;
        }
        if (!(RSupport.supportsInputCancel() || this.isBusy() && !this.isWaitingForCommand())) {
            return;
        }
        FutureTask<Object> futureTask = new FutureTask<Object>(new Runnable(){

            @Override
            public void run() {
                RConsole.this.stopped = true;
                RConsole.this.clearCommands(false);
                try {
                    R.client().stop();
                }
                catch (Exception exception) {
                    LOGGER.log(Level.SEVERE, "Exception while invoking R interrupt.", exception);
                }
                RConsole.this.passEmptyCommand();
                if (RConsole.this.interactiveAction != null) {
                    RConsole.this.interactiveAction.cancel();
                }
            }
        }, null);
        ThreadUtility.execute(futureTask);
        if (bl) {
            try {
                futureTask.get();
            }
            catch (InterruptedException | ExecutionException exception) {
                LOGGER.log(Level.SEVERE, "Exception while trying to stop R.", exception);
            }
        }
    }

    public void stopIfBusy() {
        if (this.isBusy() && !this.isWaitingForCommand()) {
            this.stop(false);
        }
    }

    public void cancel(boolean bl) {
        this.clearCommands(bl);
        this.passEmptyCommand();
    }

    private void clearCommands(boolean bl) {
        TaskQueue.getInstance().cancel();
        if (bl) {
            while (this.getReceiverStackSize() > 1) {
                this.cancelCommands();
                this.clearCurrentContext();
            }
        }
        this.cancelCommands();
    }

    private void passEmptyCommand() {
        if (this.waitingForCommand) {
            this.getReceiver().passCommand(new BasicCommand("#Canceled", true, ""));
        }
    }

    public boolean isBusy() {
        return this.busy;
    }

    public void rBusy(Rengine rengine, final int n) {
        this.busy = n == 1;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                RConsole.this.fireBusyStateChanged(n);
            }
        });
    }

    public boolean isBusyWaitingForInput() {
        return this.getReceiver().getName().equals(BUSY);
    }

    public boolean isDebugWaitingForInput() {
        if (this.browse) {
            return true;
        }
        String string = this.getReceiver().getName();
        return string.equals(BROWSE);
    }

    public boolean isRecover() {
        return this.recover;
    }

    public void rWriteConsole(Rengine rengine, String string, int n) {
        if (this.useBuffer) {
            if (this.currentOutputType != n) {
                this.flushBuffer();
            }
            this.currentOutputType = n;
            if (this.buffer.length() + string.length() > this.buffer.capacity()) {
                this.flushBuffer();
            }
            this.buffer.append(string);
            if (this.interactiveAction != null) {
                this.flushBuffer();
            }
        } else if (n > 0) {
            this.append(string, ElementType.ERROR);
        } else {
            this.append(string, ElementType.OUTPUT);
        }
    }

    protected abstract boolean errorOccured();

    public String rReadConsole(Rengine rengine, String string, int n) {
        this.isContinue = false;
        if (R.client().isEmbedded() && Thread.currentThread() != rengine) {
            LOGGER.log(Level.SEVERE, "rReadConsole invoked by unexpected thread :" + String.valueOf(Thread.currentThread()), new RuntimeException());
            return "invisible()\n";
        }
        try {
            if (this.useBuffer) {
                this.flushBuffer();
            }
            this.setInteractiveAction(null);
            if (!this.multiLineCommandQueue.isEmpty()) {
                this.isContinue = true;
                String[] stringArray = this.multiLineCommandQueue.getFirst();
                if (stringArray[0] != null) {
                    this.append(string, ElementType.PROMPT);
                }
                return this.popMultiLineQueue();
            }
            boolean bl = this.isBusyWaitingForInput();
            if (this.busy || n == 0) {
                if (!bl) {
                    this.createNewContext(BUSY);
                }
                return this.readConsole(string, false);
            }
            if (bl) {
                this.clearCurrentContext();
            }
            R.client().setRecover(false);
            this.isContinue = string.equals(R.client().getContinuePrompt());
            if (this.checkBrowser && !this.isContinue) {
                this.checkBrowser = false;
                return R.client().checkBrowserCommand() + "\n";
            }
            this.checkBrowser = true;
            boolean bl2 = this.browse;
            if (!this.isContinue) {
                switch (R.client().isBrowser_Wait()) {
                    case 0: {
                        this.browse = false;
                        this.recover = false;
                        break;
                    }
                    case 1: {
                        this.browse = true;
                        this.recover = false;
                        break;
                    }
                    case 2: {
                        this.browse = true;
                        this.recover = true;
                    }
                }
            }
            if (this.browse) {
                R.client().clearBrowserObject();
            }
            if (this.browse != bl2) {
                if (this.browse) {
                    boolean bl3 = this.getLastCommand().checkError() && R.client().isErrorOccurred();
                    boolean bl4 = true;
                    if (bl3) {
                        this.getLastCommand().error();
                        bl4 = this.getLastCommand().ignoreError() ? false : this.errorOccured();
                        R.client().clearErrorObject();
                        RJavaUI.setSelectedFrame(0);
                    }
                    this.frame = 0;
                    this.createNewContext(BROWSE);
                    if (!bl4) {
                        return RUtility.appendNewLine("c");
                    }
                    this.fireBrowseStateChanged(1, bl3);
                } else {
                    this.fireBrowseStateChanged(0, false);
                    this.clearCurrentContext();
                    R.client().clearDebugEnv();
                }
            }
            String string2 = this.readConsole(string, this.browse);
            return string2;
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "jriReadConsole exception: " + exception.getMessage(), exception);
            return "\n";
        }
    }

    private void createNewContext(String string) {
        this.pushNewReceiver(string);
        this.pushLastCommand();
    }

    private void clearCurrentContext() {
        if (this.getReceiverStackSize() > 1) {
            Command command = this.getLastCommand();
            this.removeLastCommand();
            this.removeReceiver();
            if (command != null) {
                command.finish();
            }
        }
    }

    public boolean isBrowse() {
        return this.browse;
    }

    protected void willStartWaitingForCommand() {
    }

    private String readConsole(String string, boolean bl) {
        RunnableFuture<?> runnableFuture;
        Command command = this.getLastCommand();
        CommandReceiver commandReceiver = this.getReceiver();
        if (command != null) {
            if (!this.stopped && command.checkError() && R.client().isErrorOccurred()) {
                command.error();
                if (!command.ignoreError()) {
                    this.errorOccured();
                }
            }
            command.finish();
        }
        commandReceiver.checkFinished();
        this.setLastCommand(null);
        this.calls = bl ? R.client().getCurrentCalls() : null;
        this.append(string, ElementType.PROMPT);
        this.willStartWaitingForCommand();
        this.stopped = false;
        this.waitingForCommand = true;
        BasicCommand basicCommand = null;
        do {
            if (this.shuttingDown) {
                return null;
            }
            try {
                basicCommand = commandReceiver.waitForCommand();
            }
            catch (CommandBuildFailedException commandBuildFailedException) {
                this.handleCommandBuildFailedException(commandBuildFailedException);
            }
            if (basicCommand != null) continue;
            runnableFuture = this.getRQueryQueue().pollQuery();
            if (runnableFuture != null) {
                runnableFuture.run();
            } else {
                commandReceiver.waitFor();
            }
            R.client().idle();
        } while (basicCommand == null);
        this.waitingForCommand = false;
        if (bl) {
            this.processBrowseCommand(basicCommand);
        }
        if (basicCommand.isCaptureOutput()) {
            basicCommand.addCommandListener(new OutputIntercepter());
        }
        this.setLastCommand(basicCommand);
        runnableFuture = basicCommand.getDisplayCommand();
        String string2 = basicCommand.getCommand();
        if (!this.stopped) {
            R.client().clearErrorObject();
            R.client().setRecover(basicCommand.checkError() && !basicCommand.noRecover());
        }
        RConsole.startCommand(basicCommand);
        runnableFuture = RUtility.appendNewLine((String)((Object)runnableFuture));
        string2 = RUtility.appendNewLine(string2);
        String[] stringArray = ((String)((Object)runnableFuture)).split("\n", -1);
        String[] stringArray2 = string2.split("\n", -1);
        int n = Math.max(stringArray.length, stringArray2.length);
        for (int i = 0; i < n - 1; ++i) {
            String string3 = i < stringArray.length - 1 ? stringArray[i] : null;
            String string4 = i < stringArray2.length - 1 ? stringArray2[i] : null;
            this.multiLineCommandQueue.add(new String[]{string3, string4});
        }
        if (basicCommand.addToHistory()) {
            this.addToHistory((String)((Object)runnableFuture));
        }
        return this.popMultiLineQueue();
    }

    private String popMultiLineQueue() {
        String[] stringArray = this.multiLineCommandQueue.removeFirst();
        String string = stringArray[0];
        String string2 = stringArray[1];
        if (string != null) {
            if (!string.isEmpty()) {
                for (Token token = this.tokenMaker.getTokenList(new Segment(string.toCharArray(), 0, string.length()), this.isContinue() ? this.lastToken : 0, 0); token != null; token = token.getNextToken()) {
                    this.lastToken = token.getType();
                    if (token.getType() == 0) break;
                    ElementType elementType = ElementType.tokenToType(token.getType());
                    String string3 = new String(token.getTextArray(), token.getOffset(), token.length());
                    if (elementType != ElementType.NULL) {
                        this.append(string3, elementType);
                        continue;
                    }
                    this.append(string3, ElementType.INPUT);
                }
            }
            this.append("\n", ElementType.WHITESPACE);
        }
        if (string2 == null) {
            string2 = "";
        }
        return RUtility.appendNewLine(string2);
    }

    public int getLastToken() {
        return this.lastToken;
    }

    public boolean isContinue() {
        return this.isContinue;
    }

    public void notifyReceiver() {
        this.getReceiver().notifyReceiver();
    }

    public void setPseudoFrame(int n, String string) {
        if (this.frame != n) {
            this.frame = n;
            if (this.browse) {
                this.getReceiver().passCommand(new BasicCommand("# frame changed to " + string, true, null));
            }
        }
    }

    public int getPseudoFrame() {
        return this.frame;
    }

    public void setInteractiveAction(RInteractiveAction rInteractiveAction) {
        if (!Objects.equals(this.interactiveAction, rInteractiveAction)) {
            if (rInteractiveAction == null) {
                this.interactiveAction.cancel();
            }
            this.interactiveAction = rInteractiveAction;
            this.rInteractiveActionEventSupport.dispatchEvent(new RInteractiveActionEvent(rInteractiveAction));
        }
    }

    protected static void startCommand(Command command) {
        command.start();
        while (!command.isRoot()) {
            command = command.getParent();
            command.start();
        }
    }

    protected static void copyCommandState(Command command, Command command2) {
        command2.setParent(command.getParent());
        for (CommandListener commandListener : command.getCommandListeners()) {
            command2.addCommandListener(commandListener);
        }
    }

    protected void processBrowseCommand(BasicCommand basicCommand) {
        String string = basicCommand.getCommand().trim();
        if (string.isEmpty()) {
            basicCommand.setCommand("c");
            basicCommand.setAddToHistory(2);
        } else if (string.equals("Q")) {
            basicCommand.setAddToHistory(2);
            basicCommand.addCommandListener(new CommandAdapter(){

                @Override
                public void commandFinished(Command command) {
                    RConsole.this.cancel(true);
                }
            });
        } else if (this.frame > 0 && !basicCommand.isComment() && !RUtility.isBrowserCommand(string)) {
            basicCommand.setCommand("eval(parse(text=" + RUtility.quote(string) + "), sys.frame(" + this.frame + "))", false, string);
        } else if (string.equals("s")) {
            int n;
            int n2 = n = this.calls == null ? 0 : this.calls.length;
            if (n == 0) {
                basicCommand.setCommand("n", false, string);
            }
        }
        if (string.isEmpty() || string.equals("c") || string.equals("n")) {
            basicCommand.setCheckError(true);
            basicCommand.setAddToHistory(2);
        }
    }

    public void rShowMessage(Rengine rengine, String string) {
        LOGGER.fine("rShowMessage \"" + string + "\"");
    }

    public void rFlushConsole(Rengine rengine) {
        this.flushBuffer();
    }

    public void rLoadHistory(Rengine rengine, String string) {
        LOGGER.fine("load history");
    }

    public void rSaveHistory(Rengine rengine, String string) {
        LOGGER.fine("save history");
    }

    @Override
    public void onRSessionEvent(RSessionManager.RSessionEvent rSessionEvent) {
        switch (rSessionEvent.getType()) {
            case 1: {
                this.shuttingDown = true;
                this.clearPrompt();
                this.info("Restarting R...");
                break;
            }
            case 0: {
                this.shuttingDown = false;
                break;
            }
            case 2: {
                this.clearCommands(true);
                break;
            }
            case 3: {
                this.clearCommands(true);
                this.info("Connection Lost");
                break;
            }
            case 4: {
                this.info("Failed to connect to R");
            }
        }
    }

    public void addBusyListener(BusyListener busyListener) {
        this.busyListeners.add(busyListener);
    }

    public void removeBusyListener(BusyListener busyListener) {
        this.busyListeners.remove(busyListener);
    }

    private void fireBusyStateChanged(int n) {
        for (BusyListener busyListener : this.busyListeners) {
            busyListener.busyStateChanged(n);
        }
    }

    public void addConsoleListener(ConsoleListener consoleListener) {
        this.consoleListeners.add(consoleListener);
    }

    public void removeConsoleListener(ConsoleListener consoleListener) {
        this.consoleListeners.remove(consoleListener);
    }

    public void addBrowseListener(BrowseListener browseListener) {
        this.browseListeners.add(browseListener);
    }

    public void removeBrowseListener(BrowseListener browseListener) {
        this.browseListeners.remove(browseListener);
    }

    private void fireBrowseStateChanged(int n, boolean bl) {
        for (BrowseListener browseListener : this.browseListeners) {
            browseListener.browseStateChanged(n, bl);
        }
    }

    public void addRInteractiveActionEventHandler(SimpleEventHandler simpleEventHandler) {
        this.rInteractiveActionEventSupport.addEventHandler(simpleEventHandler);
    }

    public void removeRInteractiveActionEventHandler(SimpleEventHandler simpleEventHandler) {
        this.rInteractiveActionEventSupport.removeEventHandler(simpleEventHandler);
    }

    private class OutputIntercepter
    implements CommandListener {
        private StringBuffer captureBuffer;

        private OutputIntercepter() {
        }

        public void append(String string) {
            this.captureBuffer.append(string);
        }

        public String getText() {
            return this.captureBuffer != null ? this.captureBuffer.toString() : "";
        }

        @Override
        public void commandStart(Command command) {
            RConsole.this.interceptOutput = true;
            RConsole.this.intercepter = this;
            this.captureBuffer = new StringBuffer();
        }

        @Override
        public void commandFinished(Command command) {
            command.setOutput(this.getText());
            RConsole.this.intercepter = null;
            RConsole.this.interceptOutput = false;
        }

        @Override
        public void commandCanceled(Command command) {
            command.setOutput("");
            RConsole.this.intercepter = null;
            RConsole.this.interceptOutput = false;
        }

        @Override
        public void commandDiscarded(Command command) {
        }

        @Override
        public void errorOccurred(Command command) {
        }
    }
}

