/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.app.r.console;

import com.ef_prime.rflow.core.app.r.base.R;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;

public class RQueryQueue {
    private Queue<RunnableFuture<?>> queue = new ArrayDeque();
    private Timer timer = new Timer(true);

    public void addQuery(RunnableFuture<?> runnableFuture) {
        this.addQuery(runnableFuture, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addQuery(RunnableFuture<?> runnableFuture, long l) {
        RQueryQueue rQueryQueue = this;
        synchronized (rQueryQueue) {
            this.queue.offer(runnableFuture);
            if (l > 0L) {
                this.timer.schedule((TimerTask)new TimeoutTask(runnableFuture), l);
            }
        }
        if (R.console() != null) {
            R.console().notifyReceiver();
        }
    }

    public void addQuery(Runnable runnable) {
        this.addQuery(new FutureTask<Object>(runnable, null));
    }

    public void addQuery(Runnable runnable, long l) {
        this.addQuery(new FutureTask<Object>(runnable, null), l);
    }

    public synchronized RunnableFuture<?> pollQuery() {
        RunnableFuture<?> runnableFuture = this.queue.poll();
        while (runnableFuture != null && (runnableFuture.isCancelled() || runnableFuture.isDone())) {
            runnableFuture = this.queue.poll();
        }
        return runnableFuture;
    }

    public synchronized boolean removeQuery(RunnableFuture<?> runnableFuture) {
        return this.queue.remove(runnableFuture);
    }

    private class TimeoutTask
    extends TimerTask {
        private RunnableFuture<?> query;

        public TimeoutTask(RunnableFuture<?> runnableFuture) {
            this.query = runnableFuture;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.query.isDone()) {
                return;
            }
            RQueryQueue rQueryQueue = RQueryQueue.this;
            synchronized (rQueryQueue) {
                if (RQueryQueue.this.removeQuery(this.query)) {
                    this.query.cancel(false);
                }
            }
        }
    }
}

