/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.app.r.console;

import com.ef_prime.rflow.core.app.r.console.Command;
import com.ef_prime.rflow.core.app.r.console.CommandBuildFailedException;
import com.ef_prime.rflow.core.app.r.console.CommandPack;
import com.ef_prime.rflow.core.app.r.console.Executor;
import com.ef_prime.rflow.core.flow.FlowModel;
import com.ef_prime.rflow.core.flow.FlowNode;
import com.ef_prime.rflow.core.flow.FlowRunOption;
import com.ef_prime.rflow.core.flow.FlowUtil;
import com.ef_prime.rflow.core.flow.task.NodeTask;
import com.ef_prime.rflow.core.flow.task.NodeTaskEntry;
import com.ef_prime.rflow.core.flow.task.NodeTaskGroup;
import com.ef_prime.rflow.node.base.TunnelNodeModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TaskCommandPack
extends CommandPack {
    private static final Logger LOGGER = Logger.getLogger(TaskCommandPack.class.getName());
    private NodeTask task;
    private FlowRunOption originalRunOption;
    private FlowRunOption runOption;
    private Executor executor;
    private FlowModel flowModel;
    private NodeTask currentParent;
    private int currentIndex = 0;
    private int stepCount = 0;
    private NodeTask nextStepTask;
    private NodeTask lastTask;
    private List<NodeTask> finishedTasks = new ArrayList<NodeTask>();
    private HashSet<FlowNode> openedBoxes = new HashSet();

    public TaskCommandPack(NodeTask nodeTask, FlowRunOption flowRunOption, FlowModel flowModel) {
        this.task = nodeTask;
        this.originalRunOption = flowRunOption;
        this.runOption = flowRunOption.copy();
        this.flowModel = flowModel;
        this.executor = flowModel.getExecutor();
        this.currentParent = this.task;
    }

    @Override
    protected Command createNextCommand() throws CommandBuildFailedException {
        try {
            if (this.task.getChildCount() == 0) {
                if (this.currentIndex < 1) {
                    ++this.currentIndex;
                    return this.executor.buildCommand(this.task, null, this.runOption);
                }
                return null;
            }
            this.finishedTasks.clear();
            if (this.isDone()) {
                return null;
            }
            if (this.stepCount > 0) {
                return null;
            }
            while (this.currentTask().getAllowsChildren() && this.hasChildren()) {
                if (this.nextStepTask == null) {
                    this.nextStepTask = this.currentParent;
                }
                this.stepIn();
            }
            if (this.nextStepTask != null && this.nextStepTask == this.currentParent) {
                this.nextStepTask = null;
            }
            NodeTask nodeTask = this.lastTask;
            Command command = this.executor.buildCommand(this.currentTask(), nodeTask, this.runOption);
            if (this.runOption.isClearOnce()) {
                this.runOption = this.runOption.copy().setClearObjects(false);
            }
            this.runOption = this.runOption.copy().setExecRest(false);
            this.step();
            return command;
        }
        catch (CommandBuildFailedException commandBuildFailedException) {
            LOGGER.log(Level.SEVERE, "Failed to build command.", commandBuildFailedException);
            if (this.task.getChildCount() == 0) {
                this.currentIndex = 1;
            } else {
                this.currentParent = this.task;
                this.currentIndex = this.currentParent.getChildCount();
            }
            throw commandBuildFailedException;
        }
    }

    private void step() {
        this.lastTask = this.currentTask();
        this.finishedTasks.add(this.lastTask);
        ++this.currentIndex;
        while (this.currentParent != this.task && this.currentParent.getChildCount() <= this.currentIndex) {
            if (this.currentParent instanceof NodeTaskGroup && ((NodeTaskGroup)this.currentParent).getBaseTaskEntry() != null) {
                this.currentParent = ((NodeTaskGroup)this.currentParent).getBaseTaskEntry();
            }
            NodeTask nodeTask = this.currentParent;
            this.currentParent = (NodeTask)this.currentParent.getParent();
            this.currentIndex = this.currentParent.getIndex(nodeTask) + 1;
            this.finishedTasks.add(nodeTask);
        }
    }

    @Override
    public boolean hasNext() {
        if (this.task.getChildCount() == 0) {
            return this.currentIndex == 0;
        }
        return !this.isDone();
    }

    @Override
    public Command checkNextCommand() throws CommandBuildFailedException {
        if (this.task.getChildCount() == 0) {
            if (this.currentIndex < 1) {
                return this.executor.buildCommand(this.task, null, this.runOption);
            }
            return null;
        }
        if (this.isDone() || this.stepCount > 0) {
            return null;
        }
        return this.executor.buildCommand(this.currentTask(), this.lastTask, this.runOption);
    }

    public NodeTask getRootTask() {
        return this.task;
    }

    public FlowRunOption getRunOption() {
        return this.originalRunOption;
    }

    public NodeTask currentTask() {
        return (NodeTask)this.currentParent.getChildAt(this.currentIndex);
    }

    public int currentIndex() {
        return this.currentIndex;
    }

    public String getCurrentIndexLabel() {
        String string = "" + (this.currentIndex + 1);
        NodeTask nodeTask = this.currentParent;
        while (nodeTask.getParent() != null) {
            string = nodeTask.getParent().getIndex(nodeTask) + 1 + "-" + string;
            nodeTask = (NodeTask)nodeTask.getParent();
        }
        return string;
    }

    public boolean isDone() {
        return this.currentParent == this.task && this.currentParent.getChildCount() <= this.currentIndex;
    }

    public void skip() {
        this.step();
    }

    public boolean hasChildren() {
        return this.currentTask().getChildCount() > 0;
    }

    public boolean canStepIn() {
        if (this.hasChildren()) {
            return true;
        }
        FlowNode flowNode = this.currentTask().getLastNode();
        if (this.currentTask() instanceof NodeTaskEntry && flowNode != null) {
            List<FlowNode> list = FlowUtil.getStream(flowNode, true, false, false);
            if (list.size() <= 1) {
                return false;
            }
            if (this.lastTask == null) {
                return true;
            }
            int n = list.size() - 2;
            FlowNode flowNode2 = list.get(n);
            while (flowNode2.getModel() instanceof TunnelNodeModel) {
                if (--n < 0) {
                    return false;
                }
                flowNode2 = list.get(n);
            }
            if (flowNode2 != this.lastTask.getLastNode()) {
                return true;
            }
        }
        return false;
    }

    public void stepIn() {
        if (this.hasChildren()) {
            this.currentParent = this.currentTask();
        } else {
            NodeTaskEntry nodeTaskEntry = (NodeTaskEntry)this.currentTask();
            FlowNode flowNode = this.lastTask == null ? null : this.lastTask.getLastNode();
            NodeTaskGroup nodeTaskGroup = this.executor.createAllStepTask(nodeTaskEntry.getNode(), null, flowNode, this.runOption);
            nodeTaskGroup.setBaseTaskEntry(nodeTaskEntry);
            this.currentParent = nodeTaskGroup;
        }
        this.currentIndex = 0;
    }

    public void setStepCount(int n) {
        this.stepCount = n;
        if (n == 0) {
            this.nextStepTask = null;
        }
    }

    public void addOpenedBox(FlowNode flowNode) {
        this.openedBoxes.add(flowNode);
    }

    public void removeOpenedBox(FlowNode flowNode) {
        this.openedBoxes.remove(flowNode);
    }

    public Set<FlowNode> getOpenedBoxes() {
        return Collections.unmodifiableSet(this.openedBoxes);
    }

    public void setExecuter(Executor executor) {
        this.executor = executor;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public FlowModel getFlowModel() {
        return this.flowModel;
    }

    @Override
    public synchronized void finish() {
        this.finishedTasks.clear();
        super.finish();
    }
}

