/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.app.r.keyvalue;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.core.app.r.keyvalue.RChoiceKey;
import com.ef_prime.rflow.core.app.r.keyvalue.RStrKey;
import com.ef_prime.rflow.core.app.r.keyvalue.RTableKey;
import com.ef_prime.rflow.core.base.DevelSettings;
import com.ef_prime.rflow.core.common.keyvalue.BasicValueError;
import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.keyvalue.TableRowValidator;
import com.ef_prime.rflow.core.common.keyvalue.ValidationContext;
import com.ef_prime.rflow.core.common.keyvalue.ValueError;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.core.common.table.GeneralTableModel;
import com.ef_prime.rflow.core.common.table.KeysTableModel;
import com.ef_prime.rflow.core.common.table.KeysTableRow;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.app.r.RChoiceProvider;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class RArgsKey
extends RTableKey {
    private String function;
    private String functionLabel;
    private Set<String> excludes;

    public RArgsKey(Builder<?> builder) {
        super((RTableKey.Builder<?>)builder);
        this.function = builder.function;
        this.functionLabel = builder.functionLabel;
        this.excludes = builder.excludes;
    }

    public RArgsKey(Map<?, ?> map) {
        super(map);
    }

    public String getFunction() {
        return this.function;
    }

    public String getFunctionLabel() {
        return this.functionLabel;
    }

    public Set<String> getExcludes() {
        if (this.excludes == null) {
            return Collections.EMPTY_SET;
        }
        return this.excludes;
    }

    @Override
    protected void validate(KeysTableModel keysTableModel, ValidationContext validationContext) {
        super.validate(keysTableModel, validationContext);
        List list = keysTableModel.getRows();
        if (!list.isEmpty()) {
            String string2 = list.stream().map(keysTableRow -> (String)keysTableRow.getValue(0)).filter(string -> !string.isEmpty()).collect(Collectors.joining(", "));
            validationContext.addError(this, new BasicValueError(2, string2, this));
        }
    }

    public static Builder<?> builder(String string2, String string3, String string4, String ... stringArray) {
        Predicate<String> predicate = null;
        HashSet hashSet = null;
        if (stringArray != null && stringArray.length > 0) {
            HashSet hashSet2 = Sets.newHashSet((Object[])stringArray);
            predicate = string -> !hashSet2.contains(string);
            hashSet = hashSet2;
        }
        boolean bl = true;
        try {
            bl = Rflow.develSettings().getValue(DevelSettings.KEY_ALPHABETICAL_ARGS_COMPLETION);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        RChoiceKey rChoiceKey = ((RChoiceKey.Builder)((Key.Builder)RChoiceKey.builder("param", Messages.getString("ArgsTable.parameter")).setCompletionSupport(RChoiceProvider.args(string4, bl, predicate).setExclusive(true))).setRequired(true)).build();
        RStrKey rStrKey = ((RStrKey.Builder)((RStrKey.Builder)RStrKey.builder("value", Messages.getString("ArgsTable.value")).setRequired(true)).setMultiLine(true)).build();
        return new Builder2(string2, string3, string4, hashSet, rChoiceKey, rStrKey);
    }

    public static abstract class Builder<T extends Builder<T>>
    extends RTableKey.Builder<T> {
        private String function;
        private String functionLabel;
        private Set<String> excludes;

        public Builder(String string, String string2, String string3, Set<String> set, Key<?> ... keyArray) {
            super(string, string2, keyArray);
            this.function = string3;
            this.excludes = set;
            this.setUiControls(GeneralTableModel.UI_DEFAULT2);
            this.setLabelPosition("none");
            this.addRowValidator(new TableRowValidator(){

                @Override
                public ValueError validate(Key<?> key, KeysTableModel keysTableModel, KeysTableRow keysTableRow, int n) {
                    ValueMap valueMap = keysTableModel.getParentValueMap();
                    if (valueMap == null) {
                        return null;
                    }
                    String string = (String)keysTableRow.getValue(0);
                    if (valueMap.getKey(string) != null || ((RArgsKey)key).getExcludes().contains(string)) {
                        return new BasicValueError(3, Messages.getString("Widget.R.Error.arg_override"), key);
                    }
                    return null;
                }
            });
            this.setEnabledFunction(valueMap -> true);
        }

        public T setFunctionLabel(String string) {
            this.functionLabel = string;
            return (T)((Builder)this.self());
        }

        @Override
        public RArgsKey build() {
            return new RArgsKey(this);
        }
    }

    private static class Builder2
    extends Builder<Builder2> {
        public Builder2(String string, String string2, String string3, Set<String> set, Key<?> ... keyArray) {
            super(string, string2, string3, set, keyArray);
        }

        @Override
        protected Builder2 self() {
            return this;
        }
    }
}

