/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.app.r.keyvalue;

import com.ef_prime.rflow.core.app.r.base.R;
import com.ef_prime.rflow.core.app.r.base.RUtility;
import com.ef_prime.rflow.core.common.keyvalue.BatchAddSupport;
import com.ef_prime.rflow.core.common.keyvalue.ChoiceKey;
import com.ef_prime.rflow.core.common.keyvalue.ValidationContext;
import com.ef_prime.rflow.core.common.keyvalue.ValueErrors;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.core.feature.search.KeySearchResult;
import com.ef_prime.rflow.core.feature.search.SearchContext;
import com.ef_prime.rflow.core.feature.search.SearchResult;
import com.ef_prime.rflow.core.feature.search.SearchUtility;
import com.ef_prime.rflow.core.feature.search.TextSearchResult;
import com.ef_prime.rflow.core.util.YamlEx;
import com.ef_prime.rflow.ui.app.r.RChoiceProvider;
import com.ef_prime.rflow.ui.app.r.RImporters;
import com.ef_prime.rflow.ui.app.r.keyvalue.RChoiceBatchAddSupport;
import java.util.List;
import java.util.Map;

public class RChoiceKey
extends ChoiceKey {
    public static final String[] ENCODINGS = new String[]{"", "System Default", RUtility.quote("UTF-8"), "", RUtility.quote("ASCII"), "", RUtility.quote("BIG5"), "", RUtility.quote("CP932"), "Windows Shift_JIS", RUtility.quote("GB18030"), "", RUtility.quote("GB2312"), "", RUtility.quote("ISO-2022-JP"), "", RUtility.quote("ISO-2022-KR"), "", RUtility.quote("ISO-8859-1"), "Latin 1", RUtility.quote("ISO-8859-2"), "", RUtility.quote("ISO-8859-7"), "", RUtility.quote("Shift-JIS"), "", RUtility.quote("WINDOWS-1252"), ""};
    public static final String[] ENCODINGS_NO_QUOTE = new String[]{"UTF-8", "", "ASCII", "", "BIG5", "", "CP932", "Windows Shift_JIS", "GB18030", "", "GB2312", "", "ISO-2022-JP", "", "ISO-2022-KR", "", "ISO-8859-1", "Latin 1", "ISO-8859-2", "", "ISO-8859-7", "", "Shift-JIS", "", "WINDOWS-1252", ""};
    private boolean charSupport;

    public RChoiceKey(Map<?, ?> map) {
        super(map);
        String string;
        Map<Object, Object> map2;
        if (!map.containsKey("input")) {
            this.choiceEditable = true;
        }
        if (!map.containsKey("value-and-label") && this.choiceEditable) {
            this.showValueAndLabel = true;
        }
        if ((map2 = YamlEx.map(map.get("list"))) != null && (string = YamlEx.string(map2.get("type"))) != null) {
            switch (string) {
                case "data.frame": {
                    this.choiceProvider = RChoiceProvider.globalDataFrames();
                    this.addImporter(RImporters.DATAFRAME_IMPORTER);
                    break;
                }
                case "column": {
                    String string2 = YamlEx.string(map2.get("key"));
                    if (string2 == null) break;
                    this.choiceProvider = RChoiceProvider.columns(string2, true);
                }
            }
        }
    }

    protected RChoiceKey(Builder<?> builder) {
        super((ChoiceKey.Builder<?>)builder);
        this.charSupport = builder.charSupport;
    }

    public static Builder<?> builder(String string, String string2) {
        return new Builder2(string, string2);
    }

    public boolean isCharSupport() {
        return this.charSupport;
    }

    @Override
    public void search(List<SearchResult> list, SearchContext searchContext, Object object, ValueMap valueMap) {
        List<TextSearchResult> list2 = SearchUtility.searchRScript(searchContext, (String)object);
        for (TextSearchResult textSearchResult : list2) {
            list.add(new KeySearchResult(this, textSearchResult));
        }
    }

    @Override
    protected String getYamlType() {
        return "rchoice";
    }

    public RChoiceProvider getCompletionSupport() {
        return (RChoiceProvider)this.choiceProvider;
    }

    @Override
    public BatchAddSupport<?> getBatchAddSupport() {
        return new RChoiceBatchAddSupport(this);
    }

    @Override
    protected void toYaml(Map<Object, Object> map) {
        super.toYaml(map);
        if (this.getCompletionSupport() != null) {
            map.put("list", this.getCompletionSupport().toYaml());
        }
    }

    @Override
    protected void validate(String string, ValidationContext validationContext) {
        super.validate(string, validationContext);
        String string2 = R.client().checkSyntax(string);
        if (string2 != null) {
            validationContext.addError(this, ValueErrors.rSyntax(this));
        }
    }

    public static abstract class Builder<T extends Builder<T>>
    extends ChoiceKey.Builder<T> {
        private boolean charSupport;

        public Builder(String string, String string2) {
            super(string, string2);
            this.setChoiceEditable(true);
            this.showValueAndLabel(true);
        }

        @Override
        public RChoiceKey build() {
            return new RChoiceKey(this);
        }

        public T setCompletionSupport(RChoiceProvider rChoiceProvider) {
            this.setChoiceProvider(rChoiceProvider);
            return (T)((Builder)this.self());
        }

        public T setCharSupport(boolean bl) {
            this.charSupport = bl;
            return (T)((Builder)this.self());
        }
    }

    private static class Builder2
    extends Builder<Builder2> {
        public Builder2(String string, String string2) {
            super(string, string2);
        }

        @Override
        protected Builder2 self() {
            return this;
        }
    }
}

