/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.app.r.keyvalue;

import com.ef_prime.rflow.core.app.r.base.R;
import com.ef_prime.rflow.core.common.keyvalue.StrKey;
import com.ef_prime.rflow.core.common.keyvalue.ValidationContext;
import com.ef_prime.rflow.core.common.keyvalue.ValueErrors;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.core.feature.search.KeySearchResult;
import com.ef_prime.rflow.core.feature.search.SearchContext;
import com.ef_prime.rflow.core.feature.search.SearchResult;
import com.ef_prime.rflow.core.feature.search.SearchUtility;
import com.ef_prime.rflow.core.feature.search.TextSearchResult;
import com.ef_prime.rflow.ui.app.r.RChoiceProvider;
import com.ef_prime.rflow.ui.app.r.script.AbstractRCodingTextArea;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class RStrKey
extends StrKey {
    private RChoiceProvider completionSupport;
    private boolean charSupport;
    private boolean output;
    private Function<String, String> syntaxCheckPreprocessor;

    public RStrKey(String string, String string2) {
        this(string, string2, "");
    }

    public RStrKey(String string, String string2, String string3) {
        this(string, string2, string3, string, null);
    }

    public RStrKey(String string, String string2, String string3, String string4, RChoiceProvider rChoiceProvider) {
        super(string, string2, string3);
        this.subTitle = string4;
        this.completionSupport = rChoiceProvider;
    }

    public RStrKey(Map<?, ?> map) {
        super(map);
    }

    private RStrKey(Builder<?> builder) {
        super((StrKey.Builder<?>)builder);
        this.completionSupport = builder.completionSupport;
        this.charSupport = builder.charSupport;
        this.output = builder.output;
        this.syntaxCheckPreprocessor = builder.syntaxCheckPreprocessor;
    }

    public static Builder<?> builder(String string) {
        return new Builder2(string);
    }

    public static Builder<?> builder(String string, String string2) {
        return (Builder)new Builder2(string).setTitle(string2);
    }

    @Override
    protected String getYamlType() {
        return "rstring";
    }

    public RChoiceProvider getCompletionSupport() {
        return this.completionSupport;
    }

    public boolean isCharSupport() {
        return this.charSupport;
    }

    public boolean isOutput() {
        return this.output;
    }

    public void installCompletionSupport(AbstractRCodingTextArea abstractRCodingTextArea, ValueMap valueMap) {
        if (this.completionSupport != null) {
            RChoiceProvider.install(this.completionSupport, abstractRCodingTextArea, valueMap);
        }
    }

    @Override
    public void search(List<SearchResult> list, SearchContext searchContext, Object object, ValueMap valueMap) {
        List<TextSearchResult> list2 = SearchUtility.searchRScript(searchContext, (String)object);
        for (TextSearchResult textSearchResult : list2) {
            list.add(new KeySearchResult(this, textSearchResult));
        }
    }

    @Override
    protected void toYaml(Map<Object, Object> map) {
        super.toYaml(map);
    }

    @Override
    protected void validate(String string, ValidationContext validationContext) {
        super.validate(string, validationContext);
        if (R.client() != null) {
            String string2 = this.syntaxCheckPreprocessor == null ? string : this.syntaxCheckPreprocessor.apply(string);
            String string3 = R.client().checkSyntax(string2);
            if (string3 != null) {
                validationContext.addError(this, ValueErrors.rSyntax(this));
            }
        }
    }

    public static abstract class Builder<T extends Builder<T>>
    extends StrKey.Builder<T> {
        private RChoiceProvider completionSupport;
        private boolean charSupport;
        private boolean output;
        private Function<String, String> syntaxCheckPreprocessor;

        public Builder(String string, String string2) {
            super(string, string2);
        }

        @Override
        public RStrKey build() {
            return new RStrKey(this);
        }

        public T setCompletionSupport(RChoiceProvider rChoiceProvider) {
            this.completionSupport = rChoiceProvider;
            return (T)((Builder)this.self());
        }

        public T setCharSupport(boolean bl) {
            this.charSupport = bl;
            return (T)((Builder)this.self());
        }

        public T setOutput(boolean bl) {
            this.output = bl;
            return (T)((Builder)this.self());
        }

        public T setSyntaxCheckPreprocessor(Function<String, String> function) {
            this.syntaxCheckPreprocessor = function;
            return (T)((Builder)this.self());
        }
    }

    private static class Builder2
    extends Builder<Builder2> {
        public Builder2(String string) {
            super(string, string);
        }

        @Override
        protected Builder2 self() {
            return this;
        }
    }
}

