/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.app.r.keyvalue;

import com.ef_prime.rflow.core.app.r.base.R;
import com.ef_prime.rflow.core.common.keyvalue.TextKey;
import com.ef_prime.rflow.core.common.keyvalue.ValidationContext;
import com.ef_prime.rflow.core.common.keyvalue.ValueErrors;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.ui.app.r.RChoiceProvider;
import com.ef_prime.rflow.ui.app.r.script.AbstractRCodingTextArea;
import java.util.function.Function;

public class RTextKey
extends TextKey {
    private Function<String, String> syntaxCheckPreprocessor;
    private RChoiceProvider completionSupport;

    public RTextKey(Builder<?> builder) {
        super((TextKey.Builder<?>)builder);
        this.syntaxCheckPreprocessor = builder.syntaxCheckPreprocessor;
        this.completionSupport = builder.completionSupport;
    }

    public static Builder<?> builder(String string, String string2) {
        return (Builder)new Builder2(string).setTitle(string2);
    }

    public RChoiceProvider getCompletionSupport() {
        return this.completionSupport;
    }

    public void installCompletionSupport(AbstractRCodingTextArea abstractRCodingTextArea, ValueMap valueMap) {
        if (this.completionSupport != null) {
            RChoiceProvider.install(this.completionSupport, abstractRCodingTextArea, valueMap);
        }
    }

    @Override
    protected void validate(String string, ValidationContext validationContext) {
        super.validate(string, validationContext);
        if (R.client() != null) {
            String string2 = this.syntaxCheckPreprocessor == null ? string : this.syntaxCheckPreprocessor.apply(string);
            String string3 = R.client().checkSyntax(string2);
            if (string3 != null) {
                validationContext.addError(this, ValueErrors.rSyntax(this));
            }
        }
    }

    public static abstract class Builder<T extends Builder<T>>
    extends TextKey.Builder<T> {
        private Function<String, String> syntaxCheckPreprocessor;
        private RChoiceProvider completionSupport;

        public Builder(String string, String string2) {
            super(string, string2);
        }

        @Override
        public RTextKey build() {
            return new RTextKey(this);
        }

        public T setSyntaxCheckPreprocessor(Function<String, String> function) {
            this.syntaxCheckPreprocessor = function;
            return (T)((Builder)this.self());
        }

        public T setCompletionSupport(RChoiceProvider rChoiceProvider) {
            this.completionSupport = rChoiceProvider;
            return (T)((Builder)this.self());
        }
    }

    private static class Builder2
    extends Builder<Builder2> {
        public Builder2(String string) {
            super(string, string);
        }

        @Override
        protected Builder2 self() {
            return this;
        }
    }
}

