/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.app.r.script;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.text.Segment;
import org.fife.ui.rsyntaxtextarea.AbstractTokenMaker;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rsyntaxtextarea.TokenImpl;
import org.fife.ui.rsyntaxtextarea.TokenMap;

public class RTokenMaker
extends AbstractTokenMaker {
    public static final String RSYNTAX_KEY = "RSYNTAX";
    private static final List<String> separatorOpen = Collections.unmodifiableList(Arrays.asList("(", "{"));

    public void addToken(Segment segment, int n, int n2, int n3, int n4) {
        switch (n3) {
            case 20: {
                int n5 = this.wordsToHighlight.get(segment, n, n2);
                if (n5 == -1) break;
                n3 = n5;
            }
        }
        super.addToken(segment, n, n2, n3, n4);
    }

    public boolean getCurlyBracesDenoteCodeBlocks(int n) {
        return true;
    }

    public boolean getShouldIndentNextLineAfter(Token token) {
        if (token != null && token.length() == 1) {
            char c = token.getTextArray()[token.getTextOffset()];
            return c == '{' || c == '(';
        }
        return false;
    }

    private static boolean isSeparatorOpen(Token token) {
        return separatorOpen.contains(token.getLexeme());
    }

    private static boolean isOperator(Token token) {
        return token.getType() == 23;
    }

    public static boolean getShouldIndentNextLine(Token token, Token token2) {
        if (token == null) {
            return false;
        }
        if (RTokenMaker.isSeparatorOpen(token)) {
            return true;
        }
        if (RTokenMaker.isOperator(token)) {
            if (token2 == null) {
                return true;
            }
            return !RTokenMaker.isOperator(token2);
        }
        return false;
    }

    public TokenMap getWordsToHighlight() {
        TokenMap tokenMap = new TokenMap();
        tokenMap.put("if", 6);
        tokenMap.put("else", 6);
        tokenMap.put("while", 6);
        tokenMap.put("repeat", 6);
        tokenMap.put("for", 6);
        tokenMap.put("in", 6);
        tokenMap.put("break", 6);
        tokenMap.put("next", 6);
        tokenMap.put("function", 6);
        tokenMap.put("TRUE", 9);
        tokenMap.put("FALSE", 9);
        tokenMap.put("T", 9);
        tokenMap.put("F", 9);
        tokenMap.put("NULL", 9);
        tokenMap.put("NaN", 9);
        tokenMap.put("NA", 9);
        tokenMap.put("Inf", 9);
        tokenMap.put("NA_integer_", 9);
        tokenMap.put("NA_real_", 9);
        tokenMap.put("NA_character_", 9);
        tokenMap.put("NA_complex_", 9);
        return tokenMap;
    }

    public String[] getLineCommentStartAndEnd(int n) {
        return new String[]{"#", null};
    }

    public boolean getMarkOccurrencesOfTokenType(int n) {
        switch (n) {
            case 8: 
            case 15: 
            case 20: {
                return true;
            }
        }
        return false;
    }

    private boolean string(Segment segment, char c, int[] nArray, int n, int n2, boolean bl) {
        char c2;
        int n3 = nArray[0];
        boolean bl2 = false;
        int n4 = n3++;
        if (bl) {
            // empty if block
        }
        while (n3 < n && (c2 = segment.array[n3]) != c) {
            if (c2 == '\\') {
                if (n3 >= n - 1) break;
                c2 = segment.array[++n3];
            }
            ++n3;
        }
        if (n3 < n) {
            ++n3;
        } else {
            bl2 = true;
        }
        int n5 = 13;
        if (c == '\"') {
            n5 = 13;
        } else if (c == '\'') {
            n5 = 14;
        } else if (c == '`') {
            n5 = 15;
        }
        this.addToken(segment, n4, n3 - 1, n5, n2 + n4);
        nArray[0] = n3;
        return bl2;
    }

    private void number(Segment segment, int[] nArray, int n, int n2) {
        char c;
        int n3 = nArray[0];
        char c2 = c = RTokenMaker.charAt(segment, n3);
        int n4 = c == '.' ? 1 : 0;
        boolean bl = false;
        int n5 = 0;
        int n6 = 10;
        int n7 = n3;
        block0: while ((RTokenMaker.isDigit(c = RTokenMaker.charAt(segment, ++n3)) || c == '.' || c == 'e' || c == 'E' || c == 'x' || c == 'X' || c == 'L') && c != 'L') {
            if (c == 'x' || c == 'X') {
                if (n3 - n7 > 2 || c2 != '0') break;
                while (RTokenMaker.isDigit(c = RTokenMaker.charAt(segment, ++n3)) || 'a' <= c && c <= 'f' || 'A' <= c && c <= 'F' || c == '.') {
                    if (c == '.') {
                        if (n4 > 0) {
                            n6 = 36;
                            break block0;
                        }
                        n4 = 1;
                    }
                    ++n5;
                }
                if (n5 == 0) {
                    n6 = 36;
                    break;
                }
                if (c == 'p' || c == 'P') {
                    bl = true;
                    if (!RTokenMaker.isDigit(c = RTokenMaker.charAt(segment, ++n3)) && c != '+' && c != '-') {
                        n6 = 36;
                        break;
                    }
                    if (c == '+' || c == '-') {
                        c = RTokenMaker.charAt(segment, ++n3);
                    }
                    n5 = 0;
                    while (RTokenMaker.isDigit(c)) {
                        c = RTokenMaker.charAt(segment, ++n3);
                        ++n5;
                    }
                    if (n5 == 0) {
                        n6 = 36;
                        break;
                    }
                }
                if (n4 <= 0 || bl) break;
                n6 = 36;
                break;
            }
            if (c == 'E' || c == 'e') {
                if (bl) break;
                bl = true;
                n4 = n4 == 1 ? 1 : 2;
                if (!RTokenMaker.isDigit(c = RTokenMaker.charAt(segment, ++n3)) && c != '+' && c != '-') {
                    n6 = 36;
                    break;
                }
                if (!(c != '+' && c != '-' || RTokenMaker.isDigit(c = RTokenMaker.charAt(segment, ++n3)))) {
                    n6 = 36;
                    break;
                }
            }
            if (c == '.') {
                if (n4 > 0) break;
                n4 = 1;
            }
            c2 = c;
        }
        if (c == 'i' || c == 'L') {
            ++n3;
        }
        this.addToken(segment, n7, n3 - 1, n6, n2 + n7);
        nArray[0] = n3;
    }

    private static char charAt(Segment segment, int n) {
        if (n >= segment.offset + segment.count) {
            return '\u0000';
        }
        return segment.array[n];
    }

    private static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    public Token getTokenList(Segment segment, int n, int n2) {
        this.resetTokenList();
        int n3 = n2 - segment.offset;
        int n4 = segment.offset;
        int n5 = n;
        int n6 = segment.offset + segment.count;
        boolean bl = false;
        int[] nArray = new int[1];
        int n7 = segment.offset;
        block21: while (n7 < n6) {
            boolean bl2;
            boolean bl3;
            n4 = n7;
            char c = segment.array[n7];
            nArray[0] = n7;
            switch (n5) {
                case 14: {
                    bl = this.string(segment, '\'', nArray, n6, n3, false);
                    n7 = nArray[0];
                    n5 = 0;
                    continue block21;
                }
                case 13: {
                    bl = this.string(segment, '\"', nArray, n6, n3, false);
                    n7 = nArray[0];
                    n5 = 0;
                    continue block21;
                }
                case 15: {
                    bl = this.string(segment, '`', nArray, n6, n3, false);
                    n7 = nArray[0];
                    n5 = 0;
                    continue block21;
                }
            }
            n4 = n7;
            while (n7 < n6 && Character.isWhitespace(segment.array[n7])) {
                ++n7;
            }
            if (n7 > n4) {
                this.addToken(segment, n4, n7 - 1, 21, n3 + n4);
            }
            if (n7 == n6) continue;
            if (segment.array[n7] == '#') {
                this.addToken(segment, n7, n6 - 1, 1, n3 + n7);
                n7 = n6;
                continue;
            }
            boolean bl4 = bl3 = segment.array[n7] == '.' && (n7 >= n6 - 1 || !RTokenMaker.isDigit(segment.array[n7 + 1]));
            if (!bl3) {
                c = segment.array[n7];
                if (c == '.' || RTokenMaker.isDigit(c)) {
                    nArray[0] = n7;
                    this.number(segment, nArray, n6, n3);
                    n7 = nArray[0];
                    continue;
                }
                c = segment.array[n7];
                if (c == '\"' || c == '\'' || c == '`') {
                    nArray[0] = n7;
                    bl = this.string(segment, c, nArray, n6, n3, true);
                    n7 = nArray[0];
                    continue;
                }
                if (c == '%') {
                    n4 = n7++;
                    while (n7 < n6 && (c = segment.array[n7]) != '%') {
                        ++n7;
                    }
                    if (n7 != n6) {
                        this.addToken(segment, n4, ++n7 - 1, 23, n3 + n4);
                        continue;
                    }
                    this.addToken(segment, n4, n7 - 1, 35, n3 + n4);
                    continue;
                }
            }
            if ((c = segment.array[n7]) == '.' || Character.isUnicodeIdentifierStart(c) || c == '_') {
                n4 = n7++;
                while (n7 < n6 && (Character.isUnicodeIdentifierPart(c = segment.array[n7]) || c == '.' || c == '_')) {
                    ++n7;
                }
                this.addToken(segment, n4, n7 - 1, 20, n3 + n4);
                continue;
            }
            n4 = n7++;
            int n8 = 32;
            boolean bl5 = bl2 = n7 >= n6;
            if (!bl2) {
                n8 = segment.array[n7];
            }
            int n9 = 23;
            switch (c) {
                case '<': {
                    if (bl2 || n8 != 61 && n8 != 45 && n8 != 60) break;
                    ++n7;
                    if (n8 != 60) break;
                    this.addToken(segment, n4, n7 - 1, n7 < n6 && segment.array[n7] == '-' ? 23 : 35, n3 + n4);
                    continue block21;
                }
                case '-': {
                    if (bl2 || n8 != 62 || ++n7 >= n6 || segment.array[n7] != '>') break;
                    ++n7;
                    break;
                }
                case '>': {
                    if (bl2 || n8 != 61) break;
                    ++n7;
                    break;
                }
                case '!': {
                    if (bl2 || n8 != 61) break;
                    ++n7;
                    break;
                }
                case '=': {
                    if (bl2 || n8 != 61) break;
                    ++n7;
                    break;
                }
                case ':': {
                    if (n7 < n6 && segment.array[n7] == ':') {
                        if (++n7 >= n6 || segment.array[n7] != ':') break;
                        ++n7;
                        break;
                    }
                    if (bl2 || n8 != 61) break;
                    ++n7;
                    break;
                }
                case '&': {
                    if (bl2 || n8 != 38) break;
                    ++n7;
                    break;
                }
                case '|': {
                    if (bl2 || n8 != 124) break;
                    ++n7;
                    break;
                }
                case '(': 
                case ')': 
                case '{': 
                case '}': {
                    n9 = 22;
                    break;
                }
                case '[': {
                    if (!bl2 && n8 == 91) {
                        ++n7;
                    }
                    n9 = 22;
                    break;
                }
                case ']': {
                    n9 = 22;
                }
                case '?': {
                    break;
                }
                case '*': {
                    if (bl2 || n8 != 42) break;
                    ++n7;
                    break;
                }
                case '$': 
                case '+': 
                case '/': 
                case '@': 
                case '^': 
                case '~': {
                    break;
                }
            }
            this.addToken(segment, n4, n7 - 1, n9, n3 + n4);
        }
        if (!bl) {
            this.addNullToken();
        }
        for (TokenImpl tokenImpl = this.firstToken; tokenImpl != null; tokenImpl = tokenImpl.getNextToken()) {
            if (tokenImpl.getType() != 20 && tokenImpl.getType() != 15) continue;
            TokenImpl tokenImpl2 = tokenImpl;
            if ((tokenImpl = tokenImpl.getNextToken()) == null || tokenImpl.getType() == 21 && (tokenImpl = tokenImpl.getNextToken()) == null) break;
            if (tokenImpl.getType() != 22 || tokenImpl.length() != 1 || tokenImpl.getTextArray()[tokenImpl.getTextOffset()] != '(') continue;
            tokenImpl2.setType(8);
        }
        return this.firstToken;
    }

    public int getLastTokenTypeOnLine(Segment segment, int n) {
        if (segment.count == 0) {
            return n;
        }
        return super.getLastTokenTypeOnLine(segment, n);
    }
}

