/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.base;

import com.ef_prime.rflow.core.base.UserFolder;
import com.ef_prime.rflow.core.common.keyvalue.BoolKey;
import com.ef_prime.rflow.core.common.keyvalue.ChoiceKey;
import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.keyvalue.PanelWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.SplitPaneWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.TitledPanelWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.core.common.keyvalue.ViewOptions;
import com.ef_prime.rflow.core.common.keyvalue.WidgetNode;
import com.ef_prime.rflow.ui.common.event.ChangeEventHandler;
import com.ef_prime.rflow.ui.common.event.ChangeEventSupport;
import com.ef_prime.rflow.ui.common.view.ViewOpenType;
import java.io.File;
import java.io.IOException;

public class DevelSettings
extends ValueMap {
    private File develSettingsFile = UserFolder.getUserDirFile("devel.settings");
    private static final String OPEN_IN_TAB = "current tab";
    private static final String OPEN_NEW_TAB = "new tab";
    private static final String OPEN_NORMAL = "normal";
    private static final String OPEN_PREVIEW = "preview";
    private static final String OPEN_OR_MOVE = "move_if_opening";
    public static final String TAB_TITLE_NODE = "node";
    public static final String TAB_TITLE_FILE = "file";
    public static final String WINDOW_DIALOG = "dialog";
    public static final String WINDOW_TAB = "tab";
    public static final String WINDOW_LEFT_BOTTOM_TAB = "left bottom tab";
    public static final BoolKey KEY_PROJECT_VIEW = BoolKey.builder("project_view", "Project View").build();
    public static final BoolKey KEY_VIEW_DB = BoolKey.builder("view_db", "Database").build();
    public static final BoolKey KEY_VIEW_OBJECT = BoolKey.builder("view_object", "Object").build();
    public static final BoolKey KEY_VIEW_RUN_LOG_CLASSIC = BoolKey.builder("view_run_log_classic", "Run Log Classic").build();
    public static final BoolKey KEY_VIEW_SESSION_LOG = BoolKey.builder("view_session_log", "Session Log").build();
    public static final BoolKey KEY_VIEW_PREVIEW = BoolKey.builder("view_preview", "Preview").build();
    public static final BoolKey KEY_VIEW_RUN_LOG = BoolKey.builder("view_run_log", "Run Log").build();
    public static final BoolKey KEY_VIEW_APP_LOG = BoolKey.builder("view_app_log", "Application Log").build();
    public static final BoolKey CUSTOM_OPEN_MODE = ((BoolKey.Builder)BoolKey.builder("custom_open_mode", "Custom Open Mode").noLabel()).build();
    public static final BoolKey KEY_KEEP_ROOT_FLOW = ((BoolKey.Builder)BoolKey.builder("keep_root_flow", "Keep Root Flow (Close file if root is closed)").setDefaultValue(Boolean.TRUE)).build();
    public static final ChoiceKey KEY_OPEN_BOX_IN_TOP = ((ChoiceKey.Builder)((Key.Builder)ChoiceKey.builder("open_box_in_top", "Open Box in Top").setValues("current tab", "new tab")).setDefaultValue("current tab")).build();
    public static final ChoiceKey KEY_OPEN_BOX_IN_BOX = ((ChoiceKey.Builder)((Key.Builder)ChoiceKey.builder("open_box_in_box", "Open Box in Box").setValues("current tab", "new tab")).setDefaultValue("current tab")).build();
    public static final ChoiceKey KEY_OPEN_NODE = ((ChoiceKey.Builder)((Key.Builder)ChoiceKey.builder("open_node", "Open Node").setValues("current tab", "new tab")).setDefaultValue("new tab")).build();
    public static final ChoiceKey KEY_OPEN_IN_NODE = ((ChoiceKey.Builder)((Key.Builder)ChoiceKey.builder("open_in_node", "Open in Node").setValues("current tab", "new tab")).setDefaultValue("new tab")).build();
    public static final ChoiceKey KEY_TAB_TITLE = ((ChoiceKey.Builder)((Key.Builder)ChoiceKey.builder("tab_title", "Tab Title").setValues("node", "file")).setDefaultValue("node")).build();
    public static final ChoiceKey KEY_OPEN_IN_PREVIEW = ((ChoiceKey.Builder)((Key.Builder)ChoiceKey.builder("open_in_preview", "Open in Preview").setValues("normal", "preview")).setDefaultValue("normal")).build();
    public static final ChoiceKey KEY_ADDRESSBAR_OPEN = ((ChoiceKey.Builder)((Key.Builder)ChoiceKey.builder("address_bar_open", "Open at Address Bar").setValues("normal", "move_if_opening")).setDefaultValue("normal")).build();
    public static final ChoiceKey UINODE_WINDOW = ((ChoiceKey.Builder)((Key.Builder)ChoiceKey.builder("uinode_window", "UI Node Window").setValues("dialog", "tab", "left bottom tab")).setDefaultValue("dialog")).build();
    public static final BoolKey KEY_TAB_FLOAT = BoolKey.builder("tab_float", "Tab Float").build();
    public static final BoolKey KEY_OUTPUT_PREVIEW_CODE = BoolKey.builder("output_preview_code", "Output Preview Code").build();
    public static final BoolKey KEY_TOOLBAR_SELECTOR = BoolKey.builder("toolbar_selector", "Toolbar Selector").build();
    public static final BoolKey KEY_TAB_COMPLETION = ((BoolKey.Builder)BoolKey.builder("tab_completion", "Tab Completion").setDefaultValue(true)).build();
    public static final BoolKey KEY_ALPHABETICAL_ARGS_COMPLETION = ((BoolKey.Builder)BoolKey.builder("alpha_args_completion", "Alphabetical order args completion").setDefaultValue(Boolean.TRUE)).build();
    public static final BoolKey KEY_SHOW_HELP_START_PAGE = BoolKey.builder("show_help_start", "Show help start page").build();
    public static final BoolKey KEY_EXTERNAL_HELP_BROWSER = BoolKey.builder("external_help_browser", "Browse help in external browser").build();
    public static final BoolKey KEY_FILE_UPDATE = ((BoolKey.Builder)BoolKey.builder("file_update", "Auto file update").setDefaultValue(Boolean.TRUE)).build();
    public static final BoolKey KEY_R_PROCESS = ((BoolKey.Builder)BoolKey.builder("r_process", "Run R in another process").setDefaultValue(Boolean.TRUE)).build();
    public static final BoolKey KEY_SHOW_PREVIEW_INSIDE_TAB = ((BoolKey.Builder)BoolKey.builder("preview_inside_tab", "Show preview inside tab").setDefaultValue(Boolean.TRUE)).build();
    public static final BoolKey KEY_CONFIRM_R_OBJECT_OVERWRITE = BoolKey.builder("confirm_robject_overwrite", "Confirm R object overwrite").build();
    private ChangeEventSupport changeEventSupport = new ChangeEventSupport(this);

    public DevelSettings() {
        this.registerAllKeys();
    }

    public void load() throws IOException {
        if (this.develSettingsFile.exists()) {
            this.loadFromYaml(this.develSettingsFile);
        }
    }

    public void store() throws IOException {
        this.storeToYaml(this.develSettingsFile);
    }

    @Override
    public WidgetNode getWidgetNode(ViewOptions viewOptions) {
        WidgetNode widgetNode = new TitledPanelWidgetNode("View", true).addElements(KEY_VIEW_DB, KEY_VIEW_OBJECT, KEY_VIEW_RUN_LOG_CLASSIC, KEY_VIEW_SESSION_LOG, KEY_VIEW_PREVIEW, KEY_PROJECT_VIEW, KEY_VIEW_RUN_LOG, KEY_VIEW_APP_LOG);
        WidgetNode widgetNode2 = new TitledPanelWidgetNode("Open", true).addElements(CUSTOM_OPEN_MODE, PanelWidgetNode.indent().addKeyLink(CUSTOM_OPEN_MODE, "EDITABLE_ON", true).addElements(KEY_KEEP_ROOT_FLOW, KEY_OPEN_BOX_IN_TOP, KEY_OPEN_BOX_IN_BOX, KEY_OPEN_NODE, KEY_OPEN_IN_NODE, KEY_TAB_TITLE), KEY_OPEN_IN_PREVIEW, KEY_ADDRESSBAR_OPEN);
        WidgetNode widgetNode3 = new TitledPanelWidgetNode("Help", true).addElements(KEY_SHOW_HELP_START_PAGE, KEY_EXTERNAL_HELP_BROWSER);
        WidgetNode widgetNode4 = new TitledPanelWidgetNode("Other", true).addElements(KEY_CONFIRM_R_OBJECT_OVERWRITE, KEY_SHOW_PREVIEW_INSIDE_TAB, KEY_R_PROCESS, KEY_FILE_UPDATE, KEY_ALPHABETICAL_ARGS_COMPLETION, KEY_TAB_COMPLETION, KEY_TOOLBAR_SELECTOR, UINODE_WINDOW, KEY_TAB_FLOAT, KEY_OUTPUT_PREVIEW_CODE);
        return new SplitPaneWidgetNode(false, 0.5f).add(PanelWidgetNode.noScroll().addElements(widgetNode, widgetNode2)).add(PanelWidgetNode.noScroll().addElements(widgetNode3, widgetNode4));
    }

    public ViewOpenType getViewOpenType(ChoiceKey choiceKey) {
        if (this.getValue(choiceKey).equals(OPEN_IN_TAB)) {
            return ViewOpenType.OPEN;
        }
        return ViewOpenType.OPEN_NEW;
    }

    public boolean isOpenWithPreview() {
        return !this.getValue(KEY_OPEN_IN_PREVIEW).equals(OPEN_NORMAL);
    }

    public boolean isAddressBarOpenOrMove() {
        return !this.getValue(KEY_ADDRESSBAR_OPEN).equals(OPEN_NORMAL);
    }

    public boolean isOutputPreviewCode() {
        return this.getValue(KEY_OUTPUT_PREVIEW_CODE);
    }

    @Override
    public void addEventHandler(ChangeEventHandler changeEventHandler) {
        this.changeEventSupport.addEventHandler(changeEventHandler);
    }

    @Override
    public void removeEventHandler(ChangeEventHandler changeEventHandler) {
        this.changeEventSupport.removeEventHandler(changeEventHandler);
    }

    public void dispatchEvent() {
        this.changeEventSupport.dispatchEvent();
    }
}

