/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.base;

import com.ef_prime.rflow.core.app.file.FileUtility;
import com.ef_prime.rflow.core.base.FileEditBackups;
import com.ef_prime.rflow.core.base.FileEditEventHandler;
import com.ef_prime.rflow.core.base.FileEditSupport;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;

public interface FileEdit {
    public String getFileEditName();

    public File getFile();

    default public boolean isDirty() {
        return this.getFileEditSupport().isDirty();
    }

    default public void setDirty(boolean bl) {
        this.getFileEditSupport().setDirty(bl);
    }

    default public boolean isDirtyForBackup() {
        return this.getFileEditSupport().isDirtyForBackup();
    }

    default public void setDirtyForBackup(boolean bl) {
        this.getFileEditSupport().setDirtyForBackup(bl);
    }

    default public boolean canBackup() {
        return true;
    }

    default public boolean noSave() {
        return false;
    }

    public FileEditSupport getFileEditSupport();

    default public String getFileEditID() {
        return this.getFileEditSupport().getFileEditID();
    }

    default public void protect(Object object) {
        this.getFileEditSupport().protect(object);
    }

    default public void unprotect(Object object) {
        this.getFileEditSupport().unprotect(object);
    }

    default public boolean isProtected() {
        return this.getFileEditSupport().isProtected();
    }

    default public Set<?> getProtectKeys() {
        return this.getFileEditSupport().getProtectKeys();
    }

    default public ReentrantLock getLock() {
        return this.getFileEditSupport().getLock();
    }

    default public void updateLastModified() {
        this.getFileEditSupport().updateLastModified();
    }

    default public boolean hasLastModifiedChanged() {
        return this.getFileEditSupport().hasLastModifiedChanged();
    }

    default public boolean isLoaded() {
        return this.getFileEditSupport().isLoaded();
    }

    public void clearEdit();

    default public void loadFileEdit() {
        this.getFileEditSupport().loadFileEdit();
    }

    default public void unloadFileEdit(boolean bl) {
        this.getFileEditSupport().unloadFileEdit(bl);
    }

    public void save(Path var1) throws IOException;

    public void saveBackup(Path var1) throws IOException;

    default public void addFileEditEventHandler(FileEditEventHandler fileEditEventHandler) {
        this.getFileEditSupport().addFileEditEventHandler(fileEditEventHandler);
    }

    default public void removeFileEditEventHandler(FileEditEventHandler fileEditEventHandler) {
        this.getFileEditSupport().removeFileEditEventHandler(fileEditEventHandler);
    }

    default public void dispatchFileEditEvent(int n) {
        this.getFileEditSupport().dispatchFileEditEvent(n);
    }

    default public void safeSave(Path path2, Path path3) throws IOException {
        FileUtility.safeSave(path2, path3, path -> this.save(path));
        this.setDirty(false);
        FileEditBackups.getInstance().removeBackup(this);
    }

    default public int getProtectCount() {
        return this.getProtectKeys().size();
    }

    default public boolean autoOpenView() {
        return false;
    }
}

