/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.base;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.core.app.file.FileUtility;
import com.ef_prime.rflow.core.base.FileEdit;
import com.ef_prime.rflow.core.base.RflowEventHandler;
import com.ef_prime.rflow.core.flow.FlowModel;
import com.ef_prime.rflow.core.util.YamlEx;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.yaml.snakeyaml.error.YAMLException;

public abstract class FileEditFilesManager
implements RflowEventHandler {
    private static final Logger LOGGER = Logger.getLogger(FileEditFilesManager.class.getName());
    private Map<String, String> map = new HashMap<String, String>(4);

    protected FileEditFilesManager() {
        Rflow.getInstance().addRflowEventHandler(this);
    }

    protected abstract Path getDirectory();

    private Path getMapFile() {
        return this.getDirectory().resolve("map.yaml");
    }

    public static String getFileID(FileEdit fileEdit) {
        File file = fileEdit.getFile();
        Object object = "";
        object = file != null ? (FileUtility.isChild(Rflow.project().getLocation(), file) ? "projecthome:" + Rflow.project().toProjectAbstractPath(file) : FilenameUtils.separatorsToUnix((String)file.getAbsolutePath())) : fileEdit.getFileEditID();
        return fileEdit.getClass().getName() + "::" + (String)object;
    }

    private synchronized void load() {
        this.map.clear();
        Path path = this.getMapFile();
        if (Files.notExists(path, new LinkOption[0])) {
            return;
        }
        try {
            Object object = new YamlEx().load(path.toFile());
            Map map = (Map)YamlEx.typeCheck(Map.class, object);
            this.map.putAll(map);
        }
        catch (IOException | YAMLException throwable) {
            LOGGER.log(Level.SEVERE, "Failed to read " + String.valueOf(path), throwable);
        }
    }

    public synchronized void unload() {
        this.map.clear();
    }

    public boolean hasBackup() {
        if (this.map.isEmpty()) {
            return false;
        }
        try {
            Path path = this.getMapFile();
            return Files.list(this.getDirectory()).filter(path2 -> {
                if (Files.isDirectory(path2, new LinkOption[0])) {
                    try {
                        return FlowModel.isRecoveryFile(path2);
                    }
                    catch (Exception exception) {
                        return false;
                    }
                }
                return !path.equals(path2);
            }).count() > 0L;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private static String getBackupPrefix(FileEdit fileEdit) {
        return fileEdit.getFile() == null ? "new_" + fileEdit.getFileEditID() : fileEdit.getFile().getName();
    }

    public synchronized void backup(FileEdit fileEdit) throws IOException {
        if (!fileEdit.isDirtyForBackup() || !fileEdit.canBackup()) {
            return;
        }
        Path path2 = this.getDirectory();
        Files.createDirectories(path2, new FileAttribute[0]);
        String string = FileEditFilesManager.getFileID(fileEdit);
        String string2 = this.map.get(string);
        if (string2 == null) {
            Path path3 = Files.createTempFile(path2, FileEditFilesManager.getBackupPrefix(fileEdit), ".bak", new FileAttribute[0]);
            string2 = path3.getFileName().toString();
            this.map.put(string, string2);
            try {
                FileUtility.safeSave(this.getMapFile(), this.getDirectory(), path -> this.saveMap(path));
            }
            catch (IOException iOException) {
                this.map.remove(string);
                throw iOException;
            }
        }
        FileUtility.safeSave(path2.resolve(string2), path2, path -> fileEdit.saveBackup(path));
        fileEdit.setDirtyForBackup(false);
    }

    private void saveMap(Path path) throws IOException {
        new YamlEx().dump(path.toFile(), this.map);
    }

    public synchronized void removeBackup(FileEdit fileEdit) {
        this.removeBackup(FileEditFilesManager.getFileID(fileEdit));
    }

    public synchronized void removeBackup(String string) {
        Path path2 = this.getDirectory();
        if (Files.notExists(path2, new LinkOption[0])) {
            this.map.clear();
            return;
        }
        String string2 = this.map.get(string);
        if (string2 == null) {
            return;
        }
        this.map.remove(string);
        try {
            FileUtility.safeSave(this.getMapFile(), this.getDirectory(), path -> this.saveMap(path));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            Files.deleteIfExists(path2.resolve(string2));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void clearBackupEntry(FileEdit fileEdit) {
        this.map.remove(FileEditFilesManager.getFileID(fileEdit));
    }

    public synchronized void cleanup(Set<String> set) {
        Path path2 = this.getDirectory();
        if (Files.notExists(path2, new LinkOption[0])) {
            this.map.clear();
            return;
        }
        List list = this.map.entrySet().stream().filter(entry -> !set.contains(entry.getKey())).collect(Collectors.toList());
        for (Object object : list) {
            this.map.remove(object.getKey());
            try {
                Files.deleteIfExists(path2.resolve((String)object.getValue()));
            }
            catch (IOException iOException) {}
        }
        try {
            FileUtility.safeSave(this.getMapFile(), this.getDirectory(), path -> this.saveMap(path));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        HashSet<String> hashSet = new HashSet<String>(this.map.values());
        try {
            Object object;
            object = this.getMapFile();
            Files.list(path2).filter(arg_0 -> FileEditFilesManager.lambda$cleanup$6(hashSet, (Path)object, arg_0)).forEach(path -> {
                try {
                    Files.deleteIfExists(path);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized Path getBackupFile(FileEdit fileEdit) {
        return this.getBackupFile(FileEditFilesManager.getFileID(fileEdit));
    }

    public synchronized Path getBackupFile(String string) {
        String string2 = this.map.get(string);
        if (string2 != null) {
            return this.getDirectory().resolve(string2);
        }
        return null;
    }

    public synchronized void updateBackupID(String string, FileEdit fileEdit) {
        String string2 = this.map.get(string);
        this.map.put(FileEditFilesManager.getFileID(fileEdit), string2);
        this.map.remove(string);
    }

    public synchronized Path createTempDirectory(FileEdit fileEdit) throws IOException {
        Path path2 = this.getDirectory();
        Files.createDirectories(path2, new FileAttribute[0]);
        String string = FileEditFilesManager.getFileID(fileEdit);
        String string2 = this.map.get(string);
        if (string2 == null) {
            Path path3 = Files.createTempDirectory(path2, FileEditFilesManager.getBackupPrefix(fileEdit), new FileAttribute[0]);
            string2 = path3.getFileName().toString();
            this.map.put(string, string2);
            try {
                FileUtility.safeSave(this.getMapFile(), this.getDirectory(), path -> this.saveMap(path));
            }
            catch (IOException iOException) {
                this.map.remove(string);
                throw iOException;
            }
        }
        return path2.resolve(string2);
    }

    public synchronized void removeTempDirectory(FileEdit fileEdit) {
        Path path2 = this.getDirectory();
        if (Files.notExists(path2, new LinkOption[0])) {
            this.map.clear();
            return;
        }
        String string = FileEditFilesManager.getFileID(fileEdit);
        String string2 = this.map.get(string);
        if (string2 == null) {
            return;
        }
        this.map.remove(string);
        try {
            FileUtility.safeSave(this.getMapFile(), this.getDirectory(), path -> this.saveMap(path));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            FileUtils.forceDelete((File)path2.resolve(string2).toFile());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void rflowWillShutdown() {
    }

    @Override
    public void rflowProjectDidStart() {
    }

    @Override
    public void rflowProjectDidStart(int n) {
        if (n == 0) {
            this.load();
        }
    }

    @Override
    public void rflowProjectWillEnd() {
        this.unload();
    }

    private static /* synthetic */ boolean lambda$cleanup$6(Set set, Path path, Path path2) {
        return !set.contains(path2.getFileName().toString()) && !path2.equals(path);
    }
}

