/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.base;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.core.base.FileEdit;
import com.ef_prime.rflow.core.base.FileEditBackups;
import com.ef_prime.rflow.core.base.FileEditEvent;
import com.ef_prime.rflow.core.base.FileEditEventHandler;
import com.ef_prime.rflow.core.base.FileEditFiles;
import com.ef_prime.rflow.core.base.Project;
import com.ef_prime.rflow.core.base.ProjectSession;
import com.ef_prime.rflow.core.base.RflowEventHandler;
import com.ef_prime.rflow.core.base.Settings;
import com.ef_prime.rflow.core.flow.FlowModel;
import com.ef_prime.rflow.ui.common.component.DelayedExecutor;
import com.ef_prime.rflow.ui.common.event.EventSupport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileEditManager
implements RflowEventHandler,
FileEditEventHandler {
    private static final Logger LOGGER = Logger.getLogger(FileEditManager.class.getName());
    private List<FileEdit> fileEdits = new ArrayList<FileEdit>();
    private ProjectSession projectSession;
    private DelayedExecutor saveProjectSessionExecutor;
    private EventSupport<FileEditEvent, FileEditEventHandler> eventSupport = new EventSupport();
    private Project currentProject;
    private static final FileEditManager instance = new FileEditManager();

    private FileEditManager() {
        Rflow.getInstance().addRflowEventHandler(this);
    }

    public static FileEditManager getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(FileEdit fileEdit, Object object) {
        if (fileEdit == null) {
            return;
        }
        ReentrantLock reentrantLock = fileEdit.getLock();
        reentrantLock.lock();
        try {
            fileEdit.protect(object);
            if (this.fileEdits.contains(fileEdit)) {
                return;
            }
            this.fileEdits.add(fileEdit);
            fileEdit.addFileEditEventHandler(this);
            fileEdit.loadFileEdit();
            fileEdit.dispatchFileEditEvent(0);
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unload(FileEdit fileEdit, Object object) {
        if (fileEdit == null || !this.fileEdits.contains(fileEdit)) {
            return;
        }
        ReentrantLock reentrantLock = fileEdit.getLock();
        reentrantLock.lock();
        try {
            if (object != null) {
                fileEdit.unprotect(object);
                if (fileEdit.isProtected()) {
                    return;
                }
            }
            this.fileEdits.remove(fileEdit);
            fileEdit.unloadFileEdit(Rflow.project().isNewProjectSaveMode());
            fileEdit.setDirty(false);
            fileEdit.dispatchFileEditEvent(1);
            fileEdit.removeFileEditEventHandler(this);
        }
        finally {
            reentrantLock.unlock();
        }
    }

    public List<FileEdit> getFileEdits() {
        return new ArrayList<FileEdit>(this.fileEdits);
    }

    public List<FlowModel> getFlowModels() {
        ArrayList<FlowModel> arrayList = new ArrayList<FlowModel>();
        for (FileEdit fileEdit : this.fileEdits) {
            if (!(fileEdit instanceof FlowModel)) continue;
            arrayList.add((FlowModel)fileEdit);
        }
        return arrayList;
    }

    public ProjectSession getProjectSession() {
        return this.projectSession;
    }

    public void setProjectSession(ProjectSession projectSession) {
        this.projectSession = projectSession;
        if (this.currentProject != null) {
            this.saveProjectSession(false);
        }
    }

    private void saveProjectSession(boolean bl) {
        if (this.saveProjectSessionExecutor == null) {
            this.saveProjectSessionExecutor = new DelayedExecutor(new SaveProjectSession(), 1000L);
        }
        this.saveProjectSessionExecutor.requestAction(bl);
    }

    public void loadProjectSession(Boolean bl) {
        if (this.currentProject == null) {
            return;
        }
        if (!(Rflow.settings().getValue(Settings.RESTORE_SESSION).booleanValue() || bl != null && bl.booleanValue() || FileEditBackups.getInstance().hasBackup())) {
            return;
        }
        try {
            this.projectSession = ProjectSession.load(this.currentProject);
            Rflow.mainView().loadProjectSession(this.projectSession, bl);
            FileEditFiles.getInstance().cleanup(this.projectSession);
        }
        catch (IOException iOException) {
            LOGGER.log(Level.WARNING, "Failed to load project session", iOException);
            this.projectSession = null;
        }
    }

    @Override
    public void rflowWillShutdown() {
    }

    @Override
    public void rflowProjectDidStart() {
        this.currentProject = Rflow.project();
    }

    @Override
    public void rflowProjectWillEnd() {
        this.saveProjectSession(true);
        this.currentProject = null;
        for (FileEdit fileEdit : this.getFileEdits()) {
            this.unload(fileEdit, null);
        }
    }

    public void addEventHandler(FileEditEventHandler fileEditEventHandler) {
        this.eventSupport.addEventHandler(fileEditEventHandler);
    }

    public void removeEventHandler(FileEditEventHandler fileEditEventHandler) {
        this.eventSupport.removeEventHandler(fileEditEventHandler);
    }

    public void dispatchEvent(FileEditEvent fileEditEvent) {
        this.eventSupport.dispatchEvent(fileEditEvent);
    }

    @Override
    public void fileEditStateChanged(FileEditEvent fileEditEvent) {
        this.dispatchEvent(fileEditEvent);
    }

    private class SaveProjectSession
    implements Runnable {
        private SaveProjectSession() {
        }

        @Override
        public void run() {
            try {
                if (FileEditManager.this.projectSession != null && FileEditManager.this.currentProject != null) {
                    FileEditManager.this.projectSession.save(FileEditManager.this.currentProject);
                }
            }
            catch (IOException iOException) {
                LOGGER.log(Level.WARNING, "Failed to save project session", iOException);
            }
        }
    }
}

