/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.base;

import com.ef_prime.rflow.core.base.FileEdit;
import com.ef_prime.rflow.core.base.FileEditEventHandler;
import com.ef_prime.rflow.core.base.FileEditManager;
import com.ef_prime.rflow.core.base.FileEditSupplier;
import java.util.ArrayList;
import java.util.List;

public class FileEditSupplierSupport
implements FileEditSupplier {
    private FileEditSupplier supplier;
    private List<Object> loadKeys = new ArrayList<Object>(4);
    private List<FileEditEventHandler> handlers = new ArrayList<FileEditEventHandler>(4);

    public FileEditSupplierSupport(FileEditSupplier fileEditSupplier) {
        this.supplier = fileEditSupplier;
    }

    @Override
    public FileEdit getFileEdit() {
        return this.supplier.getFileEdit();
    }

    @Override
    public void load(Object object) {
        this.loadKeys.add(object);
        FileEdit fileEdit = this.getFileEdit();
        if (fileEdit != null) {
            FileEditManager.getInstance().load(fileEdit, object);
        }
    }

    @Override
    public void unload(Object object) {
        this.loadKeys.remove(object);
        FileEdit fileEdit = this.getFileEdit();
        if (fileEdit != null) {
            FileEditManager.getInstance().unload(fileEdit, object);
        }
    }

    @Override
    public void addFileEditEventHandler(FileEditEventHandler fileEditEventHandler) {
        this.handlers.add(fileEditEventHandler);
        FileEdit fileEdit = this.getFileEdit();
        if (fileEdit != null) {
            fileEdit.addFileEditEventHandler(fileEditEventHandler);
        }
    }

    @Override
    public void removeFileEditEventHandler(FileEditEventHandler fileEditEventHandler) {
        this.handlers.remove(fileEditEventHandler);
        FileEdit fileEdit = this.getFileEdit();
        if (fileEdit != null) {
            fileEdit.removeFileEditEventHandler(fileEditEventHandler);
        }
    }

    public void fileEditChanged(FileEdit fileEdit, FileEdit fileEdit2) {
        for (FileEditEventHandler object : this.handlers) {
            if (fileEdit != null) {
                fileEdit.removeFileEditEventHandler(object);
            }
            if (fileEdit2 == null) continue;
            fileEdit2.addFileEditEventHandler(object);
        }
        for (Object object : this.loadKeys) {
            if (fileEdit != null) {
                FileEditManager.getInstance().unload(fileEdit, object);
            }
            if (fileEdit2 == null) continue;
            FileEditManager.getInstance().load(fileEdit2, object);
        }
    }
}

