/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.base;

import com.ef_prime.rflow.core.base.FileEdit;
import com.ef_prime.rflow.core.base.FileEditEvent;
import com.ef_prime.rflow.core.base.FileEditEventHandler;
import com.ef_prime.rflow.ui.common.event.EventSupport;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;

public class FileEditSupport
implements FileEdit {
    private static Set<String> idSet = new HashSet<String>();
    private FileEdit source;
    private boolean loaded;
    private boolean dirty;
    private boolean dirtyForBackup;
    private Set<Object> protects;
    private EventSupport<FileEditEvent, FileEditEventHandler> eventSupport = new EventSupport();
    private ReentrantLock lock = new ReentrantLock();
    private long lastModified;
    private String id;

    public FileEditSupport(FileEdit fileEdit) {
        this.source = fileEdit;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void setDirty(boolean bl) {
        this.setDirtyForBackup(bl);
        if (this.dirty != bl) {
            this.dirty = bl;
            this.dispatchFileEditEvent(2);
        }
    }

    @Override
    public boolean isDirtyForBackup() {
        return this.dirtyForBackup;
    }

    @Override
    public void setDirtyForBackup(boolean bl) {
        this.dirtyForBackup = bl;
    }

    @Override
    public void addFileEditEventHandler(FileEditEventHandler fileEditEventHandler) {
        this.eventSupport.addEventHandler(fileEditEventHandler);
    }

    @Override
    public void removeFileEditEventHandler(FileEditEventHandler fileEditEventHandler) {
        this.eventSupport.removeEventHandler(fileEditEventHandler);
    }

    @Override
    public void dispatchFileEditEvent(int n) {
        this.eventSupport.dispatchEvent(new FileEditEvent(n, this.source));
    }

    @Override
    public FileEditSupport getFileEditSupport() {
        return this;
    }

    @Override
    public String getFileEditID() {
        if (this.id == null) {
            int n;
            int n2 = n = System.identityHashCode(this.source);
            for (int i = 0; i < Integer.MAX_VALUE; ++i) {
                String string = Integer.toHexString(n2);
                if (idSet.add(string)) {
                    this.id = string;
                    break;
                }
                ++n2;
            }
        }
        return this.id;
    }

    @Override
    public void protect(Object object) {
        if (this.protects == null) {
            this.protects = new HashSet<Object>(2);
        }
        this.protects.add(object);
    }

    @Override
    public void unprotect(Object object) {
        if (this.protects != null) {
            this.protects.remove(object);
        }
    }

    @Override
    public Set<?> getProtectKeys() {
        return this.protects == null ? new HashSet(0) : this.protects;
    }

    @Override
    public ReentrantLock getLock() {
        return this.lock;
    }

    @Override
    public boolean isProtected() {
        return this.protects != null && this.protects.size() > 0;
    }

    @Override
    public boolean isLoaded() {
        return this.loaded;
    }

    @Override
    public void loadFileEdit() {
        this.loaded = true;
    }

    @Override
    public void unloadFileEdit(boolean bl) {
        this.loaded = false;
        this.protects = null;
    }

    @Override
    public String getFileEditName() {
        throw new UnsupportedOperationException();
    }

    @Override
    public File getFile() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void save(Path path) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void saveBackup(Path path) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clearEdit() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateLastModified() {
        File file = this.source.getFile();
        this.lastModified = file == null ? 0L : file.lastModified();
    }

    @Override
    public boolean hasLastModifiedChanged() {
        if (this.lastModified <= 0L) {
            return false;
        }
        File file = this.source.getFile();
        if (file == null) {
            return false;
        }
        long l = file.lastModified();
        return l > 0L && this.lastModified != l;
    }
}

