/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.base;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.core.app.base.Apps;
import com.ef_prime.rflow.core.app.file.FileUtility;
import com.ef_prime.rflow.core.base.DevelSettings;
import com.ef_prime.rflow.core.base.Project;
import com.ef_prime.rflow.core.base.RflowEventHandler;
import com.ef_prime.rflow.core.base.Settings;
import com.ef_prime.rflow.core.base.WorkingDirectory;
import com.ef_prime.rflow.core.common.util.ThreadUtility;
import com.ef_prime.rflow.core.common.xml.XmlContext;
import com.ef_prime.rflow.core.common.xml.XmlUtility;
import com.ef_prime.rflow.core.util.Platform;
import com.ef_prime.rflow.core.util.YamlEx;
import com.ef_prime.rflow.ui.app.file.FileTransferable;
import com.ef_prime.rflow.ui.common.event.ChangeEventHandler;
import com.ef_prime.rflow.ui.common.event.ChangeEventSupport;
import com.ef_prime.rflow.ui.common.item.Item;
import com.ef_prime.rflow.ui.common.item.ItemEvent;
import com.ef_prime.rflow.ui.common.item.ItemEventHandler;
import com.ef_prime.rflow.ui.common.item.ItemManager;
import com.ef_prime.rflow.ui.common.item.ItemManagerSupport;
import com.ef_prime.rflow.ui.common.item.ItemManagers;
import com.ef_prime.rflow.ui.view.FileNode;
import com.ef_prime.rflow.ui.view.GroupFileNode;
import com.ef_prime.rflow.ui.view.ProjectHomeFileNode;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.tree.DefaultTreeModel;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.w3c.dom.Element;

public class FileManager
implements RflowEventHandler,
ItemManager,
PropertyChangeListener {
    private static final Logger LOGGER = Logger.getLogger(FileManager.class.getName());
    private static final String CONFIG_FILE = "file.xml";
    public static final String CONFIG_YAML_FILE = "file.yaml";
    private Project project;
    private FileWatcher fileWatcher;
    private DefaultTreeModel treeModel;
    private ProjectHomeFileNode projectHomeFileNode;
    private ChangeEventSupport changeEventSupport = new ChangeEventSupport(this);
    private ItemManagerSupport itemManagerSupport = new ItemManagerSupport(this);
    private static final FileManager instance = new FileManager();

    protected FileManager() {
        this.treeModel = new DefaultTreeModel(new GroupFileNode(""), true);
        this.installEventHandlers();
    }

    public static FileManager getInstance() {
        return instance;
    }

    protected void installEventHandlers() {
        Rflow.getInstance().addRflowEventHandler(this);
        WorkingDirectory.addPropertyChangeListener(this);
        ItemManagers.getInstance().add(Apps.FILE.getId(), this);
    }

    public static String fileToString(File file) {
        if (file == null) {
            return "";
        }
        file = WorkingDirectory.toAbsolutePath(file);
        return FilenameUtils.separatorsToUnix((String)file.getAbsolutePath());
    }

    public static String pathToString(Path path) {
        if (path == null) {
            return "";
        }
        path = WorkingDirectory.toAbsolutePath(path);
        return FilenameUtils.separatorsToUnix((String)path.toString());
    }

    public static File stringToFile(String string) {
        if (string == null) {
            return null;
        }
        return new File(string);
    }

    public void removeFile(File file) throws IOException {
        if (file.exists()) {
            FileUtils.forceDelete((File)file);
            this.dispatchItemEvent(6, FileManager.fileToString(file));
        }
    }

    public DefaultTreeModel getTreeModel() {
        return this.treeModel;
    }

    public FileNode getRoot() {
        return (FileNode)this.treeModel.getRoot();
    }

    public FileNode getProjectHomeFileNode() {
        return this.projectHomeFileNode;
    }

    public void add(FileNode fileNode) {
        this.add(fileNode, this.getRoot().getChildCount());
    }

    public void add(FileNode fileNode, int n) {
        this.treeModel.insertNodeInto(fileNode, this.getRoot(), n);
        this.autoStore();
    }

    public FileNode getSameLink(FileNode fileNode) {
        FileNode fileNode2 = this.getRoot();
        for (int i = 0; i < fileNode2.getChildCount(); ++i) {
            FileNode fileNode3 = (FileNode)fileNode2.getChildAt(i);
            if (!fileNode3.equals(fileNode)) continue;
            return fileNode3;
        }
        return null;
    }

    public void remove(Collection<FileNode> collection) {
        for (FileNode fileNode : collection) {
            if (fileNode.isFixedNode()) continue;
            this.treeModel.removeNodeFromParent(fileNode);
        }
        this.autoStore();
    }

    public void rename(FileNode fileNode, String string) {
        if (fileNode.isFixedNode()) {
            return;
        }
        fileNode.setName(string);
        this.treeModel.nodeChanged(fileNode);
        this.autoStore();
    }

    public void moveUp(List<FileNode> list) {
        this.move(list, true);
    }

    public void moveDown(List<FileNode> list) {
        this.move(list, false);
    }

    private void move(List<FileNode> list, boolean bl) {
        FileNode fileNode = this.getRoot();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (FileNode fileNode2 : list) {
            int n = fileNode.getIndex(fileNode2);
            if (bl && n == 0) {
                return;
            }
            if (!bl && n == fileNode.getChildCount() - 1) {
                return;
            }
            if (n < 0) continue;
            arrayList.add(n);
        }
        Collections.sort(arrayList);
        if (bl) {
            for (int i = 0; i < arrayList.size(); ++i) {
                int n = (Integer)arrayList.get(i);
                FileNode fileNode3 = (FileNode)fileNode.getChildAt(n);
                this.treeModel.removeNodeFromParent(fileNode3);
                this.treeModel.insertNodeInto(fileNode3, fileNode, n - 1);
            }
        } else {
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                int n = (Integer)arrayList.get(i);
                FileNode fileNode4 = (FileNode)fileNode.getChildAt(n);
                this.treeModel.removeNodeFromParent(fileNode4);
                this.treeModel.insertNodeInto(fileNode4, fileNode, n + 1);
            }
        }
        this.autoStore();
    }

    public List<FileNode> getNodes(File file) {
        ArrayList<FileNode> arrayList = new ArrayList<FileNode>();
        this.getNodes(arrayList, this.getRoot(), file);
        return arrayList;
    }

    private void getNodes(List<FileNode> list, FileNode fileNode, File file) {
        File file2;
        if (fileNode.isFile() && !FileUtility.isChild(file2 = fileNode.getFile(), file)) {
            return;
        }
        for (int i = 0; i < fileNode.getChildCount(); ++i) {
            FileNode fileNode2 = (FileNode)fileNode.getChildAt(i);
            File file3 = fileNode2.getFile();
            if (file3.equals(file)) {
                list.add(fileNode2);
                if (fileNode.isFile()) {
                    return;
                }
            }
            this.getNodes(list, fileNode2, file);
        }
    }

    private File getConfigFile() {
        return new File(this.project.getConfDir(), CONFIG_FILE);
    }

    private File getYamlConfigFile() {
        return new File(this.project.getConfDir(), CONFIG_YAML_FILE);
    }

    public synchronized void load() {
        Object object;
        if (this.project == null) {
            return;
        }
        GroupFileNode groupFileNode = new GroupFileNode("");
        if (this.getYamlConfigFile().exists()) {
            try {
                new YamlEx().loadYamlable(this.getYamlConfigFile(), groupFileNode);
            }
            catch (Exception exception) {
                LOGGER.log(Level.SEVERE, exception.getMessage(), exception);
            }
        } else if (this.getConfigFile().exists()) {
            try {
                object = XmlUtility.readXml(this.getConfigFile());
                Element element = XmlUtility.getChild("group", object.getDocumentElement());
                groupFileNode.loadElement(element, new XmlContext());
            }
            catch (Exception exception) {
                LOGGER.log(Level.SEVERE, exception.getMessage(), exception);
            }
        }
        object = Rflow.settings().getValue(Settings.SHOW_HIDDEN_FILES);
        this.projectHomeFileNode = new ProjectHomeFileNode(this.project.getLocation(), (Boolean)object);
        groupFileNode.insert(this.projectHomeFileNode, 0);
        this.treeModel.setRoot(groupFileNode);
        if (this.isAutoFileUpdateEnabled()) {
            if (this.fileWatcher != null && this.fileWatcher.isAlive()) {
                this.fileWatcher.interrupt();
            }
            this.fileWatcher = new FileWatcher();
            this.fileWatcher.start();
        }
        this.changeEventSupport.dispatchEvent();
    }

    private boolean isAutoFileUpdateEnabled() {
        return Rflow.develSettings().getValue(DevelSettings.KEY_FILE_UPDATE);
    }

    protected void autoStore() {
        this.store();
    }

    public synchronized void store() {
        try {
            this.storeYaml(this.getYamlConfigFile());
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, exception.getMessage(), exception);
        }
    }

    public void storeYaml(File file) throws IOException {
        new YamlEx().dump(file, this.getRoot());
    }

    public void addLoadEventHandler(ChangeEventHandler changeEventHandler) {
        this.changeEventSupport.addEventHandler(changeEventHandler);
    }

    public void removeLoadEventHandler(ChangeEventHandler changeEventHandler) {
        this.changeEventSupport.removeEventHandler(changeEventHandler);
    }

    @Override
    public void rflowWillShutdown() {
    }

    @Override
    public void rflowProjectDidStart() {
        this.project = Rflow.project();
        this.load();
    }

    @Override
    public void rflowProjectWillEnd() {
        this.project = null;
        if (this.fileWatcher != null && this.fileWatcher.isAlive()) {
            this.fileWatcher.interrupt();
        }
        this.fileWatcher = null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("WORKING_DIRECTORY".equals(propertyChangeEvent.getPropertyName())) {
            if (this.project == null) {
                return;
            }
            List<FileNode> list = this.getNodes((File)propertyChangeEvent.getOldValue());
            list.addAll(this.getNodes((File)propertyChangeEvent.getNewValue()));
            for (FileNode fileNode : list) {
                this.treeModel.nodeChanged(fileNode);
            }
        }
    }

    @Override
    public Item getItem(String string) {
        File file = FileManager.stringToFile(string);
        if (file == null) {
            return null;
        }
        return new FileTransferable(Lists.newArrayList((Object[])new File[]{file}));
    }

    @Override
    public void addNewItem(String string) {
        this.itemManagerSupport.addNewItem(string);
    }

    public void addNewItem(File file) {
        if (file == null) {
            return;
        }
        this.addNewItem(FileManager.fileToString(file));
    }

    @Override
    public void removeNewItem(String string) {
        this.itemManagerSupport.removeNewItem(string);
    }

    public void removeNewItem(File file) {
        if (file == null) {
            return;
        }
        this.removeNewItem(FileManager.fileToString(file));
    }

    @Override
    public void clearNewItems() {
        this.itemManagerSupport.clearNewItems();
    }

    @Override
    public boolean isNewItem(String string) {
        return this.itemManagerSupport.isNewItem(string);
    }

    public boolean isNewItem(File file) {
        if (file == null) {
            return false;
        }
        return this.isNewItem(FileManager.fileToString(file));
    }

    @Override
    public void addItemEventHandler(ItemEventHandler itemEventHandler) {
        this.itemManagerSupport.addItemEventHandler(itemEventHandler);
    }

    @Override
    public void removeItemEventHandler(ItemEventHandler itemEventHandler) {
        this.itemManagerSupport.removeItemEventHandler(itemEventHandler);
    }

    @Override
    public void dispatchItemEvent(ItemEvent itemEvent) {
        this.itemManagerSupport.dispatchItemEvent(itemEvent);
    }

    public void watchDirectory(Path path) {
        if (this.fileWatcher == null || !this.fileWatcher.isAlive()) {
            return;
        }
        try {
            this.fileWatcher.add(path);
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to watch directory.", exception);
        }
    }

    public void ignorePath(Path path, boolean bl) {
        if (this.fileWatcher == null || !this.fileWatcher.isAlive()) {
            return;
        }
        this.fileWatcher.ignore(path, bl);
    }

    public boolean isRecursiveFileWatch() {
        if (this.fileWatcher == null || !this.fileWatcher.isAlive()) {
            return false;
        }
        return this.fileWatcher.isRecursive();
    }

    private class FileWatcher
    extends Thread {
        private WatchService watchService;
        private BiMap<WatchKey, Path> keyToPath;
        private ScheduledExecutorService executorService;
        private Map<String, Future<?>> futures;
        private Set<Path> ignoreSet;
        private WatchEvent.Modifier modifier;

        public FileWatcher() {
            super("File Watcher");
            this.keyToPath = HashBiMap.create();
            this.executorService = Executors.newScheduledThreadPool(0, (ThreadFactory)ThreadUtility.threadFactory("FileWatcher-EntryModify-%d", true));
            this.futures = new HashMap();
            this.ignoreSet = new HashSet<Path>();
            this.setDaemon(true);
            if (Platform.isWindowsFamily()) {
                try {
                    this.modifier = (WatchEvent.Modifier)Class.forName("com.sun.nio.file.ExtendedWatchEventModifier").getField("FILE_TREE").get(null);
                }
                catch (Throwable throwable) {
                    LOGGER.info("Recursive file watch option is not available");
                }
            }
        }

        public boolean isRecursive() {
            return this.modifier != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(Path path) throws Exception {
            Object object;
            if (!Files.isDirectory(path, new LinkOption[0])) {
                return;
            }
            Path path2 = path.toAbsolutePath();
            if (this.keyToPath.inverse().get((Object)path2) != null) {
                return;
            }
            if (this.isRecursive()) {
                object = this.keyToPath;
                synchronized (object) {
                    for (Path path3 : this.keyToPath.values()) {
                        if (!path2.startsWith(path3)) continue;
                        return;
                    }
                }
            }
            object = new FutureTask<Object>(() -> {
                try {
                    WatchEvent.Kind[] kindArray = new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY};
                    WatchKey watchKey = this.modifier != null ? path2.register(this.watchService, kindArray, this.modifier) : path2.register(this.watchService, kindArray);
                    BiMap<WatchKey, Path> biMap = this.keyToPath;
                    synchronized (biMap) {
                        this.keyToPath.put((Object)watchKey, (Object)path2);
                    }
                }
                catch (Exception exception) {
                    LOGGER.log(Level.WARNING, "Failed to watch directory.", exception);
                }
            }, null);
            Runnable runnable = () -> {
                ThreadUtility.execute(object);
                try {
                    object.get(60L, TimeUnit.SECONDS);
                }
                catch (Exception exception) {
                    object.cancel(true);
                    LOGGER.log(Level.WARNING, "Failed to watch directory. Operation canceled.", exception);
                }
            };
            ThreadUtility.execute(runnable);
        }

        public void ignore(Path path, boolean bl) {
            if (bl) {
                this.ignoreSet.add(path);
            } else {
                this.executorService.schedule(() -> this.ignoreSet.remove(path), 500L, TimeUnit.MILLISECONDS);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                WatchService watchService = FileSystems.getDefault().newWatchService();
                try {
                    Object object;
                    this.watchService = watchService;
                    Object object2 = FileManager.this.getRoot().children();
                    while (object2.hasMoreElements()) {
                        object = (FileNode)object2.nextElement();
                        if (!object.isFile()) continue;
                        try {
                            this.add(object.getFile().toPath());
                        }
                        catch (Exception exception) {
                            LOGGER.log(Level.WARNING, "Failed to watch directory.", exception);
                        }
                    }
                    do {
                        Object object3;
                        WatchEvent.Kind<?> kind;
                        object2 = watchService.take();
                        try {
                            object = this.futures.entrySet().iterator();
                            while (object.hasNext()) {
                                Future future = (Future)((Map.Entry)object.next()).getValue();
                                if (!future.isDone()) continue;
                                object.remove();
                            }
                        }
                        catch (Exception exception) {
                            LOGGER.log(Level.WARNING, "Failed to clear futures.", exception);
                        }
                        for (WatchEvent<?> watchEvent : object2.pollEvents()) {
                            Path path;
                            kind = watchEvent.kind();
                            if (kind == StandardWatchEventKinds.OVERFLOW || (object3 = (Path)watchEvent.context()) == null || (path = (Path)this.keyToPath.get(object2)) == null) continue;
                            try {
                                Path path2 = path.resolve((Path)object3);
                                int n = 0;
                                if (kind == StandardWatchEventKinds.ENTRY_CREATE) {
                                    n = 2;
                                } else if (kind == StandardWatchEventKinds.ENTRY_DELETE) {
                                    n = 6;
                                }
                                if (this.ignoreSet.contains(path2) || this.ignoreSet.contains(path)) continue;
                                if (n == 0) {
                                    String string = FileManager.fileToString(path2.toFile());
                                    Future<?> future = this.futures.get(string);
                                    if (future != null && !future.isDone()) {
                                        future.cancel(false);
                                    }
                                    ScheduledFuture<?> scheduledFuture = this.executorService.schedule(() -> FileManager.this.dispatchItemEvent(new ItemEvent(FileManager.this, 0, string)), 1L, TimeUnit.SECONDS);
                                    this.futures.put(string, scheduledFuture);
                                    continue;
                                }
                                FileManager.this.dispatchItemEvent(new ItemEvent(FileManager.this, n, FileManager.fileToString(path2.toFile())));
                            }
                            catch (Exception exception) {
                                LOGGER.log(Level.WARNING, "Failed to dispatch ItemEvent.", exception);
                            }
                        }
                        boolean bl = object2.reset();
                        if (!bl) {
                            BiMap<WatchKey, Path> biMap = this.keyToPath;
                            synchronized (biMap) {
                                this.keyToPath.remove(object2);
                            }
                        }
                        BiMap<WatchKey, Path> biMap = this.keyToPath;
                        synchronized (biMap) {
                            kind = this.keyToPath.entrySet().iterator();
                            while (kind.hasNext()) {
                                object3 = (Map.Entry)kind.next();
                                if (!Files.notExists((Path)object3.getValue(), LinkOption.NOFOLLOW_LINKS)) continue;
                                ((WatchKey)object3.getKey()).cancel();
                                kind.remove();
                            }
                        }
                    } while (!Thread.currentThread().isInterrupted());
                    throw new InterruptedException();
                }
                catch (Throwable throwable) {
                    if (watchService != null) {
                        try {
                            watchService.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {
                LOGGER.log(Level.SEVERE, "Failed to watch files.", iOException);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.futures.clear();
            this.keyToPath.clear();
            this.executorService.shutdown();
        }
    }
}

