/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.base;

import com.ef_prime.rflow.core.base.UserFolder;
import com.ef_prime.rflow.core.common.util.Utility;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.swing.ImageIcon;
import org.apache.commons.io.FilenameUtils;

public class FileResource {
    @Deprecated
    private static File functionFile;
    @Deprecated
    public static final File USER_FUNCTION_FILE;
    private static File sampleFolder;
    public static final String DESKTOP_16 = "img/desktop_16.png";
    public static final String DOC_16 = "img/doc_16.png";
    public static final String SPLASH = "img/splash.png";
    public static final String ACTION_STOP = "img/action/stop.png";
    public static final String FLAG_IMAGE = "img/node/flag.png";
    public static final String BOX = "img/node/box.png";
    public static final String ERROR = "img/error_16.png";
    public static final String WARNING = "img/warning_16.png";
    private static Map<String, ImageIcon> map;

    public static ImageIcon getIcon(String string) {
        ImageIcon imageIcon = map.get(string);
        if (imageIcon == null) {
            imageIcon = new ImageIcon(Utility.getPathStr(string));
            map.put(string, imageIcon);
        }
        return imageIcon;
    }

    public static ImageIcon getIcon(String string, int n) {
        String string2 = string + ":size:" + n;
        ImageIcon imageIcon = map.get(string2);
        if (imageIcon == null) {
            ImageIcon imageIcon2 = FileResource.getIcon(string);
            imageIcon = new ImageIcon(imageIcon2.getImage().getScaledInstance(16, 16, 4));
            map.put(string2, imageIcon);
        }
        return imageIcon;
    }

    public static Path getLicense() {
        return FileResource.getLocaleFile(Utility.getPath("license.txt"));
    }

    public static Path getStarterGuide() {
        return FileResource.getLocaleFile(Utility.getPath("help/doc/readme.html"));
    }

    public static Path getReleaseNotes() {
        return FileResource.getLocaleFile(Utility.getPath("help/doc/releasenote.html"));
    }

    private static Path getLocaleFile(Path path) {
        String string = path.getFileName().toString();
        String string2 = FilenameUtils.removeExtension((String)string);
        String string3 = FilenameUtils.getExtension((String)string);
        String string4 = Locale.getDefault().getLanguage();
        Path path2 = path.getParent().resolve(string2 + "_" + string4 + "." + string3);
        return Files.exists(path2, new LinkOption[0]) ? path2 : path;
    }

    public static File getFunctionFile() {
        if (functionFile == null) {
            functionFile = FileResource.getLocaleFile(Utility.getPath("function.xml")).toFile();
        }
        return functionFile;
    }

    public static File getSampleFolder() {
        if (sampleFolder == null) {
            File file = new File(Utility.getPathStr("help/tutorial"));
            String string = "default";
            File[] fileArray = file.listFiles();
            if (fileArray != null) {
                String string2 = Locale.getDefault().getLanguage();
                for (File file2 : fileArray) {
                    if (!file2.isDirectory() || !file2.getName().equals(string2)) continue;
                    string = file2.getName();
                    break;
                }
            }
            sampleFolder = new File(Utility.getPathStr("help/tutorial/" + string));
        }
        return sampleFolder;
    }

    static {
        USER_FUNCTION_FILE = UserFolder.getUserDirFile("function.xml");
        map = new HashMap<String, ImageIcon>(10);
    }
}

