/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.base;

import com.ef_prime.rflow.core.base.OldSettings;
import com.ef_prime.rflow.core.base.UserFolder;
import com.ef_prime.rflow.core.common.keyvalue.StrKey;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.util.PropertiesUtility;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LocaleSettings
extends ValueMap {
    private static final Logger LOGGER = Logger.getLogger(LocaleSettings.class.getName());
    public static final String LANG_SYSTEM = "system";
    public static final StrKey LANGUAGE = ((StrKey.Builder)StrKey.builder("LANGUAGE", "").setDefaultValue("system")).build();

    public LocaleSettings() {
        this.registerKeys(LANGUAGE);
    }

    public static void initLocale() {
        LocaleSettings localeSettings = new LocaleSettings();
        try {
            localeSettings.load();
            Locale.setDefault(localeSettings.getLocale());
        }
        catch (IOException iOException) {
            LOGGER.log(Level.SEVERE, "Failed to read locale from settings file.", iOException);
        }
        Messages.prepareResourceBundle();
    }

    public Locale getLocale() {
        String string = this.getValue(LANGUAGE);
        if (string.equals(LANG_SYSTEM)) {
            return Locale.getDefault();
        }
        return new Locale(string);
    }

    public void load() throws IOException {
        File file;
        File file2 = UserFolder.getUserSettings();
        if (file2.exists()) {
            this.loadFromYaml(file2);
        } else if (file2.equals(UserFolder.getDefaultUserSettings()) && (file = UserFolder.getOldUserSettings()).exists()) {
            OldSettings oldSettings = OldSettings.defaultSetting();
            PropertiesUtility.load(oldSettings, file);
            this.putValue(LANGUAGE, (String)oldSettings.getProperty(OldSettings.Key.LANGUAGE));
        }
    }
}

