/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.base;

import com.ef_prime.rflow.core.base.LogManager;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class LogFileFormatter
extends Formatter {
    @Override
    public String format(LogRecord logRecord) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = "\t";
        String string2 = LogManager.DATEFORMAT.format(new Date(logRecord.getMillis()));
        stringBuilder.append(string2);
        stringBuilder.append(string);
        stringBuilder.append(logRecord.getLevel().getName());
        stringBuilder.append(string);
        if (logRecord.getSourceClassName() != null) {
            stringBuilder.append(logRecord.getSourceClassName());
        } else {
            stringBuilder.append(logRecord.getLoggerName());
        }
        if (logRecord.getSourceMethodName() != null) {
            stringBuilder.append(" ");
            stringBuilder.append(logRecord.getSourceMethodName());
        }
        stringBuilder.append(string);
        stringBuilder.append(this.replaceChar(this.formatMessage(logRecord)));
        stringBuilder.append(string);
        if (logRecord.getThrown() != null) {
            try {
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                logRecord.getThrown().printStackTrace(printWriter);
                printWriter.close();
                stringBuilder.append(this.replaceChar(stringWriter.toString()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }

    private String replaceChar(String string) {
        if (string == null) {
            return "";
        }
        string = string.replaceAll("\\\\", "\\\\\\\\");
        string = string.replaceAll("\\t", "\\\\t");
        string = string.replaceAll("\\r", "");
        string = string.replaceAll("\\n", "\\\\n");
        return string;
    }
}

