/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.base;

import com.ef_prime.rflow.core.base.LogManager;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class LogFormatter
extends Formatter {
    @Override
    public String format(LogRecord logRecord) {
        StringBuilder stringBuilder = new StringBuilder(64);
        String string = LogManager.DATEFORMAT.format(new Date(logRecord.getMillis()));
        stringBuilder.append(string);
        stringBuilder.append('\n');
        stringBuilder.append(logRecord.getLevel().getName());
        stringBuilder.append(": ");
        int n = stringBuilder.length();
        if (logRecord.getSourceClassName() != null) {
            stringBuilder.append(logRecord.getSourceClassName());
        } else {
            stringBuilder.append(logRecord.getLoggerName());
        }
        if (logRecord.getSourceMethodName() != null) {
            stringBuilder.append(" ");
            stringBuilder.append(logRecord.getSourceMethodName());
        }
        if (n != stringBuilder.length()) {
            stringBuilder.append(" ");
        }
        stringBuilder.append(this.formatMessage(logRecord));
        stringBuilder.append('\n');
        if (logRecord.getThrown() != null) {
            try {
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                logRecord.getThrown().printStackTrace(printWriter);
                printWriter.close();
                stringBuilder.append(stringWriter.toString());
                stringBuilder.append("\n");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return stringBuilder.toString();
    }
}

