/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.base;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.core.base.LogFileFormatter;
import com.ef_prime.rflow.core.base.RflowVersion;
import com.ef_prime.rflow.core.base.UserFolder;
import com.ef_prime.rflow.ui.base.RflowActionLogger;
import com.ef_prime.rflow.ui.common.component.LoggableAction;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.lang.management.ManagementFactory;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FilenameUtils;

public class LogManager {
    private static final Logger LOGGER = Logger.getLogger(LogManager.class.getName());
    private static final LogManager INSTANCE = new LogManager();
    public static final DateFormat DATEFORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    public static final DateFormat FILE_DATE_FORMAT = new SimpleDateFormat("yyyyMMdd_HHmmss_SSS");
    public static final String LOG_SUFFIX = ".log";
    public static final String R_PROCESS_LOG_SUFFIX = "_r.log";
    private Logger rootLogger;
    private File logFile;
    private File rProcessLogFile;

    public static LogManager getInstance() {
        return INSTANCE;
    }

    public Logger getRootLogger() {
        return this.rootLogger;
    }

    public File getLogFile() {
        return this.logFile;
    }

    public File getRProcessLogFile() {
        return this.rProcessLogFile;
    }

    public void init() {
        Object object;
        this.rootLogger = Logger.getLogger("com.ef_prime");
        this.rootLogger.setUseParentHandlers(false);
        this.rootLogger.setLevel(Level.ALL);
        if ("true".equals(System.getProperty("err2Console"))) {
            object = new ConsoleHandler();
            ((Handler)object).setLevel(Level.CONFIG);
            this.rootLogger.addHandler((Handler)object);
        }
        object = UserFolder.getLogDir();
        ((File)object).mkdirs();
        if (((File)object).exists()) {
            File file = null;
            String string = FILE_DATE_FORMAT.format(new Date());
            file = new File((File)object, string + LOG_SUFFIX);
            int n = 0;
            while (file.exists()) {
                file = new File((File)object, string + "_" + ++n + LOG_SUFFIX);
                if (n <= 1000) continue;
                file = null;
                break;
            }
            if (file != null) {
                this.logFile = file;
                this.rProcessLogFile = new File(file.getParentFile(), FilenameUtils.removeExtension((String)file.getName()) + R_PROCESS_LOG_SUFFIX);
                try {
                    String string2 = "UTF-8";
                    this.logSettings(file, string2);
                    FileHandler fileHandler = new FileHandler(file.getPath(), 0x200000, 1, true);
                    fileHandler.setEncoding(string2);
                    fileHandler.setLevel(Level.FINE);
                    fileHandler.setFormatter(new LogFileFormatter());
                    this.rootLogger.addHandler(fileHandler);
                }
                catch (IOException iOException) {
                    LOGGER.log(Level.SEVERE, "Failed to set log file handler.", iOException);
                }
            }
        }
        LoggableAction.setLogger(RflowActionLogger.getInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logSettings(File file, String string) throws IOException {
        try (BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), string));){
            bufferedWriter.write(this.formatSettingLog("version", RflowVersion.get().toString()));
            bufferedWriter.write(this.formatSettingLog("locale", Rflow.SYSTEM_LOCALE.toString()));
            String[] stringArray = new String[]{"java.vendor", "java.version", "os.arch", "os.name", "os.version"};
            for (String string2 : stringArray) {
                String string3 = System.getProperty(string2, "");
                bufferedWriter.write(this.formatSettingLog(string2, string3));
            }
            bufferedWriter.write("#VM arguments:\n");
            for (String string4 : ManagementFactory.getRuntimeMXBean().getInputArguments()) {
                bufferedWriter.write("# ");
                bufferedWriter.write(string4);
                bufferedWriter.write(10);
            }
            String string5 = Rflow.settings().logValue();
            try (BufferedReader bufferedReader = new BufferedReader(new StringReader(string5));){
                String string6 = null;
                while ((string6 = bufferedReader.readLine()) != null) {
                    bufferedWriter.write("#");
                    bufferedWriter.write(string6);
                    bufferedWriter.write("\n");
                }
            }
        }
    }

    private String formatSettingLog(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("#");
        stringBuilder.append(string);
        stringBuilder.append("=");
        stringBuilder.append(string2);
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }

    public Date getDateFromFile(File file) {
        if (file == null) {
            return null;
        }
        Object object = FilenameUtils.removeExtension((String)file.getName());
        try {
            String[] stringArray = ((String)object).split("_", 4);
            if (stringArray.length > 3) {
                object = stringArray[0] + "_" + stringArray[1] + "_" + stringArray[2];
            }
            return FILE_DATE_FORMAT.parse((String)object);
        }
        catch (ParseException parseException) {
            return null;
        }
    }
}

