/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.base;

import com.ef_prime.rflow.core.base.LogManager;
import com.ef_prime.rflow.core.base.UserFolder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Comparator;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;

public class LogThread
extends Thread {
    private static final Logger LOGGER = Logger.getLogger(LogThread.class.getName());
    private long logSizeLimit;
    private static final DateFileSorter sorter = new DateFileSorter();
    private static final String LOCKFILE = "lock";
    private FileOutputStream lockFileStream;
    private FileLock lockFileLock;

    public LogThread() {
        super("Log Thread");
        this.setDaemon(true);
        this.logSizeLimit = 0xA00000L;
    }

    private boolean isLogFile(File file) {
        return file.exists() && !file.isDirectory();
    }

    @Override
    public void run() {
        File file = UserFolder.getLogDir();
        File file2 = new File(file, LOCKFILE);
        if (!file2.exists()) {
            try {
                FileUtils.touch((File)file2);
            }
            catch (IOException iOException) {
                LOGGER.log(Level.SEVERE, iOException.getMessage(), iOException);
                return;
            }
        }
        if (this.lockFileLock == null) {
            this.lockFileLock = this.obtainLock(file2);
        }
        if (this.lockFileLock != null && file.exists()) {
            this.compressAndClean(file);
        }
        this.close();
    }

    public void close() {
        if (this.lockFileLock != null) {
            try {
                this.lockFileLock.release();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.lockFileStream != null) {
            try {
                this.lockFileStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.interrupt();
    }

    private void compressAndClean(File file) {
        File[] fileArray = file.listFiles();
        Arrays.sort(fileArray, sorter);
        long l = 0L;
        int n = 0;
        for (int i = fileArray.length - 1; i >= 0; --i) {
            File file2 = fileArray[i];
            if (!this.isLogFile(file2) || file2.equals(LogManager.getInstance().getLogFile())) continue;
            if (file2.getName().endsWith("_r.log")) {
                String string = file2.getName();
                File file3 = new File(file2.getParentFile(), string.substring(0, string.length() - "_r.log".length()) + ".log");
                if (file3.exists()) continue;
            }
            if (++n > 31 || l > this.logSizeLimit) {
                FileUtils.deleteQuietly((File)file2);
                continue;
            }
            this.compressFile(file2);
            l += file2.length();
        }
    }

    private boolean checkLockFile(File file) {
        File file2 = new File(file.getParentFile(), file.getName() + ".lck");
        if (file2.exists()) {
            if (this.canObtainLock(file2)) {
                FileUtils.deleteQuietly((File)file2);
                return true;
            }
            return false;
        }
        return true;
    }

    private void compressFile(File file) {
        block39: {
            if (!file.getName().endsWith(".log")) {
                return;
            }
            File file2 = new File(file.getParentFile(), FilenameUtils.removeExtension((String)file.getName()) + "_r.log");
            if (!file2.exists()) {
                file2 = null;
            } else if (file2.length() == 0L) {
                FileUtils.deleteQuietly((File)file2);
                file2 = null;
            }
            if (!this.checkLockFile(file)) {
                return;
            }
            if (file2 != null && !this.checkLockFile(file2)) {
                file2 = null;
            }
            long l = file.lastModified();
            try {
                if (file2 == null) {
                    File file3 = new File(file.getParentFile(), FilenameUtils.removeExtension((String)file.getName()) + ".gz.tmp");
                    try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new GZIPOutputStream(new FileOutputStream(file3)), StandardCharsets.UTF_8);
                         InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new BufferedInputStream(new FileInputStream(file)), StandardCharsets.UTF_8);){
                        char[] cArray = new char[1024];
                        int n = 0;
                        while ((n = inputStreamReader.read(cArray)) >= 0) {
                            outputStreamWriter.write(cArray, 0, n);
                        }
                    }
                    file3.setLastModified(l);
                    if (file.delete()) {
                        if (!file3.renameTo(new File(file3.getParentFile(), FilenameUtils.removeExtension((String)file3.getName())))) {
                            LOGGER.warning("Failed to rename .gz.tmp to .gz");
                        }
                    } else {
                        FileUtils.deleteQuietly((File)file3);
                    }
                    break block39;
                }
                File file4 = new File(file.getParentFile(), FilenameUtils.removeExtension((String)file.getName()) + ".zip.tmp");
                try (ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(file4)));){
                    byte[] byArray = new byte[2048];
                    for (File file5 : new File[]{file, file2}) {
                        ZipEntry zipEntry = new ZipEntry(file5.getName());
                        zipOutputStream.putNextEntry(zipEntry);
                        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file5));){
                            int n = 0;
                            while ((n = ((InputStream)bufferedInputStream).read(byArray)) > 0) {
                                zipOutputStream.write(byArray, 0, n);
                            }
                        }
                        zipOutputStream.closeEntry();
                    }
                }
                file4.setLastModified(l);
                if (file.delete()) {
                    file2.delete();
                    if (!file4.renameTo(new File(file4.getParentFile(), FilenameUtils.removeExtension((String)file4.getName())))) {
                        LOGGER.warning("Failed to rename .zip.tmp to .zip");
                    }
                } else {
                    FileUtils.deleteQuietly((File)file4);
                }
            }
            catch (IOException iOException) {
                LOGGER.log(Level.SEVERE, "Failed to compress log file.", iOException);
            }
        }
    }

    private FileLock obtainLock(File file) {
        try {
            if (this.lockFileStream != null) {
                this.lockFileStream.close();
            }
            this.lockFileStream = new FileOutputStream(file, true);
            FileChannel fileChannel = this.lockFileStream.getChannel();
            return fileChannel.tryLock();
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean canObtainLock(File file) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file, true);
            FileChannel fileChannel = fileOutputStream.getChannel();
            try {
                FileLock fileLock = fileChannel.tryLock();
                if (fileLock == null) {
                    boolean bl = false;
                    return bl;
                }
                fileLock.release();
                return true;
            }
            finally {
                fileChannel.close();
                fileOutputStream.close();
            }
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static class DateFileSorter
    implements Comparator<File> {
        private DateFileSorter() {
        }

        @Override
        public int compare(File file, File file2) {
            int n = file.getName().compareTo(file2.getName());
            if (n != 0) {
                return n;
            }
            if (file.lastModified() < file2.lastModified()) {
                return -1;
            }
            return 1;
        }
    }
}

