/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.base;

import com.ef_prime.rflow.core.base.Plugin;
import com.ef_prime.rflow.core.common.util.Utility;
import com.ef_prime.rflow.core.util.YamlEx;
import com.ef_prime.rflow.node.ui.OpManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FilenameUtils;

public class PluginManager {
    private static final Logger LOGGER = Logger.getLogger(PluginManager.class.getName());
    private static final PluginManager instance = new PluginManager();
    private List<Plugin> plugins = new ArrayList<Plugin>();

    private PluginManager() {
    }

    public static PluginManager getInstance() {
        return instance;
    }

    public void init() {
        File file = new File(Utility.getPathStr("plugin"));
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        for (File file2 : fileArray) {
            File[] fileArray2;
            Object object;
            Object object2;
            Map<Object, Object> map;
            File file3 = new File(file2, "plugin.yaml");
            if (!file3.exists()) continue;
            try {
                map = YamlEx.map(new YamlEx().load(file3));
            }
            catch (IOException iOException) {
                LOGGER.log(Level.SEVERE, "Failed to read plugin config file: " + file3.getPath(), iOException);
                continue;
            }
            File file4 = new File(file2, "lib");
            if (file4.exists() && (object2 = file4.listFiles()) != null) {
                object = object2;
                int n = ((File[])object).length;
                for (int i = 0; i < n; ++i) {
                    Object object3 = object[i];
                    if (!FilenameUtils.isExtension((String)((File)object3).getName(), (String)"jar")) continue;
                    try {
                        Utility.addClassPath(((File)object3).toURI().toURL());
                        continue;
                    }
                    catch (IOException iOException) {
                        LOGGER.log(Level.SEVERE, "Failed to load jar: " + ((File)object3).getPath(), iOException);
                    }
                }
            }
            if ((object2 = map.get("plugin_class")) instanceof String) {
                object = Utility.createInstance((String)object2);
                if (object instanceof Plugin) {
                    Plugin plugin = (Plugin)object;
                    this.plugins.add(plugin);
                    plugin.load();
                } else {
                    LOGGER.severe("Failed to load plugin class: " + String.valueOf(object2));
                }
            }
            if (!(object = new File(file2, "toolbar")).exists() || (fileArray2 = object.listFiles()) == null) continue;
            for (File file5 : fileArray2) {
                OpManager.getInstance().loadToolbar(file5, file2);
            }
        }
    }

    public void initR() {
        for (Plugin plugin : this.plugins) {
            plugin.initR();
        }
    }
}

