/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.base;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.core.app.file.FileUtility;
import com.ef_prime.rflow.core.app.file.TextFile;
import com.ef_prime.rflow.core.base.SessionEntryHistory;
import com.ef_prime.rflow.core.base.UserFolder;
import com.ef_prime.rflow.core.base.UserProjectFolderManager;
import com.ef_prime.rflow.core.common.keyvalue.ChoiceKey;
import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.keyvalue.StrKey;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.core.util.FileRecord;
import com.ef_prime.rflow.core.util.Version;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.common.component.LockFile;
import com.google.common.hash.Hashing;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;

public class Project
extends ValueMap {
    public static final String LAUNCH_FILE_EXT = "afp";
    public static final String LAUNCH_FILE = "project.afp";
    private static final Logger LOGGER = Logger.getLogger(Project.class.getName());
    private static final Random RANDOM = new Random();
    private static final String NEW_PROJECT = "New Project";
    private static final Version VERSION = new Version(1, 0, 2);
    private static final StrKey KEY_VERSION = ((StrKey.Builder)StrKey.builder("version").setDefaultValue(VERSION.toString())).build();
    private static final StrKey KEY_ID = StrKey.builder("id").build();
    public static final StrKey KEY_NAME = StrKey.builder("name", Messages.getString("Project.project_name")).build();
    private static final StrKey KEY_WORKING_DIRECTORY = StrKey.builder("work_dir").build();
    private static final StrKey KEY_FLOW_DIRECTORY = StrKey.builder("flow_dir").build();
    public static final ChoiceKey ENCODING = ((ChoiceKey.Builder)((Key.Builder)ChoiceKey.builder("encoding", Messages.getString("Project.encoding")).setChoices(TextFile.ENCODING_CHOICES)).setDefaultValue(Charset.defaultCharset().name())).build();
    public static final ChoiceKey NEWLINE = ((ChoiceKey.Builder)((Key.Builder)ChoiceKey.builder("newline", Messages.getString("Project.newline")).setValuesAndLabels("<system_default>", "(" + Messages.getString("File.TextSettings.system_default") + ")", "LF", "", "CRLF", "")).setDefaultValue(System.lineSeparator().equals("\r\n") ? "CRLF" : "LF")).build();
    private static final String DIR_PROGRAM = ".afp";
    private static final String PROJECT_YAML = "project.yaml";
    private static final String PROJECT_XML = "project.xml";
    private static final String DIR_APP = "app";
    private static final String DIR_CONF = "conf";
    private static final String DIR_OUTPUT = "output";
    private static final String DIR_LOG = "log";
    private static final File DIR_USER_NEW = UserFolder.getUserDirFile("quick_start");
    private static final String DIR_NEW_PROJECT = "new_project";
    private static final String DIR_USER = "user";
    private static final String DIR_USER_PROJECT = "project";
    private static final String DIR_USER_PROJECT_TEMP = "tmp";
    private static final String DIR_STORE = "store";
    private static final String DIR_STATE = "state";
    private boolean isNewProject;
    private boolean newProjectSaveMode;
    private File location;
    private String userFolder;
    private LockFile newProjectLock;
    private FileRecord fileRecord;
    private SessionEntryHistory sessionEntryHistory;
    private boolean unloading;
    private boolean dirtyQuickStart = false;

    public void setDirtyQuickStart(boolean bl) {
        this.dirtyQuickStart = bl;
    }

    public static Project createEmptyProject() {
        return new Project(null, null, null, null, null);
    }

    public static Project createProject(File file) {
        return new Project(file, null, null, null, null);
    }

    public static Project createProject(File file, String string, String string2, String string3, String string4) {
        return new Project(file, string, string2, string3, string4);
    }

    public static boolean isProject(File file) {
        return new File(file, Project.projectFilePath()).exists();
    }

    public static String projectFilePath() {
        return ".afp/project.yaml";
    }

    public static File getProjectHome(File file) {
        File file2 = null;
        int n = 0;
        for (File file3 = file.getParentFile(); file3 != null && n++ < 20; file3 = file3.getParentFile()) {
            if (!Project.isProject(file3)) continue;
            file2 = file3;
            break;
        }
        return file2;
    }

    public static boolean isInProjectFlowFile(File file) {
        File file2 = Project.getProjectHome(file);
        if (file2 == null) {
            return false;
        }
        return Project.isProject(file2);
    }

    public static boolean isNewProject(File file) {
        return FileUtility.isChild(DIR_USER_NEW, file);
    }

    public static String getName(File file) throws IOException {
        if (Project.isNewProject(file)) {
            return NEW_PROJECT;
        }
        Project project = Project.createProject(file);
        if (project.isNewProject()) {
            return project.getName();
        }
        File file2 = project.getProjectFile();
        if (file2.exists() && file2.length() > 0L) {
            try {
                project.loadProjectFile();
            }
            catch (IOException iOException) {
                throw new IOException("Failed to read " + file2.getName(), iOException);
            }
        }
        return project.getName();
    }

    public static List<File> getAndCleanUpNewProjects() {
        ArrayList<File> arrayList = new ArrayList<File>();
        File[] fileArray = DIR_USER_NEW.listFiles();
        if (fileArray != null) {
            for (File file : fileArray) {
                if (!file.isDirectory() || !file.getName().startsWith(DIR_NEW_PROJECT)) continue;
                if (Project.isProject(file)) {
                    arrayList.add(file);
                    continue;
                }
                FileUtils.deleteQuietly((File)file);
            }
        }
        return arrayList;
    }

    public static File getTempDirInNewProject(File file) {
        return new File(file, DIR_PROGRAM + File.separatorChar + DIR_USER + File.separatorChar + DIR_USER_PROJECT_TEMP);
    }

    public static void cleanUpNewProjects() {
        for (File file : Project.getAndCleanUpNewProjects()) {
            if (Project.isProject(file)) continue;
            FileUtils.deleteQuietly((File)file);
        }
    }

    private Project(File file, String string, String string2, String string3, String string4) {
        this.isNewProject = file == null || Project.isNewProject(file);
        this.location = file;
        this.registerKeys(KEY_VERSION, KEY_ID, KEY_NAME, KEY_WORKING_DIRECTORY, KEY_FLOW_DIRECTORY, ENCODING, NEWLINE);
        if (string != null) {
            this.putValueQuietly(KEY_NAME, string);
        }
        if (string2 != null) {
            String string5 = this.toProjectAbstractPath(new File(string2));
            this.putValueQuietly(KEY_WORKING_DIRECTORY, string5);
        }
        if (string3 != null) {
            this.putValueQuietly(ENCODING, string3);
        }
        if (string4 != null) {
            this.putValueQuietly(NEWLINE, string4);
        }
    }

    public void createLocation() throws IOException {
        if (this.location == null) {
            return;
        }
        FileUtils.forceMkdir((File)this.location);
    }

    public void load() throws IOException {
        Object[] objectArray;
        File file;
        if (this.isNewProject()) {
            if (this.location == null) {
                this.newProjectLock = LockFile.getDirWithLock(DIR_USER_NEW, DIR_NEW_PROJECT);
                this.location = this.newProjectLock.getFile().getParentFile();
            } else {
                this.newProjectLock = LockFile.createLockFile(this.location);
                this.newProjectLock.tryLock();
            }
        }
        if (!(file = this.getProjectFile()).exists() && (this.getOldProjectFile().exists() || this.getOldXmlProjectFile().exists())) {
            if (this.getOldProjectFile().exists()) {
                FileUtils.moveFileToDirectory((File)this.getOldProjectFile(), (File)this.getProgramDir(), (boolean)true);
            }
            objectArray = new String[]{DIR_CONF, "flow", DIR_OUTPUT, DIR_LOG, DIR_APP};
            for (Object object : objectArray) {
                File file2 = new File(this.location, (String)object);
                if (!file2.exists()) continue;
                FileUtils.moveDirectoryToDirectory((File)file2, (File)this.getProgramDir(), (boolean)true);
            }
            if (this.getOldXmlProjectFile().exists()) {
                FileUtils.deleteQuietly((File)this.getOldXmlProjectFile());
            }
        }
        if (file.exists() && file.length() > 0L) {
            try {
                this.loadProjectFile();
            }
            catch (IOException iOException) {
                throw new IOException("Failed to read " + file.getName(), iOException);
            }
        }
        if (this.isStringEmpty(KEY_ID) || !file.exists()) {
            if (this.isStringEmpty(KEY_ID)) {
                this.setId();
            }
            this.putValue(KEY_VERSION, VERSION.toString());
            try {
                this.saveProjectFile();
            }
            catch (IOException iOException) {
                throw new IOException("Failed to write " + file.getName(), iOException);
            }
        }
        this.putValue(KEY_VERSION, VERSION.toString());
        if (!this.isNewProject() && this.userFolder == null) {
            this.userFolder = UserProjectFolderManager.getInstance().getFolder(this);
        }
        objectArray = new File[]{this.getWorkspaceDir(), this.getConfDir(), this.getLogDir()};
        for (Object object : objectArray) {
            if (((File)object).exists()) continue;
            ((File)object).mkdirs();
        }
    }

    public void unload() {
        if (this.newProjectLock != null) {
            this.newProjectLock.release();
        }
        if (this.isNewProject && !this.newProjectSaveMode) {
            FileUtils.deleteQuietly((File)this.location);
        }
        if (!this.newProjectSaveMode) {
            FileUtils.deleteQuietly((File)this.getTempDir());
        }
        if (this.sessionEntryHistory != null) {
            this.sessionEntryHistory.removeAll();
        }
    }

    private void setId() {
        long l = new Date().getTime();
        long l2 = RANDOM.nextLong();
        String string = Hashing.sha1().newHasher().putLong(l).putLong(l2).hash().toString();
        this.putValue(KEY_ID, string);
    }

    public void saveProjectFile() throws IOException {
        if (!this.getProgramDir().exists()) {
            FileUtils.forceMkdir((File)this.getProgramDir());
        }
        this.storeToYaml(this.getProjectFile());
    }

    public void loadProjectFile() throws IOException {
        if (this.getProjectFile().exists()) {
            this.loadFromYaml(this.getProjectFile());
            Version version = Version.parseOrDefault(this.getValue(KEY_VERSION), VERSION);
            if (version.isOlderThan("1.0.2")) {
                if (!this.contains(ENCODING)) {
                    this.putValue(ENCODING, "<system_default>");
                }
                if (!this.contains(NEWLINE)) {
                    this.putValue(NEWLINE, "<system_default>");
                }
            }
            return;
        }
    }

    public boolean isNewProject() {
        return this.isNewProject;
    }

    public File getLocation() {
        return this.location;
    }

    public boolean isDummyProject() {
        return this.location == null;
    }

    public String getId() {
        return this.getValue(KEY_ID);
    }

    public void setNewProjectSaveMode(boolean bl) {
        this.newProjectSaveMode = bl;
    }

    public boolean isNewProjectSaveMode() {
        return this.newProjectSaveMode;
    }

    public String getName() {
        if (this.isNewProject()) {
            return NEW_PROJECT;
        }
        if (this.isStringEmpty(KEY_NAME)) {
            return this.location.getName();
        }
        return this.getValue(KEY_NAME);
    }

    public String getEncoding() {
        return this.getValue(ENCODING);
    }

    public Charset getCharset(Charset charset) {
        try {
            String string = Rflow.project().getEncoding();
            if (string.equals("<system_default>")) {
                return Charset.defaultCharset();
            }
            return Charset.forName(string);
        }
        catch (Exception exception) {
            return charset;
        }
    }

    public String getNewline() {
        String string = this.getValue(NEWLINE);
        if (string.equals("<system_default>")) {
            string = System.lineSeparator().equals("\r\n") ? "CRLF" : "LF";
        }
        return string;
    }

    public void setWorkingDirectory(String string) {
        this.putValue(KEY_WORKING_DIRECTORY, string);
        try {
            this.saveProjectFile();
        }
        catch (IOException iOException) {
            LOGGER.log(Level.WARNING, "Failed to write " + this.getProjectFile().getName(), iOException);
        }
    }

    private File getProgramDir() {
        return new File(this.location, DIR_PROGRAM);
    }

    private File getOldXmlProjectFile() {
        return new File(this.location, PROJECT_XML);
    }

    private File getOldProjectFile() {
        return new File(this.location, PROJECT_YAML);
    }

    public File getProjectFile() {
        return new File(this.getProgramDir(), PROJECT_YAML);
    }

    public File getFlowDir() {
        if (this.isStringEmpty(KEY_FLOW_DIRECTORY)) {
            return new File(this.getProgramDir(), "flow");
        }
        String string = this.toProjectAbsolutePath(this.getValue(KEY_FLOW_DIRECTORY));
        return new File(string);
    }

    public File getAppDir() {
        return new File(this.getProgramDir(), DIR_APP);
    }

    public File getConfDir() {
        return new File(this.getProgramDir(), DIR_CONF);
    }

    public File getWorkspaceDir() {
        if (this.isStringEmpty(KEY_WORKING_DIRECTORY)) {
            return this.getDefaultWorkspaceDir();
        }
        String string = this.toProjectAbsolutePath(this.getValue(KEY_WORKING_DIRECTORY));
        return new File(string);
    }

    public File getDefaultWorkspaceDir() {
        return this.location;
    }

    public File getOutputDir() {
        return new File(this.getProgramDir(), DIR_OUTPUT);
    }

    public File getLogDir() {
        return new File(this.getProgramDir(), DIR_LOG);
    }

    public File getTempOutputDir() {
        return new File(this.getTempDir(), DIR_OUTPUT);
    }

    public File getUserProjectDir() {
        if (this.isNewProject()) {
            return new File(this.getProgramDir(), DIR_USER);
        }
        return UserFolder.getUserDirFile("project/" + this.userFolder);
    }

    public File getStoreDir() {
        return new File(this.getUserProjectDir(), DIR_STORE);
    }

    public File getStateDir() {
        return new File(this.getUserProjectDir(), DIR_STATE);
    }

    public File getTempDir() {
        return new File(this.getUserProjectDir(), DIR_USER_PROJECT_TEMP);
    }

    public String getVersion() {
        return this.getValue(KEY_VERSION);
    }

    public File createTempDir() throws IOException {
        return FileUtility.createTempDir(this.getTempDir());
    }

    public void move(File file) throws IOException {
        File file2 = this.getUserProjectDir();
        File file3 = this.location;
        this.location = file;
        this.isNewProject = false;
        if (this.isNewProject()) {
            FileUtils.moveDirectory((File)file2, (File)this.getUserProjectDir());
        }
        FileUtils.moveDirectory((File)file3, (File)this.location);
    }

    public void importProject(Project project) throws IOException {
        if (this.userFolder == null) {
            this.userFolder = UserProjectFolderManager.getInstance().getFolder(this);
        }
        if (project.isNewProject()) {
            FileUtility.moveDirectoryContents(project.getUserProjectDir(), this.getUserProjectDir());
            project.getUserProjectDir().delete();
        }
        FileUtility.moveDirectoryContents(project.getLocation(), this.location);
        this.saveProjectFile();
    }

    public String toProjectAbstractPath(File file) {
        File file2 = FileUtility.makeAbstractPath(this.location, file);
        return FilenameUtils.separatorsToUnix((String)file2.getPath());
    }

    public String toProjectAbsolutePath(String string) {
        if (FilenameUtils.getPrefix((String)string).isEmpty()) {
            return FilenameUtils.separatorsToUnix((String)new File(this.location, string).getAbsolutePath());
        }
        return string;
    }

    public boolean isOutput(File file) {
        return FileUtility.isChild(this.getOutputDir(), file);
    }

    public void saveFileRecord() {
        this.fileRecord = new FileRecord(this.location, true, new Predicate<File>(){

            @Override
            public boolean test(File file) {
                return !FileUtility.isChild(Project.this.getStateDir(), file) && !FileUtility.isChild(Project.this.getTempDir(), file);
            }
        });
    }

    public boolean checkDirty() {
        if (this.dirtyQuickStart) {
            return true;
        }
        if (this.fileRecord != null) {
            return this.fileRecord.hadChanged();
        }
        return false;
    }

    public ValueMap getProjectProperties() {
        ValueMap valueMap = new ValueMap();
        valueMap.copyValues(this);
        return valueMap;
    }

    public boolean isUnloading() {
        return this.unloading;
    }

    public void setUnloading(boolean bl) {
        this.unloading = bl;
    }

    public SessionEntryHistory getSessionEntryHistory() {
        if (this.sessionEntryHistory == null) {
            this.sessionEntryHistory = new SessionEntryHistory();
        }
        return this.sessionEntryHistory;
    }

    @Override
    protected boolean keepUnknownYamlEntries() {
        return true;
    }
}

