/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.base;

import com.ef_prime.rflow.core.app.file.FileSessionEntry;
import com.ef_prime.rflow.core.app.file.FileUtility;
import com.ef_prime.rflow.core.app.file.FileViewerSessionEntry;
import com.ef_prime.rflow.core.app.r.base.RObjectViewerSessionEntry;
import com.ef_prime.rflow.core.base.Project;
import com.ef_prime.rflow.core.base.SessionEntry;
import com.ef_prime.rflow.core.common.util.Utility;
import com.ef_prime.rflow.core.common.xml.XmlContext;
import com.ef_prime.rflow.core.common.xml.XmlElement;
import com.ef_prime.rflow.core.common.xml.XmlUtility;
import com.ef_prime.rflow.core.flow.FlowSessionEntry;
import com.ef_prime.rflow.core.util.YamlEx;
import com.ef_prime.rflow.node.ui.NewNodeSessionEntry;
import com.ef_prime.rflow.ui.view.ViewPosition;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ProjectSession
implements XmlElement {
    private static final Logger LOGGER = Logger.getLogger(ProjectSession.class.getName());
    private static final String SESSION_YAML = "session.yaml";
    private static final String SESSION_XML = "session.xml";
    private List<SessionEntry> entries;
    private static final Map<String, Class<? extends SessionEntry>> TYPE_MAP = new HashMap<String, Class<? extends SessionEntry>>();

    private static void addType(Class<? extends SessionEntry> clazz) {
        SessionEntry sessionEntry = (SessionEntry)Utility.createInstance(clazz.getName());
        if (sessionEntry != null) {
            String string = sessionEntry.getType();
            TYPE_MAP.put(string, clazz);
        }
    }

    public static ProjectSession load(Project project) throws IOException {
        File file = ProjectSession.getSessionFile(project);
        if (!file.exists()) {
            file = ProjectSession.getSessionFileOld(project);
            if (!file.exists()) {
                return new ProjectSession(new ArrayList<SessionEntry>());
            }
            Object object = new YamlEx().load(file);
            List list = (List)YamlEx.typeCheck(List.class, object);
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Object object2 : list) {
                String string = (String)YamlEx.typeCheck(String.class, object2);
                arrayList.add(project.toProjectAbsolutePath(string));
            }
            ArrayList arrayList2 = new ArrayList(arrayList.size());
            for (String string : arrayList) {
                arrayList2.add(FlowSessionEntry.create(ViewPosition.MAIN, false, new File(string), null, project, false));
            }
            return new ProjectSession(arrayList2);
        }
        return XmlUtility.readXml(file, new ProjectSession());
    }

    private static File getSessionFileOld(Project project) {
        return new File(project.getStateDir(), SESSION_YAML);
    }

    private static File getSessionFile(Project project) {
        return new File(project.getStateDir(), SESSION_XML);
    }

    private ProjectSession() {
    }

    public ProjectSession(List<SessionEntry> list) {
        this.entries = list;
    }

    public List<SessionEntry> getEntries() {
        return this.entries;
    }

    public void save(Project project) throws IOException {
        File file = ProjectSession.getSessionFile(project);
        FileUtils.forceMkdir((File)file.getParentFile());
        FileUtility.safeSave(file.toPath(), project.getTempDir().toPath(), path -> XmlUtility.writeXml(path.toFile(), "session", this));
    }

    @Override
    public void storeToElement(XmlContext xmlContext, Document document, Element element) {
        for (SessionEntry sessionEntry : this.entries) {
            XmlUtility.addElement(xmlContext, document, element, "entry", sessionEntry);
        }
    }

    @Override
    public void loadElement(Element element, XmlContext xmlContext) {
        List<Element> list = XmlUtility.getChildren("entry", element);
        this.entries = new ArrayList<SessionEntry>(list.size());
        for (Element element2 : list) {
            try {
                this.entries.add((SessionEntry)XmlUtility.loadElement(xmlContext, element2, "type", TYPE_MAP));
            }
            catch (IOException iOException) {
                LOGGER.log(Level.WARNING, "Failed to read session entry.", iOException);
            }
        }
    }

    static {
        ProjectSession.addType(FlowSessionEntry.class);
        ProjectSession.addType(FileSessionEntry.class);
        ProjectSession.addType(NewNodeSessionEntry.class);
        ProjectSession.addType(RObjectViewerSessionEntry.class);
        ProjectSession.addType(FileViewerSessionEntry.class);
    }
}

