/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.base;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.core.app.file.FileUtility;
import com.ef_prime.rflow.core.base.FileEditManager;
import com.ef_prime.rflow.core.base.Project;
import com.ef_prime.rflow.core.base.UserFolder;
import com.ef_prime.rflow.core.common.xml.XmlContext;
import com.ef_prime.rflow.core.common.xml.XmlUtility;
import com.ef_prime.rflow.core.flow.FlowModel;
import com.ef_prime.rflow.core.util.ReadException;
import com.ef_prime.rflow.core.util.YamlEx;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.base.FileProjectNode;
import com.ef_prime.rflow.ui.base.FileProjectNodeEx;
import com.ef_prime.rflow.ui.base.FolderProjectNode;
import com.ef_prime.rflow.ui.base.ProjectNode;
import com.ef_prime.rflow.ui.common.component.TreeIterator;
import com.ef_prime.rflow.ui.common.event.ChangeEventHandler;
import com.ef_prime.rflow.ui.common.event.ChangeEventSupport;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.tree.DefaultTreeModel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ProjectsManager {
    private static final Logger LOGGER = Logger.getLogger(ProjectsManager.class.getName());
    private static final String PROJECTS_FILE = "projects.xml";
    private static final String PROJECTS_YAML_FILE = "projects.yaml";
    private DefaultTreeModel treeModel;
    private DefaultTreeModel currentProjectTreeModel;
    private ProjectNode root;
    private static final ProjectsManager instance = new ProjectsManager();
    private ChangeEventSupport changeEventSupport = new ChangeEventSupport(this);

    private ProjectsManager() {
        this.load();
    }

    public static ProjectsManager getInstance() {
        return instance;
    }

    private File getProjectsFile() {
        return UserFolder.getUserDirFile(PROJECTS_FILE);
    }

    private File getYamlProjectsFile() {
        return UserFolder.getUserDirFile(PROJECTS_YAML_FILE);
    }

    private void load() {
        this.root = new FolderProjectNode("");
        try {
            if (this.getYamlProjectsFile().exists()) {
                new YamlEx().loadYamlable(this.getYamlProjectsFile(), this.root);
            } else if (this.getProjectsFile().exists()) {
                Document document = XmlUtility.readXml(this.getProjectsFile());
                Element element = XmlUtility.getChild("group", document.getDocumentElement());
                this.root.loadElement(element, new XmlContext());
            }
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "Failed to load bookmarks.", exception);
        }
        this.root.setName(Messages.getString("StartPage.bookmark"));
        this.treeModel = new DefaultTreeModel(this.root, true);
    }

    private void store() throws IOException {
        new YamlEx().dumpYamlable(this.getYamlProjectsFile(), this.root);
    }

    public void addNode(ProjectNode projectNode, ProjectNode projectNode2) {
        this.treeModel.insertNodeInto(projectNode, projectNode2, 0);
        try {
            this.store();
        }
        catch (IOException iOException) {
            LOGGER.log(Level.SEVERE, "Failed to save bookmarks.", iOException);
        }
        this.changeEventSupport.dispatchEvent();
    }

    public void addEntry(File file) {
        this.addNode(new FileProjectNode(file), this.root);
    }

    public void addNode(ProjectNode projectNode) {
        this.addNode(projectNode, this.root);
    }

    public void removeNode(List<ProjectNode> list) {
        for (ProjectNode projectNode : list) {
            if (projectNode.getParent().isFile()) continue;
            this.treeModel.removeNodeFromParent(projectNode);
        }
        try {
            this.store();
        }
        catch (IOException iOException) {
            LOGGER.log(Level.SEVERE, "Failed to save bookmarks.", iOException);
        }
        this.changeEventSupport.dispatchEvent();
    }

    public void removeFlow(ProjectNode projectNode) throws ReadException, IOException {
        if (!projectNode.isFlowFile()) {
            return;
        }
        this.removeFlow(projectNode.getFile());
        this.treeModel.removeNodeFromParent(projectNode);
    }

    private void removeFlow(File file) throws ReadException, IOException {
        FileEditManager fileEditManager = FileEditManager.getInstance();
        for (FlowModel flowModel : fileEditManager.getFlowModels()) {
            if (!file.equals(flowModel.getWorkingFile())) continue;
            fileEditManager.unload(flowModel, flowModel);
        }
        FlowModel flowModel = FlowModel.readFlowModel(file, file, null);
        if (flowModel.checkDataConnection()) {
            FileUtility.removeFile(flowModel.getFlowDataDir());
        }
        FileUtility.removeFile(file);
    }

    public void rename(ProjectNode projectNode, String string) throws ReadException, IOException {
        if (projectNode.isFlowFile()) {
            this.renameFlow(projectNode.getFile(), string);
        } else {
            projectNode.setUserObject(string);
        }
        this.treeModel.nodeChanged(projectNode);
        try {
            this.store();
        }
        catch (IOException iOException) {
            LOGGER.log(Level.SEVERE, "Failed to save bookmarks.", iOException);
        }
        this.changeEventSupport.dispatchEvent();
    }

    private void renameFlow(File file, String string) throws ReadException, IOException {
        FlowModel flowModel = null;
        FileEditManager fileEditManager = FileEditManager.getInstance();
        for (FlowModel flowModel2 : fileEditManager.getFlowModels()) {
            if (!file.equals(flowModel2.getWorkingFile())) continue;
            flowModel = flowModel2;
            if (!flowModel.isDirty()) break;
            return;
        }
        if (flowModel == null) {
            flowModel = FlowModel.readFlowModel(file, file, null);
        }
        flowModel.rename(string);
    }

    public void projectNodeMoved() {
        try {
            this.store();
        }
        catch (IOException iOException) {
            LOGGER.log(Level.SEVERE, "Failed to save bookmarks.", iOException);
        }
    }

    public boolean contains(Project project) {
        TreeIterator treeIterator = new TreeIterator(this.root);
        while (treeIterator.hasNext()) {
            ProjectNode projectNode = (ProjectNode)treeIterator.next();
            if (!projectNode.isProject() || !projectNode.getFile().equals(project.getLocation())) continue;
            return true;
        }
        return false;
    }

    public DefaultTreeModel getProjectsTreeModel() {
        return this.treeModel;
    }

    public DefaultTreeModel createCurrentProjectTreeModel() {
        File file = Rflow.project().getLocation();
        this.currentProjectTreeModel = new DefaultTreeModel(new FileProjectNodeEx(file), true);
        return this.currentProjectTreeModel;
    }

    public DefaultTreeModel getCurrentProjectTreeModel() {
        return this.currentProjectTreeModel;
    }

    public DefaultTreeModel getProjectTreeModel(ProjectNode projectNode) {
        return new DefaultTreeModel(projectNode, true);
    }

    public void addChangeEventHandler(ChangeEventHandler changeEventHandler) {
        this.changeEventSupport.addEventHandler(changeEventHandler);
    }

    public void removeChangeEventHandler(ChangeEventHandler changeEventHandler) {
        this.changeEventSupport.removeEventHandler(changeEventHandler);
    }
}

