/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.base;

import com.ef_prime.rflow.core.base.FileResource;
import com.ef_prime.rflow.resource.Messages;
import java.io.File;
import java.util.ArrayDeque;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SampleEntry {
    private Element el;

    public SampleEntry(Element element) {
        this.el = element;
    }

    public Element[] getPath() {
        ArrayDeque<Element> arrayDeque = new ArrayDeque<Element>();
        Element element = this.el;
        while (element != null) {
            arrayDeque.addFirst(element);
            Node node = element.getParentNode();
            if (node.getNodeType() != 1) break;
            element = (Element)node;
        }
        return arrayDeque.toArray(new Element[arrayDeque.size()]);
    }

    public String getName() {
        String string;
        Object object;
        Object object2;
        StringBuilder stringBuilder = new StringBuilder();
        Element[] elementArray = this.getPath();
        for (int i = 1; i < elementArray.length; ++i) {
            object2 = elementArray[i - 1].getChildNodes();
            object = elementArray[i];
            int n = 0;
            for (int j = 0; j < object2.getLength(); ++j) {
                if (object2.item(j).getNodeType() != 1) continue;
                ++n;
                if (object2.item(j).equals(object)) break;
            }
            if (i != 1) {
                stringBuilder.append("-");
            }
            stringBuilder.append(n);
        }
        if (elementArray.length > 1) {
            stringBuilder.append(". ");
        }
        if ((string = this.el.getAttribute("key")) != null) {
            object2 = "Sample." + string;
            object = Messages.containsKey((String)object2) ? Messages.getString((String)object2) : string.replace('_', ' ');
            stringBuilder.append((String)object);
        }
        return stringBuilder.toString();
    }

    public File getFile() {
        File file = FileResource.getSampleFolder();
        Object[] objectArray = this.toKeys(this.getPath());
        objectArray = (String[])ArrayUtils.remove((Object[])objectArray, (int)0);
        return new File(file, StringUtils.join((Object[])objectArray, (char)'/') + ".rflow");
    }

    private String[] toKeys(Element[] elementArray) {
        String[] stringArray = new String[elementArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = elementArray[i].getAttribute("key");
        }
        return stringArray;
    }

    public String getPathToKey() {
        return StringUtils.join((Object[])this.toKeys(this.getPath()), (char)'/');
    }

    public SampleEntry getNextSample() {
        Node node = this.el;
        do {
            if ((node = this.getNextNode(node)) != null) continue;
            return null;
        } while (node.getNodeType() != 1 || node.hasChildNodes());
        return new SampleEntry((Element)node);
    }

    public Node getNextNode(Node node) {
        NodeList nodeList = node.getChildNodes();
        if (nodeList.getLength() == 0) {
            Node node2 = node.getNextSibling();
            if (node2 == null) {
                Node node3 = node.getParentNode();
                while (true) {
                    if (node3 == null) {
                        return null;
                    }
                    node2 = node3.getNextSibling();
                    if (node2 != null) {
                        return node2;
                    }
                    node3 = node3.getParentNode();
                }
            }
            return node2;
        }
        return nodeList.item(0);
    }
}

