/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.base;

import com.ef_prime.rflow.core.common.xml.XmlContext;
import com.ef_prime.rflow.core.common.xml.XmlElement;
import com.ef_prime.rflow.core.common.xml.XmlUtility;
import com.ef_prime.rflow.ui.view.ViewPosition;
import javax.swing.Icon;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class SessionEntry
implements XmlElement {
    public static final String TYPE_TAG = "type";
    private ViewPosition position;
    private boolean selected;
    private Icon icon;

    public SessionEntry() {
    }

    public SessionEntry(ViewPosition viewPosition, boolean bl, Icon icon) {
        this.position = viewPosition;
        this.selected = bl;
        this.icon = icon;
    }

    public abstract String getTitle();

    public Icon getIcon() {
        return this.icon;
    }

    public abstract String getType();

    public ViewPosition getPosition() {
        return this.position;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public String getFileID() {
        return null;
    }

    public void dispose() {
    }

    @Override
    public void storeToElement(XmlContext xmlContext, Document document, Element element) {
        element.setAttribute(TYPE_TAG, this.getType());
        if (this.position != null) {
            element.setAttribute("pos", this.position.getId());
        }
        if (this.selected) {
            element.setAttribute("selected", "true");
        }
    }

    @Override
    public void loadElement(Element element, XmlContext xmlContext) {
        this.position = ViewPosition.parse(XmlUtility.getAttribute(element, "pos", ""), ViewPosition.MAIN);
        this.selected = "true".equals(element.getAttribute("selected"));
    }
}

