/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.base;

import com.ef_prime.rflow.core.app.r.base.RSupport;
import com.ef_prime.rflow.core.base.OldSettings;
import com.ef_prime.rflow.core.base.RflowVersion;
import com.ef_prime.rflow.core.base.UserFolder;
import com.ef_prime.rflow.core.common.keyvalue.BoolKey;
import com.ef_prime.rflow.core.common.keyvalue.DoubleKey;
import com.ef_prime.rflow.core.common.keyvalue.IntKey;
import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.keyvalue.ListKey;
import com.ef_prime.rflow.core.common.keyvalue.LongKey;
import com.ef_prime.rflow.core.common.keyvalue.MapKey;
import com.ef_prime.rflow.core.common.keyvalue.RadioButtonKey;
import com.ef_prime.rflow.core.common.keyvalue.StrKey;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.core.common.keyvalue.ValueMapKey;
import com.ef_prime.rflow.core.util.YamlEx;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.app.r.gd.GDSettings;
import com.ef_prime.rflow.ui.util.PropertiesUtility;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;

public class Settings
extends ValueMap {
    public static final String LANG_SYSTEM = "system";
    public static final String TAB_FILE = "TAB_FILE";
    public static final String TAB_OBJECT = "TAB_OBJECT";
    public static final String TAB_TASK = "TAB_TASK";
    public static final String TAB_BREAKPOINT = "TAB_BREAKPOINT";
    public static final String TAB_SEARCH = "TAB_SEARCH";
    public static final int NORMAL = 0;
    public static final int MAXIMIZED_HORIZ = 2;
    public static final int MAXIMIZED_VERT = 4;
    public static final int MAXIMIZED_BOTH = 6;
    public static final int GD_CANVAS_TYPE_DEFAULT = 0;
    public static final int GD_CANVAS_TYPE_CUSTOM = 1;
    public static final int GD_CANVAS_TYPE_AUTO = 2;
    public static final int GD_ZOOM_TYPE_FIT_CANVAS = 0;
    public static final int GD_ZOOM_TYPE_FIT_WIDTH = 1;
    public static final int GD_ZOOM_TYPE_FIT_100 = 2;
    public static final int GD_ZOOM_TYPE_FIT_CUSTOM = 3;
    public static final String FILE_SORT_BY_NAME = "name";
    public static final String FILE_SORT_BY_TYPE = "type";
    public static final String PRESENTATION_FLAT = "flat";
    public static final String PRESENTATION_HIERARCHICAL = "hierarchical";
    public static final int POSITION_WORK_AREA = 0;
    public static final int POSITION_CONTROL_UPPER = 1;
    public static final int POSITION_CONTROL_LOWER = 2;
    public static final int POSITION_BORDER_NORTH = 0;
    public static final int POSITION_BORDER_EAST = 1;
    public static final int POSITION_BORDER_SOUTH = 2;
    public static final int POSITION_BORDER_WEST = 3;
    public static final String PROJECT_R_RESTART_YES = "yes";
    public static final String PROJECT_R_RESTART_NO = "no";
    public static final String PROJECT_R_RESTART_ASK = "ask";
    public static final String OPEN_TYPE_TAB = "tab";
    public static final String OPEN_TYPE_SYSTEM_EDITOR = "system";
    public static final String OPEN_TYPE_CHOOSE = "choose";
    public static final String NODE_OPEN_MODE_NEW_TAB = "new_tab";
    public static final String NODE_OPEN_MODE_CURRENT_TAB = "current_tab";
    public static final StrKey VERSION = ((StrKey.Builder)StrKey.builder("VERSION", "").setDefaultValue(RflowVersion.get().toString())).build();
    public static final StrKey R_HOME = ((StrKey.Builder)StrKey.builder("R_HOME", "").setDefaultValue("")).build();
    public static final StrKey R_OPTIONS = ((StrKey.Builder)StrKey.builder("R_OPTIONS", "").setDefaultValue("--no-environ --no-init-file --no-restore")).build();
    public static final BoolKey IS_AUTO_UPDATE = ((BoolKey.Builder)BoolKey.builder("IS_AUTO_UPDATE", "").setDefaultValue(false)).build();
    public static final StrKey DEFAULT_WORKING_DIRECTORY = ((StrKey.Builder)StrKey.builder("DEFAULT_WORKING_DIRECTORY", "").setDefaultValue("")).build();
    public static final StrKey LANGUAGE = ((StrKey.Builder)StrKey.builder("LANGUAGE", "").setDefaultValue("system")).build();
    public static final BoolKey USE_CONSOLE_BUFFER = ((BoolKey.Builder)BoolKey.builder("USE_CONSOLE_BUFFER", "").setDefaultValue(true)).build();
    public static final IntKey CONSOLE_MAX_CHARS = ((IntKey.Builder)IntKey.builder("CONSOLE_MAX_CHARS", "").setDefaultValue(65000)).build();
    public static final ListKey<String> INVISIBLE_TABS = ListKey.builder("INVISIBLE_TABS", "", StrKey.builder("INVISIBLE_TAB", "").build()).build();
    public static final RadioButtonKey NODE_OPEN_MODE = ((RadioButtonKey.Builder)((RadioButtonKey.Builder)RadioButtonKey.builder("NODE_OPEN_MODE", Messages.getString("Setting.OpenMode.title")).setValuesAndLabels("current_tab", Messages.getString("Setting.OpenMode.current_tab"), "new_tab", Messages.getString("Setting.OpenMode.new_tab"))).noLabel()).build();
    public static final ListKey<String> EDITORS = ListKey.builder("EDITORS", "", StrKey.builder("EDITOR", "").build()).build();
    @Deprecated
    public static final BoolKey SEND_LOG = ((BoolKey.Builder)BoolKey.builder("SEND_LOG", "").setDefaultValue(false)).build();
    public static final StrKey USER_ID = ((StrKey.Builder)StrKey.builder("USER_ID", "").setDefaultValue("")).build();
    public static final BoolKey AUTO_SELECT_ITEM = ((BoolKey.Builder)((BoolKey.Builder)BoolKey.builder("AUTO_SELECT_ITEM", Messages.getString("Setting.auto_select_item")).noLabel()).setDefaultValue(true)).build();
    public static final BoolKey USE_RFLOW_VIEW = ((BoolKey.Builder)((BoolKey.Builder)BoolKey.builder("USE_RFLOW_VIEW", Messages.getString("Setting.use_rflow_view")).noLabel()).setDefaultValue(true)).build();
    public static final DoubleKey BASIC_FONT_SIZE = ((DoubleKey.Builder)DoubleKey.builder("BASIC_FONT_SIZE", "").setDefaultValue(12.0)).build();
    public static final DoubleKey CODE_FONT_SIZE = ((DoubleKey.Builder)DoubleKey.builder("CODE_FONT_SIZE", "").setDefaultValue(12.0)).build();
    public static final StrKey CODE_FONT_FAMILY = ((StrKey.Builder)StrKey.builder("CODE_FONT_FAMILY", "").setDefaultValue("Monospaced")).build();
    public static final DoubleKey DATA_FONT_SIZE = ((DoubleKey.Builder)DoubleKey.builder("DATA_FONT_SIZE", "").setDefaultValue(12.0)).build();
    public static final DoubleKey HELP_FONT_SCALE = ((DoubleKey.Builder)DoubleKey.builder("HELP_FONT_SCALE", "").setDefaultValue(1.0)).build();
    public static final IntKey TOOLBAR_LOCATION = ((IntKey.Builder)IntKey.builder("TOOLBAR_LOCATION", "").setDefaultValue(0)).build();
    public static final BoolKey TOOLBAR_SMALL_ICON = ((BoolKey.Builder)BoolKey.builder("TOOLBAR_SMALL_ICON", "").setDefaultValue(false)).build();
    public static final BoolKey TOOLBAR_HIDE_LABEL = ((BoolKey.Builder)BoolKey.builder("TOOLBAR_HIDE_LABEL", "").setDefaultValue(false)).build();
    public static final BoolKey EDITOR_LINE_WRAP = ((BoolKey.Builder)BoolKey.builder("EDITOR_LINE_WRAP", "").setDefaultValue(true)).build();
    public static final BoolKey EDITOR_WHITESPACES = ((BoolKey.Builder)BoolKey.builder("EDITOR_WHITESPACES", "").setDefaultValue(false)).build();
    public static final BoolKey R_EDITOR_LINE_WRAP = ((BoolKey.Builder)BoolKey.builder("R_EDITOR_LINE_WRAP", "").setDefaultValue(true)).build();
    public static final BoolKey R_EDITOR_WHITESPACES = ((BoolKey.Builder)BoolKey.builder("R_EDITOR_WHITESPACES", "").setDefaultValue(false)).build();
    public static final BoolKey R_CODE_PARENS_AND_QUOTES = ((BoolKey.Builder)((BoolKey.Builder)BoolKey.builder("R_CODE_PARENS_AND_QUOTES", Messages.getString("Setting.insert_matching_brackets")).setDefaultValue(Boolean.TRUE)).setLabelPosition("none")).build();
    public static final BoolKey R_CODE_AUTO_INDENT = ((BoolKey.Builder)((BoolKey.Builder)BoolKey.builder("R_CODE_AUTO_INDENT", Messages.getString("Setting.auto_indent")).setDefaultValue(Boolean.TRUE)).setLabelPosition("none")).build();
    public static final BoolKey SHOW_HIDDEN_FILES = ((BoolKey.Builder)BoolKey.builder("SHOW_HIDDEN_FILES", "").setDefaultValue(false)).build();
    public static final BoolKey AUTO_DETECT_PACKAGES = ((BoolKey.Builder)BoolKey.builder("AUTO_DETECT_PACKAGES", "").setDefaultValue(true)).build();
    public static final BoolKey AUTO_ATTACH_CACHED_PACKAGES = ((BoolKey.Builder)BoolKey.builder("AUTO_ATTACH_CACHED_PACKAGES", "").setDefaultValue(true)).build();
    public static final StrKey CRAN_MIRROR = ((StrKey.Builder)StrKey.builder("CRAN_MIRROR", "").setDefaultValue("")).build();
    public static final IntKey APP_SERVER_PORT = ((IntKey.Builder)IntKey.builder("APP_SERVER_PORT", "").setDefaultValue(0)).build();
    public static final IntKey R_SERVER_PORT = ((IntKey.Builder)IntKey.builder("R_SERVER_PORT", "").setDefaultValue(0)).build();
    public static final BoolKey CREATE_R_SERVER = ((BoolKey.Builder)BoolKey.builder("CREATE_R_SERVER", "").setDefaultValue(true)).build();
    public static final StrKey PROJECT_R_RESTART = ((StrKey.Builder)StrKey.builder("PROJECT_R_RESTART", "").setDefaultValue("yes")).build();
    public static final BoolKey FIRST_GUIDE_NOTIFICATION = ((BoolKey.Builder)BoolKey.builder("FIRST_GUIDE_NOTIFICATION", "").setDefaultValue(true)).build();
    public static final StrKey CHECKED_VERSION = ((StrKey.Builder)StrKey.builder("CHECKED_VERSION", "").setDefaultValue(RflowVersion.get().toString())).build();
    public static final BoolKey IS_FIRST = ((BoolKey.Builder)BoolKey.builder("IS_FIRST", "").setDefaultValue(true)).build();
    @Deprecated
    public static final StrKey LAST_UPLOAD = ((StrKey.Builder)StrKey.builder("LAST_UPLOAD", "").setDefaultValue("")).build();
    public static final ListKey<Integer> WINDOW_SIZE = ListKey.builder("WINDOW_SIZE", "", IntKey.builder("size", "").build()).build();
    public static final ListKey<Integer> WINDOW_LOCATION = ListKey.builder("WINDOW_LOCATION", "", IntKey.builder("point", "").build()).build();
    public static final IntKey WINDOW_MAXIMIZED = ((IntKey.Builder)IntKey.builder("WINDOW_MAXIMIZED", "").setDefaultValue(0)).build();
    public static final DoubleKey SPLIT_MAIN = ((DoubleKey.Builder)DoubleKey.builder("SPLIT_MAIN", "").setDefaultValue(0.4)).build();
    public static final DoubleKey SPLIT_CONTROL = ((DoubleKey.Builder)DoubleKey.builder("SPLIT_CONTROL", "").setDefaultValue(0.64)).build();
    public static final DoubleKey SPLIT_FILE = ((DoubleKey.Builder)DoubleKey.builder("SPLIT_FILE", "").setDefaultValue(0.35)).build();
    public static final DoubleKey SPLIT_ROBJECT = ((DoubleKey.Builder)DoubleKey.builder("SPLIT_ROBJECT", "").setDefaultValue(0.35)).build();
    public static final BoolKey SHOW_HIERARCHY = ((BoolKey.Builder)BoolKey.builder("SHOW_HIERARCHY", "").setDefaultValue(false)).build();
    public static final IntKey HIERARCHY_SPLIT = ((IntKey.Builder)IntKey.builder("HIERARCHY_SPLIT", "").setDefaultValue(200)).build();
    public static final IntKey POSITION_HELP = ((IntKey.Builder)IntKey.builder("POSITION_HELP", "").setDefaultValue(1)).build();
    public static final IntKey POSITION_GD = ((IntKey.Builder)IntKey.builder("POSITION_GD", "").setDefaultValue(1)).build();
    public static final StrKey FILE_TREE_SORT = ((StrKey.Builder)StrKey.builder("FILE_TREE_SORT", "").setDefaultValue("type")).build();
    public static final StrKey ROBJECT_TREE_PRESENTATION = ((StrKey.Builder)StrKey.builder("ROBJECT_TREE_PRESENTATION", "").setDefaultValue("hierarchical")).build();
    public static final BoolKey RESTORE_SESSION = ((BoolKey.Builder)BoolKey.builder("RESTORE_SESSION", "").setDefaultValue(true)).build();
    public static final StrKey LOG_CONSOLE_LEVEL = ((StrKey.Builder)StrKey.builder("LOG_CONSOLE_LEVEL", "").setDefaultValue("")).build();
    public static final BoolKey PREVIEW_AUTO_REFRESH = ((BoolKey.Builder)BoolKey.builder("PREVIEW_AUTO_REFRESH", "").setDefaultValue(Boolean.TRUE)).build();
    public static final ValueMapKey GD_SETTINGS = ValueMapKey.builder("GD_SETTINGS", "", new GDSettings()).build();
    public static final StrKey JRI_PATH = ((StrKey.Builder)StrKey.builder("JRI_PATH", "").setDefaultValue("")).build();
    public static final BoolKey CHECK_ERROR = ((BoolKey.Builder)BoolKey.builder("CHECK_ERROR", "").setDefaultValue(true)).build();
    public static final BoolKey USE_GRID = ((BoolKey.Builder)BoolKey.builder("USE_GRID", "").setDefaultValue(true)).build();
    public static final IntKey GRID_DISTANCE2 = ((IntKey.Builder)IntKey.builder("GRID_DISTANCE2", "").setDefaultValue(10)).build();
    public static final BoolKey USE_CACHE_BACKUP = ((BoolKey.Builder)BoolKey.builder("USE_CACHE_BACKUP", "").setDefaultValue(true)).build();
    public static final StrKey CONSOLE_FONT_FAMILY = ((StrKey.Builder)StrKey.builder("CONSOLE_FONT_FAMILY", "").setDefaultValue("Monospaced")).build();
    public static final IntKey CONSOLE_FONT_SIZE = ((IntKey.Builder)IntKey.builder("CONSOLE_FONT_SIZE", "").setDefaultValue(12)).build();
    public static final DoubleKey CONSOLE_LINE_SPACING = ((DoubleKey.Builder)DoubleKey.builder("CONSOLE_LINE_SPACING", "").setDefaultValue(0.0)).build();
    public static final LongKey CONSOLE_NOTIFY_TIME = ((LongKey.Builder)LongKey.builder("CONSOLE_NOTIFY_TIME", "").setDefaultValue(1000L)).build();
    public static final StrKey FONT_FAMILY = ((StrKey.Builder)StrKey.builder("FONT_FAMILY", "").setDefaultValue("Dialog")).build();
    public static final IntKey FONT_SIZE = ((IntKey.Builder)IntKey.builder("FONT_SIZE", "").setDefaultValue(12)).build();
    public static final BoolKey AUTO_BACKUP = ((BoolKey.Builder)BoolKey.builder("AUTO_BACKUP", "").setDefaultValue(true)).build();
    public static final IntKey AUTO_BACKUP_INTERVAL = ((IntKey.Builder)IntKey.builder("AUTO_BACKUP_INTERVAL", "").setDefaultValue(10)).build();
    public static final IntKey BACKUP_SIZE = ((IntKey.Builder)IntKey.builder("BACKUP_SIZE", "").setDefaultValue(1024)).build();
    public static final IntKey MAX_PATH = ((IntKey.Builder)IntKey.builder("MAX_PATH", "").setDefaultValue(255)).build();
    public static final LongKey STACK_SIZE = ((LongKey.Builder)LongKey.builder("STACK_SIZE", "").setDefaultValue(0x1800000L)).build();
    public static final MapKey<String> OPEN_TYPES = MapKey.builder("OPEN_TYPES", "", ((StrKey.Builder)StrKey.builder("type", "").setDefaultValue("tab")).build()).build();

    public Settings() {
        this.registerAllKeys();
    }

    public Settings(OldSettings oldSettings) {
        this();
        this.setValues(oldSettings);
    }

    private void setValues(OldSettings oldSettings) {
        HashSet hashSet = Sets.newHashSet((Object[])OldSettings.Key.values());
        hashSet.remove(OldSettings.Key.UNVISIBLE_TABS);
        hashSet.remove(OldSettings.Key.EDITOR);
        hashSet.remove(OldSettings.Key.WINDOW_SIZE);
        hashSet.remove(OldSettings.Key.WINDOW_LOCATION);
        for (OldSettings.Key key : hashSet) {
            Key<?> key2 = this.getKey(key.getKeyString());
            if (key2 == null) continue;
            Object object = oldSettings.getProperty(key);
            if (object instanceof Float) {
                object = ((Float)object).doubleValue();
            }
            this.putValue(key2, object);
        }
        this.toStringList(oldSettings, OldSettings.Key.UNVISIBLE_TABS, INVISIBLE_TABS);
        this.toStringList(oldSettings, OldSettings.Key.EDITOR, EDITORS);
        this.toIntegerList(oldSettings, OldSettings.Key.WINDOW_SIZE, WINDOW_SIZE);
        this.toIntegerList(oldSettings, OldSettings.Key.WINDOW_LOCATION, WINDOW_LOCATION);
        GDSettings gDSettings = this.getGDSettings();
        try {
            gDSettings.setFixAspectRatio((Boolean)oldSettings.getProperty(OldSettings.Key.GD_CANVAS_FIX_ASPECT_RATIO));
            gDSettings.setFitCanvasSize((Boolean)oldSettings.getProperty(OldSettings.Key.GD_FIT_CANVASIZE));
            gDSettings.setSaveType((String)oldSettings.getProperty(OldSettings.Key.GD_SAVE_TYPE));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void toStringList(OldSettings oldSettings, OldSettings.Key key, ListKey<String> listKey) {
        String string = (String)oldSettings.getProperty(key);
        if (!string.isEmpty()) {
            Object[] objectArray = string.split("::");
            this.putValue(listKey, Lists.newArrayList((Object[])objectArray));
        }
    }

    private void toIntegerList(OldSettings oldSettings, OldSettings.Key key, ListKey<Integer> listKey) {
        String string2 = (String)oldSettings.getProperty(key);
        if (!string2.isEmpty()) {
            String[] stringArray = string2.split("::");
            try {
                this.putValue(listKey, Arrays.stream(stringArray).map(string -> Integer.valueOf(string)).collect(Collectors.toList()));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public boolean fileExists() {
        File file = UserFolder.getUserSettings();
        if (file.exists()) {
            return true;
        }
        if (!file.equals(UserFolder.getDefaultUserSettings())) {
            return false;
        }
        File file2 = UserFolder.getOldUserSettings();
        return file2.exists();
    }

    public void load() throws IOException {
        File file;
        File file2 = UserFolder.getUserSettings();
        if (file2.exists()) {
            this.loadFromYaml(file2);
        } else if (file2.equals(UserFolder.getDefaultUserSettings()) && (file = UserFolder.getOldUserSettings()).exists()) {
            OldSettings oldSettings = OldSettings.defaultSetting();
            PropertiesUtility.load(oldSettings, file);
            this.setValues(oldSettings);
        }
        if (RflowVersion.get().isNewerThan(this.getValue(CHECKED_VERSION))) {
            this.putValue(CHECKED_VERSION, RflowVersion.get().toString());
        }
    }

    public void save() throws IOException {
        this.storeToYaml(UserFolder.getUserSettings());
    }

    public GDSettings getGDSettings() {
        return (GDSettings)this.getValue(GD_SETTINGS);
    }

    public String getFileOpenType(Path path) {
        String string = FilenameUtils.getExtension((String)path.getFileName().toString());
        return (String)((Map)((Object)this.getValue(OPEN_TYPES))).get(string);
    }

    public void setFileOpenType(Path path, String string) {
        String string2 = FilenameUtils.getExtension((String)path.getFileName().toString());
        ((Map)((Object)this.getValue(OPEN_TYPES))).put(string2, string);
    }

    public boolean isOpenModeCurrentTab() {
        return this.getValue(NODE_OPEN_MODE).equals(NODE_OPEN_MODE_CURRENT_TAB);
    }

    public Level getLogConsoleLevel() {
        try {
            return Level.parse(this.getValue(LOG_CONSOLE_LEVEL));
        }
        catch (Exception exception) {
            return Level.OFF;
        }
    }

    public File getDefaultWorkingDir() {
        return new File(this.getValue(DEFAULT_WORKING_DIRECTORY));
    }

    public Double getRatio(DoubleKey doubleKey) {
        Double d = this.getValue(doubleKey);
        if (d < 0.0 || d > 1.0) {
            return (Double)doubleKey.getDefaultValue();
        }
        return d;
    }

    public void setUpDefaults() {
        List<String[]> list;
        this.putValue(DEFAULT_WORKING_DIRECTORY, UserFolder.getUserWorkingDir().getAbsolutePath());
        this.putValue(IS_AUTO_UPDATE, Boolean.TRUE);
        String string = this.getValue(CRAN_MIRROR);
        if (string.isEmpty() && (list = RSupport.getCranMirrors(System.getenv("R_HOME"))) != null) {
            String string2 = string = list.isEmpty() ? null : list.get(0)[1];
            if (string != null) {
                this.putValue(CRAN_MIRROR, string);
            }
        }
    }

    public Locale getLocale() {
        String string = this.getValue(LANGUAGE);
        if (string.equals("system")) {
            return Locale.getDefault();
        }
        return new Locale(string);
    }

    public static Settings defaultSetting() {
        return new Settings();
    }

    public boolean checkRestartRequired(Settings settings) {
        Key[] keyArray;
        for (Key key : keyArray = new Key[]{R_HOME, R_OPTIONS, CRAN_MIRROR, LANGUAGE}) {
            Object v;
            Object v2 = this.getValue(key);
            if (v2.equals(v = settings.getValue(key))) continue;
            return true;
        }
        return false;
    }

    public void setPropertyAll(Settings settings) {
        for (Map.Entry<Key<?>, Object> entry : settings.entrySet()) {
            Key<?> key = entry.getKey();
            Object object = entry.getValue();
            object = object == null ? null : key.copyValue(object);
            this.putValue(key, object);
        }
    }

    public String logValue() {
        YamlEx yamlEx = new YamlEx();
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        for (Map.Entry<Key<?>, Object> entry : this.entrySet()) {
            Object object;
            Key<?> key = entry.getKey();
            if (key.isNoSave() || key == DEFAULT_WORKING_DIRECTORY || key == R_HOME || key == EDITORS || (object = entry.getValue()) == null) continue;
            linkedHashMap.put(key.getId(), key.valueToYamlValue(yamlEx, object, false));
        }
        StringWriter stringWriter = new StringWriter();
        yamlEx.dump(linkedHashMap, stringWriter);
        return stringWriter.toString();
    }
}

