/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.base;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.core.base.FileResource;
import com.ef_prime.rflow.core.base.RflowVersion;
import com.ef_prime.rflow.core.base.Settings;
import com.ef_prime.rflow.core.util.Version;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.app.file.FileUIUtility;
import com.ef_prime.rflow.ui.util.UIUtility;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import javax.swing.border.EmptyBorder;

public class UpdateChecker {
    private static final Logger LOGGER = Logger.getLogger(UpdateChecker.class.getName());
    private static final String UPDATE_SITE = "http://www.ef-prime.com/ranalyticflow/update_check";

    public static void updateCheck() {
        new UpdateCheckWorker().execute();
    }

    private static void showDialog(final Settings settings, List<String> list) {
        final JDialog jDialog = new JDialog(Rflow.mainFrame(), Messages.getString("UpdateChecker.title"), false);
        jDialog.setDefaultCloseOperation(2);
        final String string = UpdateChecker.getVersion(list.get(0));
        final UpdateConfirmPanel updateConfirmPanel = new UpdateConfirmPanel(string, UpdateChecker.getURL(list.get(0)));
        jDialog.getContentPane().add(updateConfirmPanel);
        updateConfirmPanel.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.setVisible(false);
                jDialog.dispose();
            }
        });
        jDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                if (updateConfirmPanel.jCheckBox1.isSelected()) {
                    settings.putValue(Settings.CHECKED_VERSION, string);
                    try {
                        settings.save();
                    }
                    catch (Exception exception) {
                        LOGGER.log(Level.SEVERE, "Failed to save settings file.", exception);
                    }
                }
            }
        });
        jDialog.setIconImage(FileResource.getIcon("img/desktop_16.png").getImage());
        jDialog.pack();
        jDialog.setLocationRelativeTo(Rflow.mainFrame());
        updateConfirmPanel.jButton1.requestFocusInWindow();
        jDialog.setVisible(true);
    }

    private static String getVersion(String string) throws RuntimeException {
        return string.split(",")[0];
    }

    private static String getURL(String string) throws RuntimeException {
        return string.split(",")[1];
    }

    /*
     * Exception decompiling
     */
    private static List<String> getTextFromServer() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String userAgent() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("R AnalyticFlow/");
        stringBuilder.append(RflowVersion.get().toString());
        stringBuilder.append(";Java ");
        stringBuilder.append(System.getProperty("java.vendor", ""));
        stringBuilder.append("/");
        stringBuilder.append(System.getProperty("java.version", ""));
        stringBuilder.append(";");
        stringBuilder.append(System.getProperty("os.name", ""));
        stringBuilder.append("/");
        stringBuilder.append(System.getProperty("os.version", ""));
        return stringBuilder.toString();
    }

    private static boolean existsUpdate(List<String> list, Settings settings) {
        try {
            String string = list.get(0);
            String string2 = string.split(",")[0];
            return Version.isNewer(settings.getValue(Settings.CHECKED_VERSION), string2);
        }
        catch (RuntimeException runtimeException) {
            LOGGER.log(Level.SEVERE, "Failed to checking version.", runtimeException);
            return false;
        }
    }

    private static class UpdateCheckWorker
    extends SwingWorker<List<String>, Void> {
        private UpdateCheckWorker() {
        }

        @Override
        protected List<String> doInBackground() throws Exception {
            return UpdateChecker.getTextFromServer();
        }

        @Override
        protected void done() {
            try {
                List list = (List)this.get();
                if (list.isEmpty()) {
                    return;
                }
                if ("true".equals(System.getProperty("update.check")) || UpdateChecker.existsUpdate(list, Rflow.settings())) {
                    UpdateChecker.showDialog(Rflow.settings(), list);
                }
            }
            catch (InterruptedException | ExecutionException exception) {
                LOGGER.log(Level.WARNING, "Exception while checking update.", exception);
            }
        }
    }

    private static class UpdateConfirmPanel
    extends JPanel {
        public JButton jButton1;
        public JCheckBox jCheckBox1;
        private JLabel jLabel1;
        private JLabel jLabel2;
        private JLabel jLabel3;
        private JLabel jLabel4;

        public UpdateConfirmPanel(String string, String string2) {
            this.initComponents(string, string2);
        }

        private void initComponents(String string, String string2) {
            this.jLabel1 = new URILabel(string2);
            this.jCheckBox1 = new JCheckBox();
            this.jButton1 = new JButton();
            this.jLabel2 = new JLabel();
            this.jLabel3 = new JLabel();
            this.jLabel4 = new JLabel();
            this.setName("Form");
            this.jLabel1.setName("jLabel1");
            this.jCheckBox1.setText(Messages.getString("UpdateChecker.not_check"));
            this.jCheckBox1.setName("jCheckBox1");
            this.jButton1.setText(Messages.getString("Button.close"));
            this.jButton1.setName("jButton1");
            this.jLabel2.setFont(this.jLabel2.getFont().deriveFont(this.jLabel2.getFont().getStyle() | 1, 16.0f));
            this.jLabel2.setText(Messages.getString("UpdateChecker.update_available"));
            this.jLabel2.setName("jLabel2");
            this.jLabel3.setText(Messages.getString("UpdateChecker.version") + string + Messages.getString("UpdateChecker.released"));
            this.jLabel3.setName("jLabel3");
            this.jLabel4.setText(Messages.getString("UpdateChecker.can_download_from_website_below"));
            this.jLabel4.setName("jLabel4");
            this.jLabel2.setFont(this.jLabel2.getFont().deriveFont(this.jLabel2.getFont().getStyle() | 1, 16.0f));
            this.setLayout(new BoxLayout(this, 1));
            this.setBorder(new EmptyBorder(10, 10, 10, 10));
            this.add(UIUtility.createHorizontalBox(this.jLabel2, -1));
            this.add(Box.createVerticalStrut(10));
            this.add(UIUtility.createHorizontalBox(this.jLabel3, -1));
            this.add(Box.createVerticalStrut(5));
            this.add(UIUtility.createHorizontalBox(this.jLabel4, -1));
            this.add(Box.createVerticalStrut(10));
            this.add(UIUtility.createHorizontalBox(this.jLabel1, -1));
            this.add(Box.createVerticalStrut(10));
            this.add(UIUtility.createHorizontalBox(this.jCheckBox1, -1, this.jButton1));
        }
    }

    private static class URILabel
    extends JLabel {
        public URILabel(final String string) {
            super("<html><a href='" + string + "'>" + string + "</a>");
            this.setCursor(new Cursor(12));
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    FileUIUtility.browse(Rflow.mainFrame(), string);
                }
            });
        }
    }
}

