/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.base;

import com.ef_prime.rflow.core.app.file.FileUtility;
import com.ef_prime.rflow.core.base.RflowVersion;
import com.ef_prime.rflow.core.util.Platform;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.util.UIUtility;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileSystemView;
import org.apache.commons.io.FileUtils;

public class UserFolder {
    private static final String FOLDER_RANALYICFLOW = "RAnalyticFlow";
    private static final String FOLDER_DOT_RANALYICFLOW = ".ranalyticflow";
    private static File userDir;
    private static boolean isTempUserDir;
    private static File userSettings;

    public static void setUserDir(String string) {
        File file = new File(string, RflowVersion.get().getVersionMajor());
        if ((file = UserFolder.checkUserDir(file)) != null) {
            userDir = file;
        }
    }

    public static void setUserSettings(String string) {
        File file = new File(string);
        userSettings = file.isAbsolute() ? file : UserFolder.getUserDirFile(string);
    }

    public static File getUserSettings() {
        if (userSettings == null) {
            userSettings = UserFolder.getDefaultUserSettings();
        }
        return userSettings;
    }

    public static File getDefaultUserSettings() {
        return UserFolder.getUserDirFile("settings.yaml");
    }

    public static File getOldUserSettings() {
        return UserFolder.getUserDirFile("rflow.settings");
    }

    private static File checkUserDir(File file) {
        if (file.exists() || file.mkdirs()) {
            return file;
        }
        File file2 = null;
        try {
            Path path = Files.createTempDirectory("rflowuser", new FileAttribute[0]);
            file2 = new File(path.toFile(), RflowVersion.get().getVersionMajor());
            file2.mkdirs();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (file2 != null && file2.exists()) {
            int n = JOptionPane.showConfirmDialog(null, Messages.getString("Error.file.create_folder") + ":\n" + file.getAbsolutePath() + "\n\n" + Messages.getString("Error.no_user_home"), Messages.getString("Error.title.error"), 2, 0);
            if (n != 0) {
                return null;
            }
            isTempUserDir = true;
            return file2;
        }
        UIUtility.showErrorDialog(null, Messages.getString("Error.file.create_folder") + ":\n" + file.getAbsolutePath());
        return null;
    }

    public static File getUserDir() {
        return UserFolder.getUserDirWithVersion().getParentFile();
    }

    public static File getUserDirWithVersion() {
        if (userDir == null) {
            File file = null;
            File file2 = new File(System.getProperty("user.home"));
            switch (Platform.getPlatform()) {
                case WINDOWS: {
                    file = new File(file2, "Application Data" + File.separator + FOLDER_RANALYICFLOW);
                    break;
                }
                case WINDOWS6: {
                    file = new File(file2, "AppData" + File.separator + "Roaming" + File.separator + FOLDER_RANALYICFLOW);
                    break;
                }
                default: {
                    file = new File(file2, FOLDER_DOT_RANALYICFLOW);
                }
            }
            File file3 = new File(file, RflowVersion.get().getVersionMajor());
            file3 = UserFolder.checkUserDir(file3);
            if (file3 == null) {
                System.exit(1);
            }
            userDir = file3;
        }
        return userDir;
    }

    public static File getUserWorkingDir() {
        return new File(UserFolder.getUserDocumentsDir(), FOLDER_RANALYICFLOW);
    }

    public static File getUserDocumentsDir() {
        String string = FileSystemView.getFileSystemView().getDefaultDirectory().getPath();
        String string2 = System.getProperty("user.home");
        switch (Platform.getPlatform()) {
            case WINDOWS: {
                return new File(string2, "My Documents");
            }
            case MAC: {
                return new File(string2, "Documents");
            }
            case WINDOWS6: {
                return new File(string);
            }
        }
        return new File(string2);
    }

    public static File getTempDir() {
        return UserFolder.getUserDirFile("tmp");
    }

    public static File getLogDir() {
        return UserFolder.getUserDirFile("log");
    }

    public static File getCustomUIDir() {
        return UserFolder.getUserDirFile("custom_ui");
    }

    public static File getUserDirFile(String string) {
        return new File(UserFolder.getUserDirWithVersion(), string);
    }

    public static void clearTempDirs() {
        FileUtils.deleteQuietly((File)UserFolder.getTempDir());
        if (isTempUserDir) {
            File file = UserFolder.getUserDir();
            if (FileUtility.isChild(FileUtils.getTempDirectory(), file)) {
                FileUtils.deleteQuietly((File)file);
            }
        }
    }
}

