/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.base;

import com.ef_prime.rflow.core.base.Project;
import com.ef_prime.rflow.core.base.RflowEventHandler;
import com.ef_prime.rflow.core.base.UserFolder;
import com.ef_prime.rflow.core.common.xml.XmlUtility;
import com.ef_prime.rflow.core.util.YamlEx;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.w3c.dom.Element;

public class UserProjectFolderManager
implements RflowEventHandler {
    private static final Logger LOGGER = Logger.getLogger(UserProjectFolderManager.class.getName());
    private static final UserProjectFolderManager instance = new UserProjectFolderManager();
    private static final String DIR_USER_PROJECT = "project";
    private static final File FILE_FOLDER = UserFolder.getUserDirFile("project/folder.xml");
    private static final File FILE_YAML_FOLDER = UserFolder.getUserDirFile("project/folder.yaml");
    private Map<String, String> map = null;
    private Multimap<String, ProjectEntry> idMap = null;

    private UserProjectFolderManager() {
    }

    public static UserProjectFolderManager getInstance() {
        return instance;
    }

    private void loadMap() {
        if (this.map == null) {
            try {
                this.load();
            }
            catch (IOException iOException) {
                LOGGER.log(Level.SEVERE, "Failed to load project folders map.", iOException);
            }
        }
    }

    private static String pathForKey(File file) {
        return FilenameUtils.separatorsToUnix((String)file.getAbsolutePath());
    }

    private static String getProjectKey(Project project) {
        return project.getId() + ";" + UserProjectFolderManager.pathForKey(project.getLocation());
    }

    public String getFolder(Project project) {
        Object object;
        this.loadMap();
        String string = UserProjectFolderManager.getProjectKey(project);
        String string2 = this.map.get(string);
        if (string2 != null) {
            return string2;
        }
        ProjectEntry projectEntry = null;
        Collection collection = this.idMap.get((Object)project.getId());
        if (!collection.isEmpty()) {
            if (collection.size() == 1) {
                projectEntry = (ProjectEntry)collection.iterator().next();
            } else {
                object = new ArrayList(collection);
                Collections.sort(object);
                projectEntry = (ProjectEntry)object.get(object.size() - 1);
            }
        }
        object = project.getLocation().getName();
        File file = UserFolder.getUserDirFile("project/" + (String)object);
        int n = 0;
        while (file.exists() || !file.mkdirs()) {
            file = UserFolder.getUserDirFile("project/" + (String)object + ++n);
            if (n <= 2000) continue;
        }
        this.map.put(string, file.getName());
        try {
            this.store();
        }
        catch (IOException iOException) {
            LOGGER.log(Level.SEVERE, "Failed to save project folders map.", iOException);
        }
        if (projectEntry != null) {
            File file2 = new File(UserFolder.getUserDirFile(DIR_USER_PROJECT), projectEntry.getFolder());
            try {
                FileUtils.copyDirectory((File)file2, (File)file);
            }
            catch (IOException iOException) {
                LOGGER.log(Level.SEVERE, "Failed to copy user project folder.", iOException);
            }
        }
        return file.getName();
    }

    public void remove(File file) {
        String string = UserProjectFolderManager.pathForKey(file);
        Collection collection = this.idMap.values();
        List list = collection.stream().filter(projectEntry -> string.equals(projectEntry.getPath())).collect(Collectors.toList());
        if (!list.isEmpty()) {
            list.stream().forEach(projectEntry -> {
                this.map.remove(projectEntry.getKey());
                this.idMap.remove((Object)projectEntry.getId(), projectEntry);
                FileUtils.deleteQuietly((File)projectEntry.getUserProjectFolder().toFile());
            });
            try {
                this.store();
            }
            catch (IOException iOException) {
                LOGGER.log(Level.SEVERE, "Failed to save project folders map.", iOException);
            }
        }
    }

    private void store() throws IOException {
        new YamlEx().dump(FILE_YAML_FOLDER, this.map);
    }

    private void load() throws IOException {
        String string;
        Object object;
        String[] stringArray;
        this.map = new HashMap<String, String>();
        this.idMap = HashMultimap.create();
        if (FILE_YAML_FOLDER.exists()) {
            var1_1 = new YamlEx().load(FILE_YAML_FOLDER);
            entry = (Map)YamlEx.typeCheck(Map.class, var1_1);
            this.map.putAll((Map<String, String>)((Object)entry));
        } else if (FILE_FOLDER.exists()) {
            var1_1 = XmlUtility.readXml(FILE_FOLDER);
            entry = XmlUtility.getChildren("entry", var1_1.getDocumentElement());
            stringArray = entry.iterator();
            while (stringArray.hasNext()) {
                object = (Element)stringArray.next();
                string = object.getAttribute("key");
                String string2 = object.getAttribute("name");
                this.map.put(string, string2);
            }
        }
        for (Map.Entry<String, String> entry : this.map.entrySet()) {
            stringArray = entry.getKey().split(";", 2);
            if (stringArray.length != 2) continue;
            object = stringArray[0];
            string = stringArray[1];
            this.idMap.put(object, (Object)new ProjectEntry((String)object, string, entry.getValue()));
        }
    }

    @Override
    public void rflowWillShutdown() {
        try {
            Collection collection = this.idMap.values();
            Calendar calendar = Calendar.getInstance();
            calendar.add(2, -1);
            long l = calendar.getTimeInMillis();
            int n = this.map.size();
            for (ProjectEntry projectEntry : collection) {
                Path path = Paths.get(projectEntry.getPath(), new String[0]);
                if (Files.exists(path, new LinkOption[0])) continue;
                if (!Files.exists(projectEntry.getUserProjectFolder(), new LinkOption[0])) {
                    this.map.remove(projectEntry.getKey());
                    continue;
                }
                if (projectEntry.getLastModified() <= 0L || projectEntry.getLastModified() >= l || !FileUtils.deleteQuietly((File)projectEntry.getUserProjectFolder().toFile())) continue;
                this.map.remove(projectEntry.getKey());
            }
            if (n != this.map.size()) {
                this.store();
            }
        }
        catch (Throwable throwable) {
            LOGGER.log(Level.WARNING, "Exception while cleaning up user project folder list", throwable);
        }
    }

    @Override
    public void rflowProjectDidStart() {
    }

    @Override
    public void rflowProjectWillEnd() {
    }

    private static class ProjectEntry
    implements Comparable<ProjectEntry> {
        private String id;
        private String path;
        private String folder;
        private long lastModified = -1L;

        public ProjectEntry(String string, String string2, String string3) {
            this.id = string;
            this.path = string2;
            this.folder = string3;
        }

        public String getId() {
            return this.id;
        }

        public String getPath() {
            return this.path;
        }

        public String getFolder() {
            return this.folder;
        }

        public String getKey() {
            return this.id + ";" + this.path;
        }

        public Path getUserProjectFolder() {
            return UserFolder.getUserDirFile(UserProjectFolderManager.DIR_USER_PROJECT).toPath().resolve(this.folder);
        }

        private long getLastModified() {
            if (this.lastModified < 0L) {
                try {
                    this.lastModified = Files.getLastModifiedTime(this.getUserProjectFolder(), new LinkOption[0]).toMillis();
                }
                catch (Exception exception) {
                    this.lastModified = 0L;
                }
            }
            return this.lastModified;
        }

        @Override
        public int compareTo(ProjectEntry projectEntry) {
            return Long.compare(this.getLastModified(), projectEntry.getLastModified());
        }
    }
}

