/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.base;

import com.ef_prime.rflow.core.app.file.FileUtility;
import com.ef_prime.rflow.core.app.r.base.R;
import com.ef_prime.rflow.core.app.r.base.RUtility;
import com.ef_prime.rflow.core.common.util.Utility;
import com.ef_prime.rflow.core.util.OSUtility;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.nio.file.Path;
import org.apache.commons.io.FilenameUtils;

public class WorkingDirectory {
    public static final String PROPERTY_WORKING_DIRECTORY = "WORKING_DIRECTORY";
    private static File workingDirectory = new File(Utility.PROGRAM_DIR);
    private static PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(new Object());

    public static boolean setWorkingDirectory(File file) {
        if (file == null) {
            return true;
        }
        if (!(file = WorkingDirectory.toAbsolutePath(file)).exists() || !file.isDirectory()) {
            return false;
        }
        boolean bl = !R.client().isEmbedded() && !R.client().isConnected() ? true : WorkingDirectory.setRWorkingDirectory(file);
        if (bl && !file.equals(workingDirectory)) {
            File file2 = workingDirectory;
            workingDirectory = file;
            String string = workingDirectory.getAbsolutePath();
            if (!R.client().isEmbedded()) {
                OSUtility.setCurrentDirectory(string);
            }
            System.setProperty("user.dir", string);
            propertyChangeSupport.firePropertyChange(PROPERTY_WORKING_DIRECTORY, file2, workingDirectory);
        }
        return bl;
    }

    public static boolean setRWorkingDirectory(File file) {
        String string = RUtility.path(file.getAbsolutePath());
        return R.client().setWD(string);
    }

    public static File getWorkingDirectory() {
        return workingDirectory;
    }

    public static File toAbstractPath(File file) {
        return FileUtility.makeAbstractPath(WorkingDirectory.getWorkingDirectory(), file);
    }

    public static String toAbsolutePath(String string) {
        if (FilenameUtils.getPrefix((String)string).isEmpty()) {
            return FilenameUtils.separatorsToUnix((String)new File(workingDirectory, string).getAbsolutePath());
        }
        return string;
    }

    public static File toAbsolutePath(File file) {
        if (!file.isAbsolute()) {
            return new File(workingDirectory, file.getPath());
        }
        return file;
    }

    public static Path toAbsolutePath(Path path) {
        if (!path.isAbsolute()) {
            return workingDirectory.toPath().resolve(path);
        }
        return path;
    }

    public static void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public static void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }
}

