/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.common.keyvalue;

import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.keyvalue.KeyLink;
import com.ef_prime.rflow.core.common.keyvalue.KeyTest;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;

public abstract class BasicKeyTest
implements KeyTest {
    private String id;
    private boolean checkEnabled;
    private Key<?> key;

    public BasicKeyTest(String string, boolean bl) {
        this.id = string;
        this.checkEnabled = bl;
    }

    private Key<?> getKey(ValueMap valueMap) {
        if (this.key == null) {
            this.key = valueMap.getKey(this.id);
        }
        return this.key;
    }

    @Override
    public boolean contains(ValueMap valueMap, String string) {
        if (!this.checkEnabled) {
            return this.id.equals(string);
        }
        if (this.id.equals(string)) {
            return true;
        }
        Key<?> key = this.getKey(valueMap);
        if (key != null && key.isKeyLink()) {
            for (KeyLink keyLink : key.getKeyLinks()) {
                if (!keyLink.contains(valueMap, string)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean accept(ValueMap valueMap) {
        Key<?> key = this.getKey(valueMap);
        if (key == null) {
            return false;
        }
        if (this.checkEnabled && !valueMap.isEnabled(key)) {
            return this.disabled();
        }
        return this.test(valueMap, key);
    }

    protected abstract boolean disabled();

    protected abstract boolean test(ValueMap var1, Key<?> var2);

    public void setValue(ValueMap valueMap, boolean bl) {
        this.setValue(valueMap, this.key, bl);
    }

    protected abstract void setValue(ValueMap var1, Key<?> var2, boolean var3);
}

