/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.common.keyvalue;

import com.ef_prime.rflow.core.common.keyvalue.AtomicKey;
import com.ef_prime.rflow.core.common.keyvalue.Key;
import java.util.List;
import java.util.Map;

public class BoolKey
extends AtomicKey<Boolean> {
    private String text;

    public BoolKey(String string, boolean bl) {
        super(string, bl);
    }

    public BoolKey(String string, String string2, boolean bl) {
        super(string, string2, bl);
    }

    protected BoolKey(Builder<?> builder) {
        super(builder);
        this.text = builder.text;
    }

    public static Builder<?> builder(String string, String string2) {
        return new Builder2(string, string2);
    }

    public String getText() {
        return this.text;
    }

    @Override
    protected String getYamlType() {
        return "bool";
    }

    @Override
    public Object stringToValue(String string) {
        return Boolean.valueOf(string);
    }

    @Override
    public String valueToString(Object object) {
        return ((Boolean)object).toString();
    }

    @Override
    public Boolean copyValue(Boolean bl) {
        return bl;
    }

    @Override
    public Class<?> getJavaClass() {
        return Boolean.class;
    }

    @Override
    public void localizationValues(List<String> list) {
        super.localizationValues(list);
        list.add(this.text);
    }

    @Override
    public void localize(Map<String, String> map) {
        super.localize(map);
        this.text = BoolKey.valueOrDefault(map, this.text);
    }

    public static abstract class Builder<T extends Builder<T>>
    extends Key.Builder<Boolean, T> {
        private String text;

        public Builder(String string, String string2) {
            super(string, string2);
            this.setDefaultValue(false);
        }

        @Override
        protected abstract T self();

        public T setText(String string) {
            this.text = string;
            return (T)this.self();
        }

        public BoolKey build() {
            return new BoolKey(this);
        }
    }

    private static class Builder2
    extends Builder<Builder2> {
        public Builder2(String string, String string2) {
            super(string, string2);
        }

        @Override
        protected Builder2 self() {
            return this;
        }
    }
}

