/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.common.keyvalue;

import com.ef_prime.rflow.core.common.keyvalue.BatchAddSupport;
import com.ef_prime.rflow.core.common.keyvalue.BoolKey;
import com.ef_prime.rflow.core.common.keyvalue.Choice;
import com.ef_prime.rflow.core.common.keyvalue.ChoiceKey;
import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.keyvalue.StrKey;
import com.ef_prime.rflow.core.common.keyvalue.TableKey;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.core.common.table.GeneralTableModel;
import com.ef_prime.rflow.core.common.table.KeysTableModel;
import com.ef_prime.rflow.core.common.table.KeysTableRow;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class ChoiceBatchAddSupport
implements BatchAddSupport<String> {
    private ChoiceKey key;

    public ChoiceBatchAddSupport(ChoiceKey choiceKey) {
        this.key = choiceKey;
    }

    @Override
    public List<String> getList(ValueMap valueMap) {
        List<Choice> list = this.key.getChoices(valueMap);
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (Choice choice : list) {
            arrayList.add(choice.getValue());
        }
        return Lists.newArrayList(arrayList);
    }

    @Override
    public ValueMap getViewModel(List<String> list) {
        return new ViewModel(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(List<String> list, Key<?> key, ValueMap valueMap) {
        KeysTableModel keysTableModel = valueMap.getValue((TableKey)key);
        HashSet<String> hashSet = new HashSet<String>(keysTableModel.getValues(this.key));
        int n = keysTableModel.getColumnIndex(this.key);
        keysTableModel.beginValueChange();
        try {
            for (String string : list) {
                if (hashSet.contains(string)) continue;
                KeysTableRow keysTableRow = (KeysTableRow)keysTableModel.getDefaultRow();
                keysTableRow.setValue(string, n);
                keysTableModel.addRow(keysTableRow);
            }
        }
        finally {
            keysTableModel.endValueChange();
        }
    }

    @Override
    public List<String> getSelections(ValueMap valueMap) {
        return ((ViewModel)valueMap).asList();
    }

    protected static class ViewModel
    extends ValueMap {
        private static final BoolKey COL_ENABLED = BoolKey.builder("enabled", " ").build();
        private static final StrKey COL_VALUE = ((StrKey.Builder)StrKey.builder("value", "Value").setEditable(false)).build();
        private static final TableKey KEY_TABLE = ((TableKey.Builder)((Key.Builder)((TableKey.Builder)((TableKey.Builder)((TableKey.Builder)TableKey.builder("table", "Table", COL_ENABLED, COL_VALUE).setFixedColumnWidth(0, 30)).setUiControls(GeneralTableModel.UI_SELECTION)).setHideHeader(true)).setUnboundTableArea(false)).setLabelPosition("none")).build();

        public ViewModel(List<String> list) {
            this.registerKeys(this.getTableKey());
            KeysTableModel keysTableModel = this.getValue(this.getTableKey());
            for (String string : list) {
                keysTableModel.insertNewRow(keysTableModel.getRowCount(), Boolean.FALSE, string);
            }
        }

        protected TableKey getTableKey() {
            return KEY_TABLE;
        }

        public List<String> asList() {
            ArrayList<String> arrayList = new ArrayList<String>();
            KeysTableModel keysTableModel = this.getValue(this.getTableKey());
            for (KeysTableRow keysTableRow : keysTableModel) {
                Boolean bl = (Boolean)keysTableRow.getValue(0);
                if (!bl.booleanValue()) continue;
                arrayList.add((String)keysTableRow.getValue(1));
            }
            return arrayList;
        }
    }
}

