/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.common.keyvalue;

import com.ef_prime.rflow.core.common.keyvalue.BatchAddSupport;
import com.ef_prime.rflow.core.common.keyvalue.Choice;
import com.ef_prime.rflow.core.common.keyvalue.ChoiceBatchAddSupport;
import com.ef_prime.rflow.core.common.keyvalue.ChoiceProvider;
import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.keyvalue.StrKey;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.core.util.YamlEx;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ChoiceKey
extends StrKey {
    protected List<Choice> choices;
    protected boolean showValueAndLabel;
    protected boolean choiceEditable;
    protected ChoiceProvider choiceProvider;
    protected Map<String, String> requiredRPackageMap;
    private Map<String, String> templateMap;
    private Map<String, Integer> valueToIndexMap;
    private Boolean isLabel;
    private Boolean isDescription;
    private Map<String, String> labelToValueMap;

    public ChoiceKey(String string, String string2, String string3, boolean bl, String[] stringArray) {
        this(string, string2, string3, bl, stringArray, null, false);
    }

    public ChoiceKey(String string, String string2, String string3, boolean bl, String[] stringArray, String[] stringArray2, boolean bl2) {
        super(string, string2, string3);
        this.choiceEditable = bl;
        this.choices = ChoiceKey.toChoices(stringArray, stringArray2);
        this.showValueAndLabel = bl2;
    }

    public ChoiceKey(Map<?, ?> map) {
        super(map);
        List list;
        List list2;
        String[] stringArray = null;
        String[] stringArray2 = null;
        List list3 = (List)YamlEx.typeCheck(List.class, map.get("values"));
        if (list3 != null) {
            stringArray = list3.toArray(new String[0]);
        }
        if ((list2 = (List)YamlEx.typeCheck(List.class, map.get("labels"))) != null) {
            stringArray2 = list2.toArray(new String[0]);
        }
        if (stringArray != null) {
            this.choices = ChoiceKey.toChoices(stringArray, stringArray2);
        }
        if ((list = (List)YamlEx.typeCheck(List.class, map.get("choices"))) != null) {
            this.choices = new ArrayList<Choice>(list.size());
            for (int i = 0; i < list.size(); ++i) {
                Choice choice = new Choice();
                choice.loadYamlValue(null, list.get(i));
                this.choices.add(choice);
            }
        }
        this.showValueAndLabel = ChoiceKey.yamlValue(this.showValueAndLabel, Boolean.class, "value-and-label", map);
        this.choiceEditable = ChoiceKey.yamlValue(this.choiceEditable, Boolean.class, "input", map);
    }

    protected ChoiceKey(Builder<?> builder) {
        super((StrKey.Builder<?>)builder);
        this.choices = builder.choices;
        this.showValueAndLabel = builder.showValueAndLabel;
        this.choiceEditable = builder.choiceEditable;
        this.templateMap = builder.templateMap;
        this.choiceProvider = builder.choiceProvider;
        this.requiredRPackageMap = builder.requiredRPackageMap;
        if (!this.isChoiceEditable() && this.choices != null && this.choices.size() > 0 && this.defaultValue != null && ((String)this.defaultValue).isEmpty()) {
            this.defaultValue = this.choices.get(0).getValue();
        }
    }

    public static Builder<?> builder(String string, String string2) {
        return new Builder2(string, string2);
    }

    private static List<Choice> toChoices(String[] stringArray, String[] stringArray2) {
        if (stringArray == null) {
            return null;
        }
        ArrayList<Choice> arrayList = new ArrayList<Choice>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray2 != null ? stringArray2[i] : null;
            arrayList.add(new Choice(stringArray[i], string));
        }
        return arrayList;
    }

    @Override
    protected String getYamlType() {
        return "choice";
    }

    public List<Choice> getChoices(ValueMap valueMap) {
        if (this.choiceProvider != null) {
            return this.choiceProvider.getChoices(valueMap);
        }
        return this.choices;
    }

    public String[] getValues(ValueMap valueMap) {
        List<Choice> list = this.getChoices(valueMap);
        String[] stringArray = new String[list.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = list.get(i).getValue();
        }
        return stringArray;
    }

    public boolean isLabel() {
        if (this.choiceProvider != null) {
            return this.choiceProvider.isLabel();
        }
        if (this.isLabel == null) {
            this.isLabel = false;
            for (Choice choice : this.choices) {
                if (!choice.isLabel()) continue;
                this.isLabel = true;
                break;
            }
        }
        return this.isLabel;
    }

    public Boolean isDescription() {
        if (this.choiceProvider != null) {
            return this.choiceProvider.isDescription();
        }
        if (this.isDescription == null) {
            this.isDescription = false;
            for (Choice choice : this.choices) {
                if (!choice.isDescription()) continue;
                this.isDescription = true;
                break;
            }
        }
        return this.isDescription;
    }

    public boolean showValueAndLabel() {
        return this.showValueAndLabel;
    }

    protected boolean isDynamic() {
        return this.choiceProvider != null;
    }

    public ChoiceProvider getChoiceProvider() {
        return this.choiceProvider;
    }

    public Map<String, String> getRequiredRPackageMap() {
        return this.requiredRPackageMap;
    }

    public Choice getChoice(String string) {
        int n = this.getIndexOf(string);
        return n < 0 ? null : this.choices.get(n);
    }

    public int getIndexOf(String string) {
        if (this.choices == null) {
            return -1;
        }
        if (this.choices.size() > 10) {
            Integer n;
            if (this.valueToIndexMap == null) {
                this.valueToIndexMap = new HashMap<String, Integer>(this.choices.size());
                for (int i = 0; i < this.choices.size(); ++i) {
                    this.valueToIndexMap.put(this.choices.get(i).getValue(), i);
                }
            }
            if ((n = this.valueToIndexMap.get(string)) != null) {
                return n;
            }
        } else {
            for (int i = 0; i < this.choices.size(); ++i) {
                if (!this.choices.get(i).getValue().equals(string)) continue;
                return i;
            }
        }
        return -1;
    }

    public boolean isAcceptable(String string) {
        return this.isChoiceEditable() || this.getIndexOf(string) >= 0;
    }

    public String getLabel(int n, ValueMap valueMap) {
        String string;
        if (!this.isLabel()) {
            return null;
        }
        if (this.choices == null) {
            return null;
        }
        if (this.templateMap != null && (string = this.templateMap.get(this.choices.get(n).getValue())) != null) {
            String string2 = (String)valueMap.getDynamicDefaultValue(this);
            if (string2 == null) {
                string2 = "";
            }
            return MessageFormat.format(string, string2);
        }
        if (n < 0 || n >= this.choices.size()) {
            return null;
        }
        return this.choices.get(n).getLabel();
    }

    public String getLabel(String string, ValueMap valueMap) {
        if (!this.isLabel()) {
            return null;
        }
        int n = this.getIndexOf(string);
        if (n < 0) {
            if (string.isEmpty() && this.isDynamicDefault()) {
                return (String)valueMap.getDynamicDefaultValue(this);
            }
            return null;
        }
        return this.getLabel(n, valueMap);
    }

    public String getValue(String string) {
        if (!this.isLabel() || this.choices == null) {
            return null;
        }
        if (this.labelToValueMap == null) {
            this.labelToValueMap = new HashMap<String, String>(this.choices.size());
            for (Choice choice : this.choices) {
                if (!choice.isLabel()) continue;
                this.labelToValueMap.put(choice.getLabel(), choice.getValue());
            }
        }
        return this.labelToValueMap.get(string);
    }

    public boolean isChoiceEditable() {
        return this.choiceEditable;
    }

    public BatchAddSupport<?> getBatchAddSupport() {
        return new ChoiceBatchAddSupport(this);
    }

    @Override
    public boolean isSearchable() {
        return this.isChoiceEditable();
    }

    @Override
    public Object stringToValue(String string) {
        return super.stringToValue(string);
    }

    @Override
    public void localize(Map<String, String> map) {
        super.localize(map);
        if (this.choices != null && this.isLabel()) {
            for (int i = 0; i < this.choices.size(); ++i) {
                Choice choice = this.choices.get(i);
                if (choice.getLabel() == null) continue;
                choice.setLabel(ChoiceKey.valueOrDefault(map, choice.getLabel()));
            }
        }
    }

    @Override
    public void localizationValues(List<String> list) {
        super.localizationValues(list);
        if (this.choices != null && this.isLabel()) {
            for (Choice choice : this.choices) {
                if (choice.getLabel() == null) continue;
                list.add(choice.getLabel());
            }
        }
    }

    @Override
    protected void toYaml(Map<Object, Object> map) {
        super.toYaml(map);
        if (!this.isDynamic() && this.choices != null) {
            ArrayList<Object> arrayList = new ArrayList<Object>(this.choices.size());
            for (Choice choice : this.choices) {
                arrayList.add(choice.toYamlValue(null));
            }
            map.put("choices", arrayList);
        }
        map.put("value-and-label", this.showValueAndLabel);
        map.put("input", this.choiceEditable);
    }

    public static abstract class Builder<T extends Builder<T>>
    extends StrKey.Builder<T> {
        protected List<Choice> choices;
        private boolean showValueAndLabel;
        private boolean choiceEditable;
        private ChoiceProvider choiceProvider;
        private Map<String, String> templateMap;
        private Map<String, String> requiredRPackageMap;

        public Builder(String string, String string2) {
            super(string, string2);
            this.setChoiceEditable(false);
        }

        @Override
        protected abstract T self();

        @Override
        public ChoiceKey build() {
            return new ChoiceKey(this);
        }

        public T setChoiceEditable(boolean bl) {
            this.choiceEditable = bl;
            return (T)this.self();
        }

        public T setValues(String ... stringArray) {
            this.choices = new ArrayList<Choice>(stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                this.choices.add(new Choice(stringArray[i], null));
            }
            return (T)this.self();
        }

        public T setLabels(String ... stringArray) {
            if (this.choices == null) {
                throw new RuntimeException("call setValues first");
            }
            for (int i = 0; i < this.choices.size(); ++i) {
                this.choices.get(i).setLabel(stringArray[i]);
            }
            return (T)this.self();
        }

        public T setValuesAndLabels(String ... stringArray) {
            int n = stringArray.length / 2;
            this.choices = new ArrayList<Choice>(n);
            for (int i = 0; i < n; ++i) {
                int n2 = 2 * i;
                this.choices.add(new Choice(stringArray[n2], stringArray[n2 + 1]));
            }
            return (T)this.self();
        }

        public T setRequiredRPackageMap(Map<String, String> map) {
            this.requiredRPackageMap = map;
            return (T)this.self();
        }

        public T setChoices(List<Choice> list) {
            this.choices = list;
            return (T)this.self();
        }

        public T showValueAndLabel(boolean bl) {
            this.showValueAndLabel = bl;
            return (T)this.self();
        }

        public T setKeys(Key<?> ... keyArray) {
            this.choices = new ArrayList<Choice>(keyArray.length);
            for (int i = 0; i < keyArray.length; ++i) {
                this.choices.add(new Choice(keyArray[i].getId(), keyArray[i].getTitle()));
            }
            return (T)this.self();
        }

        public T setLabelTemplate(String string, String string2) {
            if (this.templateMap == null) {
                this.templateMap = new HashMap<String, String>(2);
            }
            this.templateMap.put(string, string2);
            return (T)this.self();
        }

        public T setChoiceProvider(ChoiceProvider choiceProvider) {
            this.choiceProvider = choiceProvider;
            return (T)this.self();
        }
    }

    private static class Builder2
    extends Builder<Builder2> {
        public Builder2(String string, String string2) {
            super(string, string2);
        }

        @Override
        protected Builder2 self() {
            return this;
        }
    }
}

