/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.common.keyvalue;

import com.ef_prime.rflow.core.common.keyvalue.BasicValueError;
import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.keyvalue.ListModelKey;
import com.ef_prime.rflow.core.common.keyvalue.ValidationContext;
import com.ef_prime.rflow.core.common.keyvalue.Validator;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.core.common.keyvalue.ValueMapKey;
import com.ef_prime.rflow.core.common.list.ListModel;
import com.ef_prime.rflow.core.feature.search.SearchContext;
import com.ef_prime.rflow.core.feature.search.SearchResult;
import com.ef_prime.rflow.resource.Messages;
import java.util.List;
import java.util.function.Function;

public class ComponentTableKey
extends ListModelKey<ValueMap> {
    protected ComponentTableKey(Builder<?> builder) {
        super(builder);
    }

    public static Builder<?> builder(String string, String string2, ValueMapKey valueMapKey) {
        return new Builder2(string, string2, valueMapKey);
    }

    public ValueMapKey getColumnKey() {
        return (ValueMapKey)super.getColumnKey();
    }

    @Override
    protected void validate(ListModel<ValueMap> listModel, ValidationContext validationContext) {
        super.validate(listModel, validationContext);
        if (listModel != null) {
            for (ValueMap valueMap : listModel) {
                ValidationContext validationContext2 = valueMap.getValidationContext();
                if (!validationContext2.isError()) continue;
                validationContext.addAllErrors(this, validationContext2.getAllErrors(0));
            }
        }
    }

    @Override
    public boolean isSearchable() {
        return true;
    }

    @Override
    public void search(List<SearchResult> list, SearchContext searchContext, Object object, ValueMap valueMap) {
        ListModel listModel = (ListModel)object;
        this.searchValueMapList(listModel.iterator(), list, searchContext);
    }

    @Override
    public boolean replace(SearchContext searchContext, String string, SearchResult searchResult, List<SearchResult> list, Object object, ValueMap valueMap) {
        final ListModel listModel = (ListModel)object;
        return this.replaceValueMapList(searchContext, string, searchResult, list, new Function<Integer, ValueMap>(){

            @Override
            public ValueMap apply(Integer n) {
                if (n < 0 || n >= listModel.getSize()) {
                    return null;
                }
                return (ValueMap)listModel.get(n);
            }
        });
    }

    public static Validator createIgnoreEmptyValidator(final ValueMap valueMap) {
        return new Validator(){

            @Override
            public void validate(Key<?> key, Object object, ValidationContext validationContext) {
                if (valueMap.isEmpty()) {
                    BasicValueError basicValueError = new BasicValueError(1, Messages.getString("Message.row_ignored"), null);
                    basicValueError.setHighPriority(true);
                    validationContext.addError(this, basicValueError);
                }
            }
        };
    }

    private static class Builder2
    extends Builder<Builder2> {
        public Builder2(String string, String string2, ValueMapKey valueMapKey) {
            super(string, string2, valueMapKey);
        }

        @Override
        protected Builder2 self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>>
    extends ListModelKey.Builder<ValueMap, T> {
        public Builder(String string, String string2, ValueMapKey valueMapKey) {
            super(string, string2, valueMapKey);
            this.setGrowX(true);
            this.setGrowY(true);
            this.setLabelPosition("top");
        }

        public ComponentTableKey build() {
            if (!this.isDefaultValue()) {
                this.setDefaultValue(this.buildModel());
            }
            return new ComponentTableKey(this);
        }

        @Override
        protected abstract T self();
    }
}

