/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.common.keyvalue;

import com.ef_prime.rflow.core.common.keyvalue.AbstractValueError;
import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.keyvalue.ValueError;
import com.ef_prime.rflow.resource.Messages;
import java.util.ArrayList;
import java.util.List;

public class CompoundValueError
extends AbstractValueError {
    private Key<?> key;
    private List<ValueError> errors;

    public CompoundValueError(Key<?> key, List<ValueError> list) {
        if (list == null || list.isEmpty()) {
            throw new IllegalArgumentException("Error is empty");
        }
        this.key = key;
        this.errors = list;
        for (ValueError valueError : list) {
            valueError.setParent(this);
        }
    }

    public static ValueError convert(List<ValueError> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        return new CompoundValueError(list.get(0).getKey(), list);
    }

    @Override
    public int getLevel() {
        int n = 1;
        if (this.errors != null) {
            for (ValueError valueError : this.errors) {
                if (n >= valueError.getLevel()) continue;
                n = valueError.getLevel();
            }
        }
        return n;
    }

    @Override
    public String getMessage(boolean bl, boolean bl2) {
        ArrayList<ValueError> arrayList = new ArrayList<ValueError>();
        this.getAllErrorsInside(arrayList, this);
        if (arrayList.isEmpty()) {
            return "";
        }
        arrayList.sort(LEVEL_COMPARATOR);
        int n = 5;
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = Math.min(arrayList.size(), n);
        for (int i = 0; i < n2; ++i) {
            ValueError valueError = (ValueError)arrayList.get(i);
            if (bl2) {
                stringBuilder.append("[" + valueError.getLevelName() + "] ");
            }
            stringBuilder.append(valueError.getMessage(bl, bl2));
            if (i == n2 - 1) continue;
            stringBuilder.append("\n");
        }
        if (arrayList.size() > n) {
            stringBuilder.append("\n (");
            stringBuilder.append(Messages.format("Error.more", Integer.toString(arrayList.size() - n)));
            stringBuilder.append(")");
        }
        return stringBuilder.toString();
    }

    @Override
    public boolean isContainer() {
        return true;
    }

    @Override
    public List<ValueError> getChildren() {
        return this.errors;
    }

    private void getAllErrorsInside(List<ValueError> list, ValueError valueError) {
        if (valueError.isContainer()) {
            for (ValueError valueError2 : valueError.getChildren()) {
                this.getAllErrorsInside(list, valueError2);
            }
        } else if (valueError.getLevel() > 1) {
            list.add(valueError);
        }
    }

    @Override
    public Key<?> getKey() {
        return this.key;
    }
}

