/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.common.keyvalue;

import com.ef_prime.rflow.core.common.keyvalue.AtomicKey;
import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.util.YamlEx;

public class DoubleKey
extends AtomicKey<Double> {
    public DoubleKey(String string, String string2, double d) {
        super(string, string2, d);
    }

    protected DoubleKey(Builder<?> builder) {
        super(builder);
    }

    public static Builder<?> builder(String string, String string2) {
        return new Builder2(string, string2);
    }

    @Override
    protected String getYamlType() {
        return "double";
    }

    @Override
    public String valueToString(Object object) {
        return Double.toString((Double)object);
    }

    @Override
    public Object stringToValue(String string) {
        return Double.valueOf(string);
    }

    @Override
    public Object yamlValueToValue(YamlEx yamlEx, Object object) throws Exception {
        if (object instanceof Double) {
            return object;
        }
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        throw new Exception("Uncompatible value for DoubleKey");
    }

    @Override
    public Double copyValue(Double d) {
        return d;
    }

    @Override
    public Class<?> getJavaClass() {
        return Double.class;
    }

    private static class Builder2
    extends Builder<Builder2> {
        public Builder2(String string, String string2) {
            super(string, string2);
        }

        @Override
        protected Builder2 self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>>
    extends Key.Builder<Double, T> {
        public Builder(String string, String string2) {
            super(string, string2);
            this.setMinWidth(50);
        }

        @Override
        protected abstract T self();

        public DoubleKey build() {
            return new DoubleKey(this);
        }
    }
}

