/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.common.keyvalue;

import com.ef_prime.rflow.core.common.keyvalue.StrKey;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class FileKey
extends StrKey {
    public static final int FILE_ONLY = 0;
    public static final int DIRECTORY_ONLY = 1;
    public static final int FILE_OR_DIRECTORY = 2;
    public static final int MULTIPLE_FILES = 3;
    public static final int TYPE_OPEN = 0;
    public static final int TYPE_SAVE = 1;
    public static final String DEFAULT_DIRECTORY_WORKINGSPACE = ":workingspace";
    public static final String DEFAULT_DIRECTORY_PROJECTS_HOME = ":projects_home";
    public static final String DEFAULT_DIRECTORY_USER_DOCUMENTS = ":user_documents";
    private static final int DEFAULT_MIN_WIDTH = 300;
    private int mode;
    private int type;
    private String defaultDirectory = ":workingspace";
    private boolean abstractPathEnabled = true;
    private boolean fileNameEdit;
    private List<FileExtensionFilter> extensionFilters;

    public FileKey(Map<?, ?> map) {
        super(map);
        this.mode = 0;
        if (!map.containsKey("minWidth")) {
            this.minWidth = 300;
        }
    }

    protected FileKey(Builder<?> builder) {
        super((StrKey.Builder<?>)builder);
        this.mode = builder.mode;
        this.type = builder.type;
        if (builder.defaultDirectory != null) {
            this.defaultDirectory = builder.defaultDirectory;
        }
        this.abstractPathEnabled = builder.abstractPathEnabled;
        this.fileNameEdit = builder.fileNameEdit;
        this.extensionFilters = builder.extensionFilters;
    }

    public int getMode() {
        return this.mode;
    }

    public int getType() {
        return this.type;
    }

    public String getDefaultDirectory() {
        return this.defaultDirectory;
    }

    public boolean isAbstractPathEnabled() {
        return this.abstractPathEnabled;
    }

    public boolean isFileNameEdit() {
        return this.fileNameEdit;
    }

    public List<FileExtensionFilter> getExtensionFilters() {
        return this.extensionFilters;
    }

    public static Builder<?> builder(String string, String string2) {
        return new Builder2(string, string2);
    }

    @Override
    protected String getYamlType() {
        return "file";
    }

    @Override
    protected void toYaml(Map<Object, Object> map) {
        super.toYaml(map);
    }

    public static abstract class Builder<T extends Builder<T>>
    extends StrKey.Builder<T> {
        private int mode = 0;
        private int type = 0;
        private String defaultDirectory;
        private boolean abstractPathEnabled = true;
        private boolean fileNameEdit;
        private List<FileExtensionFilter> extensionFilters;

        public Builder(String string, String string2) {
            super(string, string2);
            this.setMinWidth(300);
        }

        @Override
        protected abstract T self();

        @Override
        public FileKey build() {
            return new FileKey(this);
        }

        public T setMode(int n) {
            this.mode = n;
            return (T)this.self();
        }

        public T setType(int n) {
            this.type = n;
            return (T)this.self();
        }

        public T setDefaultDirectory(String string) {
            this.defaultDirectory = string;
            return (T)this.self();
        }

        public T setAbstractPathEnabled(boolean bl) {
            this.abstractPathEnabled = bl;
            return (T)this.self();
        }

        public T setFileNameEdit(boolean bl) {
            this.fileNameEdit = bl;
            return (T)this.self();
        }

        public T setExtensionFilters(List<FileExtensionFilter> list) {
            this.extensionFilters = list;
            return (T)this.self();
        }

        public T addExtensionFilters(FileExtensionFilter fileExtensionFilter) {
            if (this.extensionFilters == null) {
                this.extensionFilters = new ArrayList<FileExtensionFilter>(4);
            }
            this.extensionFilters.add(fileExtensionFilter);
            return (T)this.self();
        }
    }

    private static class Builder2
    extends Builder<Builder2> {
        public Builder2(String string, String string2) {
            super(string, string2);
        }

        @Override
        protected Builder2 self() {
            return this;
        }
    }

    public static class FileExtensionFilter {
        private String description;
        private String[] extensions;

        public FileExtensionFilter(String string, String ... stringArray) {
            this.description = string;
            this.extensions = stringArray;
        }

        public String getDescription() {
            return this.description;
        }

        public String[] getExtensions() {
            return this.extensions;
        }
    }
}

