/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.common.keyvalue;

import com.ef_prime.rflow.core.common.keyvalue.AtomicKey;
import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.util.YamlEx;

public class IntKey
extends AtomicKey<Integer> {
    public IntKey(String string, int n) {
        this(string, string, n);
    }

    public IntKey(String string, String string2, int n) {
        super(string, string2, n);
    }

    protected IntKey(Builder<?> builder) {
        super(builder);
    }

    public static Builder<?> builder(String string, String string2) {
        return new Builder2(string, string2);
    }

    @Override
    protected String getYamlType() {
        return "int";
    }

    @Override
    public String valueToString(Object object) {
        return Integer.toString((Integer)object);
    }

    @Override
    public Object stringToValue(String string) {
        return Integer.valueOf(string);
    }

    @Override
    public Object yamlValueToValue(YamlEx yamlEx, Object object) throws Exception {
        if (object instanceof Integer) {
            return object;
        }
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        throw new Exception("Uncompatible value for IntKey");
    }

    @Override
    public Integer copyValue(Integer n) {
        return n;
    }

    @Override
    public Class<?> getJavaClass() {
        return Integer.class;
    }

    private static class Builder2
    extends Builder<Builder2> {
        public Builder2(String string, String string2) {
            super(string, string2);
        }

        @Override
        protected Builder2 self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>>
    extends Key.Builder<Integer, T> {
        public Builder(String string, String string2) {
            super(string, string2);
            this.setMinWidth(50);
            this.setDefaultValue(new Integer(0));
        }

        @Override
        protected abstract T self();

        public IntKey build() {
            return new IntKey(this);
        }
    }
}

